##############################################################################################################
##    Script Name    : upgradeWatchfolderProperties.sh                                                      ##
##    Author         : Sanjay Khattar                                                                       ##
##    Created on     : 08/07/2013                                                                           ##
##    Usage          : ./upgradeWatchfolderProperties.sh                                                    ##
##    Purpose        : Script for upgrading watchfolder.properties in tomcat watchfolder webapp.            ##
##                                                                                                          ##
##############################################################################################################

#!/bin/sh

##
## Upgrade /opt/tandbergtv/watchpoint/tomcat/webapps/watchfolder/WEB-INF/classes/watchfolder.properties.
## This basically means adding retryDelayInMins property to the watchfolder.properties file.
##

WATCHFOLDER_PROPERIES_PATH=/opt/tandbergtv/watchpoint/tomcat/webapps/watchfolder/WEB-INF/classes/watchfolder.properties
PROP_KEY_RETRYDELAYINMINS_ID="entry key=\"retryDelayInMins\""
PROP_KEY_RETRYDELAYINMINS_COMMENT="    <!-- Delay period (in minutes) in between retries to ping CMS-->"
PROP_KEY_RETRYDELAYINMINS_ENTRY="    <entry key=\"retryDelayInMins\">1</entry>"
PROPERTIES_END_TAG="</properties>"
TEMP_UPGRADED_FILE=$WATCHFOLDER_PROPERIES_PATH.upgraded.tmp
TIMESTAMP_PLACEHOLDER="<timestamp>"
UPDATE_MSG_TEMPLATE="    <!-- Updated by CMS 3.1 Upgrade at <timestamp> -->"

ACTIVITY="upgrading watchfolder properties file: $WATCHFOLDER_PROPERIES_PATH"

logBeginMsg "$ACTIVITY"

homedir=$(pwd) 

SUBACTIVITY="processing $PROP_KEY_RETRYDELAYINMINS_ID"

logBeginMsg "$SUBACTIVITY"

if grep "$PROP_KEY_RETRYDELAYINMINS_ID" "$WATCHFOLDER_PROPERIES_PATH"; then
    logMsg "$PROP_KEY_RETRYDELAYINMINS_ID already exists in $WATCHFOLDER_PROPERIES_PATH.";
    logMsg "No need to add..."
else
    # take backup of the original file
    cp -bvf $WATCHFOLDER_PROPERIES_PATH $WATCHFOLDER_PROPERIES_PATH.beforeUpgrade

    cat /dev/null > "$TEMP_UPGRADED_FILE"

    while IFS='' read -r line; do 
        
        if echo "$line" | grep -q "$PROPERTIES_END_TAG" ; then
            SUB_SUB_ACTIVITY="adding property $PROP_KEY_RETRYDELAYINMINS_ID"
            logBeginMsg "$SUB_SUB_ACTIVITY"
            
            currentTimeStamp=$(date)
            updateMsg=$(echo $UPDATE_MSG_TEMPLATE | sed -e "s/$TIMESTAMP_PLACEHOLDER/$currentTimeStamp/g")
            echo "$updateMsg" >> "$TEMP_UPGRADED_FILE"

            echo "$PROP_KEY_RETRYDELAYINMINS_COMMENT" >> "$TEMP_UPGRADED_FILE"
            echo "$PROP_KEY_RETRYDELAYINMINS_ENTRY" >> "$TEMP_UPGRADED_FILE"
            echo >> "$TEMP_UPGRADED_FILE"
            
            logDoneMsg "$SUB_SUB_ACTIVITY"
        fi
        
        printf "%s\n" "$line" >> "$TEMP_UPGRADED_FILE"
        
    done < $WATCHFOLDER_PROPERIES_PATH

    #rename the file
    mv -vf $TEMP_UPGRADED_FILE $WATCHFOLDER_PROPERIES_PATH
fi
 
logDoneMsg "$SUBACTIVITY"
 
cd $homedir

logDoneMsg "$ACTIVITY"
