/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.search;

import com.ericsson.cms.criteria.ExpList;
import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.SearchColumn;
import com.tandbergtv.metadatamanager.search.ConditionBuilder;
import com.tandbergtv.metadatamanager.search.SearchSchemaHelper;
import com.tandbergtv.metadatamanager.search.assetconditionbuilder.AssetConditionBuilder;
import com.tandbergtv.metadatamanager.util.CustomFieldXPathConverter;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AssetSearchQueryBuilder {
    private static final String MDM_ALIAS = "mdm";
    public static final String DOCID_ALIAS = "docId";
    private static final String COL_ALIAS = "mdm_col";

    public String buildQuery(ExpNode condition, boolean onlyOriginals, ExpNode generalConditions) {
        return this.buildQuery(condition, new ArrayList<SearchColumn>(), onlyOriginals, generalConditions);
    }

    public String buildQuery(ExpNode condition, List<SearchColumn> resultColumns, boolean onlyOriginals, ExpNode generalConditions) {
        StringBuilder query = new StringBuilder();
        this.buildSelect(query, resultColumns);
        query.append("from mdm_metadata ");
        query.append(MDM_ALIAS);
        query.append("\r\n");
        if (condition != null) {
            this.buildSingleAssetCondition(query, condition);
        }
        if (generalConditions != null && (generalConditions instanceof ExpValue || !((ExpList)generalConditions).isEmpty())) {
            query.append(" AND ");
            this.buildOtherConditions(generalConditions, query);
        }
        if (onlyOriginals) {
            if (condition != null) {
                query.append(" and ");
            }
            query.append(this.getOnlyOriginals());
        }
        return query.toString();
    }

    private void buildOtherConditions(ExpNode condition, StringBuilder query) {
        if (condition instanceof ExpValue) {
            Predicate predicate = ((ExpValue)condition).getPredicate();
            query.append(ConditionBuilder.getCondition(predicate));
        } else if (condition instanceof ExpList) {
            ExpList list = (ExpList)condition;
            List nodes = list.getNodes();
            if (nodes.isEmpty()) {
                return;
            }
            String listOperator = list.getSqlOperator();
            query.append("(");
            for (int i = 0; i < nodes.size(); ++i) {
                ExpNode node = (ExpNode)nodes.get(i);
                if (i > 0) {
                    query.append(listOperator);
                }
                this.buildOtherConditions(node, query);
            }
            query.append(")");
        }
    }

    public String buildQueryForFullDoc(ExpNode condition, boolean onlyOriginals) {
        StringBuilder query = new StringBuilder();
        query.append("select XMLSERIALIZE(content mdm.OBJECT_VALUE as clob no indent) \r\n");
        query.append("from mdm_metadata mdm\r\n");
        if (condition != null) {
            this.buildSingleAssetCondition(query, condition);
        }
        if (onlyOriginals) {
            if (condition != null) {
                query.append(" and ");
            }
            query.append(this.getOnlyOriginals());
        }
        return query.toString();
    }

    public String getOnlyOriginals() {
        LogicalOperator operator = LogicalOperator.ISNULL;
        Predicate origAssetCond = new Predicate("/@originalDocumentId", "ECMFSpec", FieldType.ASSET, operator, Boolean.valueOf(false));
        return ConditionBuilder.getCondition(origAssetCond);
    }

    private void buildSelect(StringBuilder query, List<SearchColumn> resultColumns) {
        query.append("Select ");
        boolean appendedDocId = false;
        for (int i = 0; i < resultColumns.size(); ++i) {
            SearchColumn sc = resultColumns.get(i);
            if (i > 0) {
                query.append(", ");
            }
            if (sc.getFieldName().equals("@documentId")) {
                appendedDocId = true;
                query.append(AssetSearchQueryBuilder.getExtractValue("ECMFSpec", "/@documentId"));
                query.append(" as ");
                query.append(DOCID_ALIAS);
                continue;
            }
            query.append(AssetSearchQueryBuilder.getExtractValue(sc.getSectionType(), sc.getFieldName()));
            query.append(" as ");
            query.append(COL_ALIAS + i);
        }
        if (!appendedDocId) {
            if (resultColumns.size() > 0) {
                query.append(", ");
            }
            query.append(AssetSearchQueryBuilder.getExtractValue("ECMFSpec", "/@documentId"));
            query.append(" as ");
            query.append(DOCID_ALIAS);
        }
        query.append("\r\n");
    }

    private void buildSingleAssetCondition(StringBuilder query, ExpNode condition) {
        query.append("where xmlexists('$p");
        String assetType = this.findFirstAssetType(condition);
        if (assetType.isEmpty() || assetType.equals("/") || assetType.equals("//")) {
            query.append("//*");
        } else {
            query.append(AssetSearchQueryBuilder.getEcmfComplientSectionType(assetType, true));
        }
        query.append("[");
        this.buildSingleAssetConditionRec(query, condition);
        query.append(" ]' passing sys_nc_rowinfo$ AS \"p\")");
    }

    private String findFirstAssetType(ExpNode condition) {
        if (condition instanceof ExpValue) {
            Predicate predicate = ((ExpValue)condition).getPredicate();
            return predicate.getFieldLeftSectionType();
        }
        if (condition instanceof ExpList) {
            ExpList list = (ExpList)condition;
            List nodes = list.getNodes();
            for (int i = 0; i < nodes.size(); ++i) {
                ExpNode node = (ExpNode)nodes.get(i);
                String assetType = this.findFirstAssetType(node);
                if (assetType == null) continue;
                return assetType;
            }
        }
        return null;
    }

    private void buildSingleAssetConditionRec(StringBuilder query, ExpNode condition) {
        if (condition instanceof ExpValue) {
            Predicate predicate = ((ExpValue)condition).getPredicate();
            query.append(AssetConditionBuilder.getCondition(predicate));
        } else if (condition instanceof ExpList) {
            ExpList list = (ExpList)condition;
            List nodes = list.getNodes();
            String listOperator = list.getOperator() == "AND" ? " and " : " or ";
            query.append("(");
            for (int i = 0; i < nodes.size(); ++i) {
                ExpNode node = (ExpNode)nodes.get(i);
                if (i > 0) {
                    query.append(listOperator);
                }
                this.buildSingleAssetConditionRec(query, node);
            }
            query.append(")");
        }
    }

    public static String getMultiValueSelect(String assetType, String xpath) {
        StringBuilder sb = new StringBuilder();
        sb.append("XMLCAST(XMLQuery('string-join($p");
        if (!xpath.startsWith("/")) {
            sb.append("*");
        }
        sb.append(AssetSearchQueryBuilder.getEcmfComplientSectionTypeWIndices(assetType, true));
        if (SearchSchemaHelper.isCustomField(xpath)) {
            sb.append(CustomFieldXPathConverter.getActualXpath(xpath));
        } else {
            sb.append(xpath);
        }
        sb.append(", \",\")' PASSING sys_nc_rowinfo$ AS \"p\" RETURNING CONTENT) as varchar2(2000))");
        return sb.toString();
    }

    private static String getCustmFieldSelect(String assetType, String xpath) {
        StringBuilder sb = new StringBuilder();
        String dataType = DataTypeMappingReader.getInstance().determineDataType(xpath);
        sb.append("xmlcast(XMLQuery('");
        sb.append(AssetSearchQueryBuilder.getEcmfComplientSectionTypeWIndices(assetType, true));
        String custXpath = CustomFieldXPathConverter.getActualXpath(xpath);
        int lastSlash = custXpath.lastIndexOf("/");
        custXpath = custXpath.substring(0, lastSlash) + "[1]" + custXpath.substring(lastSlash);
        sb.append(custXpath);
        sb.append("' PASSING mdm.OBJECT_VALUE RETURNING CONTENT) AS ");
        if (dataType.equals("date")) {
            sb.append("TIMESTAMP)");
        } else {
            sb.append("VARCHAR2(2000))");
        }
        return sb.toString();
    }

    private static String getFieldSelectWithCond(String assetType, String xpath) {
        StringBuilder sb = new StringBuilder();
        StringBuilder currentNode = new StringBuilder();
        StringBuilder currentCondition = new StringBuilder();
        ArrayList<String> conditions = new ArrayList<String>();
        boolean inCondition = false;
        for (char c : xpath.toCharArray()) {
            if (c == '/' && !inCondition) {
                currentNode = new StringBuilder();
                conditions.add(currentCondition.toString());
                currentCondition = new StringBuilder();
                sb.append(c);
                continue;
            }
            if (c == '[' && !currentNode.toString().equals("CustomField")) {
                inCondition = true;
                continue;
            }
            if (c == ']' && inCondition) {
                inCondition = false;
                continue;
            }
            if (inCondition) continue;
            currentNode.append(c);
            sb.append(c);
        }
        String field = sb.toString();
        if (SearchSchemaHelper.isCustomField(field)) {
            field = CustomFieldXPathConverter.getActualXpath(field);
        }
        inCondition = false;
        StringBuilder result = new StringBuilder();
        Iterator condIterator = conditions.iterator();
        result.append("xmlcast(XMLQuery('");
        result.append(AssetSearchQueryBuilder.getEcmfComplientSectionTypeWIndices(assetType, true).replace("File[1]", "File"));
        for (char c : field.toCharArray()) {
            if (c == '/') {
                result.append((String)condIterator.next());
                result.append(c);
                continue;
            }
            if (inCondition) continue;
            currentNode.append(c);
            result.append(c);
        }
        result.append("' PASSING mdm.OBJECT_VALUE RETURNING CONTENT) AS VARCHAR2(2000))");
        return result.toString();
    }

    public static String getExtractValue(String assetType, String xpath) {
        if (SearchSchemaHelper.isCustomField(xpath)) {
            return AssetSearchQueryBuilder.getCustmFieldSelect(assetType, xpath);
        }
        if (xpath.contains("[")) {
            return AssetSearchQueryBuilder.getFieldSelectWithCond(assetType, xpath);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("extractvalue(sys_nc_rowinfo$, '");
        sb.append(AssetSearchQueryBuilder.getDisplayXpath(assetType, xpath));
        sb.append("')");
        return sb.toString();
    }

    public static String getDisplayXpath(String assetType, String xpath) {
        if (assetType.endsWith("ECMFSpec")) {
            String result = assetType + xpath;
            if (!result.startsWith("/")) {
                result = "/" + result;
            }
            return result;
        }
        SearchSchemaHelper ssh = new SearchSchemaHelper();
        return ssh.prepareSelectXpath(assetType, xpath);
    }

    public static String getEcmfComplientSectionTypeWIndices(String assetType, boolean includeEcmf) {
        return AssetSearchQueryBuilder.getEcmfComplientSectionType(assetType, includeEcmf, true);
    }

    public static String getEcmfComplientSectionType(String assetType, boolean includeEcmf) {
        return AssetSearchQueryBuilder.getEcmfComplientSectionType(assetType, includeEcmf, false);
    }

    private static String getEcmfComplientSectionType(String assetType, boolean includeEcmf, boolean includeIndex) {
        StringBuffer sb = new StringBuffer();
        if (assetType.isEmpty() || assetType.equals("//")) {
            return "/";
        }
        if (assetType.startsWith("/")) {
            return assetType;
        }
        if (assetType.startsWith("ECMFSpec")) {
            return "/" + assetType;
        }
        if (includeEcmf) {
            sb.append("/ECMFSpec/");
        }
        if (!assetType.toUpperCase().startsWith("PACKAGE") && !assetType.toUpperCase().startsWith("SERIES")) {
            sb.append("Package/");
        }
        SearchSchemaHelper ssh = new SearchSchemaHelper();
        sb.append(ssh.getCorrectedAssetPath(assetType, includeIndex));
        return sb.toString();
    }

    public static String encodeString(String str) {
        char[] characters = str.toCharArray();
        StringBuffer sb = new StringBuffer();
        for (char c : characters) {
            if (c == '_' || c == '-') {
                sb.append("\\");
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

