/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.search;

import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.tandbergtv.metadatamanager.search.AssetSearchQueryBuilder;
import com.tandbergtv.metadatamanager.search.BooleanConditionBuilder;
import com.tandbergtv.metadatamanager.search.DateConditionBuilder;
import com.tandbergtv.metadatamanager.search.NumberConditionBuilder;
import com.tandbergtv.metadatamanager.search.SearchSchemaHelper;
import com.tandbergtv.metadatamanager.search.StringConditionBuilder;
import com.tandbergtv.metadatamanager.search.TimeConditionBuilder;
import com.tandbergtv.metadatamanager.util.CustomFieldXPathConverter;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;

public class ConditionBuilder {
    private static final String CONTAINS_HASPATH = "contains(mdm.OBJECT_VALUE, 'HASPATH(";
    public static final String CUSTOM_FIELD = "/Fields/CustomFields/CustomField";
    public static final String CUSTOM_FIELD_CHECK = "/Fields/CustomFields/CustomField[@name=";
    private SearchSchemaHelper ssh = new SearchSchemaHelper();
    protected static final String XML_EXISTS_START = "xmlexists('$p";
    protected static final String XM_EXTRACT_START = "extract(mdm.OBJECT_VALUE, '";
    protected static final String XML_EXISTS_END = "' passing sys_nc_rowinfo$ as \"p\")";
    protected static final String UNPARSABLE_PATH = "/UnparsableFields/UnparsableField";
    protected static final String UNPARSABLE_ATTRIBUTE = "@xpath";
    protected static final String XMLQUERY_FOR_CUSTOM_FIELD = "xmlcast(XMLQUERY('";
    protected static final String RETURNING_CONTENT_AS_OBJECT = " PASSING MDM.OBJECT_VALUE AS \"p\" RETURNING CONTENT) as varchar2(4000) ";
    protected Predicate predicate;

    protected ConditionBuilder(Predicate predicate) {
        this.predicate = predicate;
    }

    protected boolean isCustomField() {
        return this.predicate.getFieldLeft().startsWith(CUSTOM_FIELD_CHECK);
    }

    protected String getCustFieldName() {
        if (this.isCustomField()) {
            String field = this.predicate.getFieldLeft();
            return "@name=\"" + field.substring(39, field.indexOf("]")) + "\"";
        }
        return "";
    }

    protected String getCustomFieldXpath() {
        return this.getXpathStart() + CUSTOM_FIELD;
    }

    protected String getCustomCriteria() {
        return this.getCustFieldName() + " and ";
    }

    protected String getRhsValue(int index) {
        PredicateRightValue prv = (PredicateRightValue)this.predicate;
        return ConditionBuilder.encodeValue((String)prv.getValue().get(index));
    }

    protected int getRhsValueCount() {
        PredicateRightValue prv = (PredicateRightValue)this.predicate;
        return prv.getValue().size();
    }

    public static String encodeValue(String value) {
        StringBuffer sb = new StringBuffer();
        for (char c : value.toCharArray()) {
            if (c == '\'') {
                sb.append("''");
                continue;
            }
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            if (c == '\"') {
                sb.append("\"\"");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected List<String> getValues() {
        PredicateRightValue prv = (PredicateRightValue)this.predicate;
        return prv.getValue();
    }

    protected String getFullXpath() {
        StringBuffer sb = new StringBuffer(this.getXpathStart());
        String fieldLeft = this.predicate.getFieldLeft();
        if (this.isCustomField()) {
            fieldLeft = CustomFieldXPathConverter.getActualXpath(fieldLeft);
        }
        if (!fieldLeft.startsWith("/") && !fieldLeft.isEmpty()) {
            sb.append("/");
        }
        sb.append(fieldLeft);
        return sb.toString();
    }

    protected String getDollarPXpath() {
        return "$p" + this.getFullXpath();
    }

    protected String getXpathStart() {
        return AssetSearchQueryBuilder.getEcmfComplientSectionType(this.predicate.getFieldLeftSectionType(), true);
    }

    protected String getXpathMinusTail() {
        StringBuffer sb = new StringBuffer(this.getXpathStart());
        String fieldLeft = this.predicate.getFieldLeft();
        int stopIndex = fieldLeft.lastIndexOf("/");
        sb.append(fieldLeft.substring(0, stopIndex));
        if (stopIndex == 0 && this.predicate.fieldLeftIsWildCard()) {
            sb.append("/*");
        }
        return sb.toString();
    }

    protected String getXpathTail() {
        String fieldLeft = this.predicate.getFieldLeft();
        if (this.isCustomField()) {
            fieldLeft = CustomFieldXPathConverter.getActualXpath(fieldLeft);
        }
        int startIndex = fieldLeft.lastIndexOf("/") + 1;
        return fieldLeft.substring(startIndex);
    }

    protected String isEmpty() {
        StringBuilder condition = new StringBuilder();
        if (this.predicate.getFieldLeftSectionType().endsWith("ECMFSpec") && this.predicate.getFieldLeft().startsWith("/@")) {
            condition.append("not(");
            condition.append(XML_EXISTS_START);
            condition.append(this.getFullXpath());
            condition.append(XML_EXISTS_END);
            condition.append(")");
            return condition.toString();
        }
        if (this.isCustomField()) {
            condition.append(this.getCustomFieldXMLQuery());
            condition.append(") is null ");
        } else {
            condition.append(CONTAINS_HASPATH);
            condition.append(this.getFullXpath());
            condition.append(")')=0 ");
        }
        if (this.predicate.getFieldLeft().startsWith("/Fields")) {
            condition.insert(0, "(");
            condition.append(" AND  not(");
            condition.append(XML_EXISTS_START);
            condition.append(this.getXpathStart());
            condition.append(UNPARSABLE_PATH);
            condition.append("[");
            condition.append("fn:starts-with");
            condition.append("(");
            condition.append(UNPARSABLE_ATTRIBUTE);
            condition.append(", \"");
            condition.append(this.predicate.getFieldLeft());
            condition.append("\")]");
            condition.append(XML_EXISTS_END);
            condition.append("))");
        }
        return condition.toString();
    }

    private String getCustomFieldXMLQuery() {
        StringBuilder condition = new StringBuilder();
        condition.append(XMLQUERY_FOR_CUSTOM_FIELD);
        condition.append(this.getDollarPXpath());
        condition.append("'");
        condition.append(RETURNING_CONTENT_AS_OBJECT);
        return condition.toString();
    }

    protected String isNotEmpty() {
        StringBuffer condition = new StringBuffer();
        if (this.predicate.getFieldLeftSectionType().endsWith("ECMFSpec") && this.predicate.getFieldLeft().startsWith("/@")) {
            condition.append(XML_EXISTS_START);
            condition.append(this.getFullXpath());
            condition.append(XML_EXISTS_END);
            return condition.toString();
        }
        if (this.isCustomField()) {
            condition.append(this.getCustomFieldXMLQuery());
            condition.append(") is not null ");
        } else {
            condition.append(CONTAINS_HASPATH);
            condition.append(this.getFullXpath());
            condition.append(")') > 0 ");
        }
        if (this.predicate.getFieldLeft().startsWith("/Fields")) {
            condition.insert(0, "(");
            condition.append(" OR ");
            condition.append(XML_EXISTS_START);
            condition.append(this.getXpathStart());
            condition.append(UNPARSABLE_PATH);
            condition.append("[");
            condition.append("fn:starts-with");
            condition.append("(");
            condition.append(UNPARSABLE_ATTRIBUTE);
            condition.append(", \"");
            condition.append(this.predicate.getFieldLeft());
            condition.append("\")]");
            condition.append(XML_EXISTS_END);
            condition.append(")");
        }
        return condition.toString();
    }

    protected String containsUnparsable() {
        StringBuffer condition = new StringBuffer();
        condition.append(XML_EXISTS_START);
        condition.append(AssetSearchQueryBuilder.getEcmfComplientSectionType(this.predicate.getFieldLeftSectionType(), true));
        condition.append(UNPARSABLE_PATH);
        if (!this.predicate.getFieldLeft().isEmpty()) {
            condition.append("[");
            condition.append("fn:starts-with");
            condition.append("(");
            condition.append(UNPARSABLE_ATTRIBUTE);
            condition.append(", \"");
            condition.append(this.predicate.getFieldLeft());
            condition.append("\")]");
            condition.append(XML_EXISTS_END);
        } else {
            condition.append(XML_EXISTS_END);
            try {
                List<String> assetPaths = this.ssh.getChildAssetTypes(this.predicate.getFieldLeftSectionType());
                for (String assetPath : assetPaths) {
                    condition.append(" or ");
                    condition.append(XML_EXISTS_START);
                    condition.append(AssetSearchQueryBuilder.getEcmfComplientSectionType(assetPath, true));
                    condition.append(UNPARSABLE_PATH);
                    condition.append(XML_EXISTS_END);
                }
                if (assetPaths.size() > 0) {
                    condition.insert(0, "(");
                    condition.append(")");
                }
            }
            catch (XPathExpressionException e) {
                throw new RuntimeException(e);
            }
        }
        return condition.toString();
    }

    protected String notContainsUnparsable() {
        StringBuffer condition = new StringBuffer();
        condition.append("not(");
        condition.append(XML_EXISTS_START);
        condition.append(AssetSearchQueryBuilder.getEcmfComplientSectionType(this.predicate.getFieldLeftSectionType(), true));
        condition.append(UNPARSABLE_PATH);
        if (!this.predicate.getFieldLeft().isEmpty()) {
            condition.append("[");
            condition.append("fn:starts-with");
            condition.append("(");
            condition.append(UNPARSABLE_ATTRIBUTE);
            condition.append(", \"");
            condition.append(this.predicate.getFieldLeft());
            condition.append("\")]");
            condition.append(XML_EXISTS_END);
            condition.append(")");
        } else {
            condition.append(XML_EXISTS_END);
            condition.append(")");
            try {
                List<String> assetPaths = this.ssh.getChildAssetTypes(this.predicate.getFieldLeftSectionType());
                for (String assetPath : assetPaths) {
                    condition.append(" and not(");
                    condition.append(XML_EXISTS_START);
                    condition.append(AssetSearchQueryBuilder.getEcmfComplientSectionType(assetPath, true));
                    condition.append(UNPARSABLE_PATH);
                    condition.append(XML_EXISTS_END);
                    condition.append(")");
                }
                if (assetPaths.size() > 0) {
                    condition.insert(0, "(");
                    condition.append(")");
                }
            }
            catch (XPathExpressionException e) {
                throw new RuntimeException(e);
            }
        }
        return condition.toString();
    }

    protected String contains() {
        throw this.getUnsupportedOp();
    }

    protected String endsWith() {
        throw this.getUnsupportedOp();
    }

    protected String equal() {
        throw this.getUnsupportedOp();
    }

    protected String greaterThan() {
        throw this.getUnsupportedOp();
    }

    protected String greaterThanEqual() {
        throw this.getUnsupportedOp();
    }

    protected String greaterThanToday() {
        throw this.getUnsupportedOp();
    }

    protected String in() {
        throw this.getUnsupportedOp();
    }

    protected String lessThan() {
        throw this.getUnsupportedOp();
    }

    protected String lessThanEqual() {
        throw this.getUnsupportedOp();
    }

    protected String lessThanToday() {
        throw this.getUnsupportedOp();
    }

    protected String notContains() {
        throw this.getUnsupportedOp();
    }

    protected String notEqual() {
        throw this.getUnsupportedOp();
    }

    protected String startsWith() {
        throw this.getUnsupportedOp();
    }

    protected String notIn() {
        throw this.getUnsupportedOp();
    }

    protected String notLessThanToday() {
        throw this.getUnsupportedOp();
    }

    protected String notGreaterThanToday() {
        throw this.getUnsupportedOp();
    }

    protected String between() {
        throw this.getUnsupportedOp();
    }

    protected String doesNotEndWith() {
        throw this.getUnsupportedOp();
    }

    protected String doesNotStartWith() {
        throw this.getUnsupportedOp();
    }

    protected String equalToToday() {
        throw this.getUnsupportedOp();
    }

    protected String notEqualToToday() {
        throw this.getUnsupportedOp();
    }

    private RuntimeException getUnsupportedOp() {
        return new RuntimeException("Unsupported Operation | xpath = " + this.predicate.getFieldLeft());
    }

    protected String simpleConditionHelper(String operator) {
        String xpathMinusTail;
        StringBuffer condition = new StringBuffer(XML_EXISTS_START);
        String customCriteria = "";
        if (this.isCustomField()) {
            xpathMinusTail = this.getCustomFieldXpath();
            customCriteria = this.getCustFieldName() + " and ";
        } else {
            xpathMinusTail = this.getXpathMinusTail();
        }
        condition.append(xpathMinusTail);
        condition.append("[");
        condition.append(customCriteria);
        condition.append(this.getXpathTail());
        condition.append(operator);
        condition.append(this.getRhsValue(0));
        condition.append("]");
        condition.append(XML_EXISTS_END);
        return condition.toString();
    }

    protected String inHelper(String conjunction, String operator) {
        String xpathMinusTail;
        int valueCnt = this.getRhsValueCount();
        if (valueCnt == 0) {
            return "";
        }
        StringBuffer condition = new StringBuffer(XML_EXISTS_START);
        String customCriteria = "";
        if (this.isCustomField()) {
            xpathMinusTail = this.getCustomFieldXpath();
            customCriteria = this.getCustomCriteria();
        } else {
            xpathMinusTail = this.getXpathMinusTail();
        }
        String xpathTail = this.getXpathTail();
        condition.append(xpathMinusTail);
        condition.append("[");
        if (!customCriteria.isEmpty()) {
            condition.append(customCriteria);
            condition.append("(");
        }
        for (int i = 0; i < valueCnt; ++i) {
            if (i > 0) {
                condition.append(" ");
                condition.append(conjunction);
                condition.append(" ");
            }
            condition.append(xpathTail);
            condition.append(operator);
            condition.append(this.getRhsValue(i));
        }
        if (!customCriteria.isEmpty()) {
            condition.append(")");
        }
        condition.append("]");
        condition.append(XML_EXISTS_END);
        return condition.toString();
    }

    private static ConditionBuilder getConditionBuilder(Predicate predicate) {
        DataTypeMappingReader dtr = DataTypeMappingReader.getInstance();
        String dataType = dtr.determineDataType(predicate.getFieldLeft());
        if (dataType == null) {
            return new ConditionBuilder(predicate);
        }
        if (dataType.equals("integer") || dataType.equals("float")) {
            return new NumberConditionBuilder(predicate);
        }
        if (dataType.equals("string")) {
            return new StringConditionBuilder(predicate);
        }
        if (dataType.equals("time")) {
            return new TimeConditionBuilder(predicate);
        }
        if (dataType.equals("date")) {
            return new DateConditionBuilder(predicate);
        }
        if (dataType.equals("boolean")) {
            return new BooleanConditionBuilder(predicate);
        }
        return new ConditionBuilder(predicate);
    }

    private String getCondition() {
        switch (this.predicate.getSearchComplientOperator()) {
            case EQUAL: {
                return this.equal();
            }
            case NOTEQUAL: {
                return this.notEqual();
            }
            case LESSTHAN: {
                return this.lessThan();
            }
            case GREATERTHAN: {
                return this.greaterThan();
            }
            case LESSTHANEQUAL: {
                return this.lessThanEqual();
            }
            case GREATERTHANEQUAL: {
                return this.greaterThanEqual();
            }
            case ISNULL: {
                return this.isEmpty();
            }
            case ISNOTNULL: {
                return this.isNotEmpty();
            }
            case ISEMPTY: {
                return this.isEmpty();
            }
            case ISNOTEMPTY: {
                return this.isNotEmpty();
            }
            case CONTAINS: {
                return this.contains();
            }
            case DOESNOTCONTAIN: {
                return this.notContains();
            }
            case IN: {
                return this.in();
            }
            case NOTIN: {
                return this.notIn();
            }
            case STARTSWITH: {
                return this.startsWith();
            }
            case ENDSWITH: {
                return this.endsWith();
            }
            case DOESNOTSTARTWITH: {
                return this.doesNotStartWith();
            }
            case DOESNOTENDWITH: {
                return this.doesNotEndWith();
            }
            case GREATERTHANTODAY: {
                return this.greaterThanToday();
            }
            case LESSTHANTODAY: {
                return this.lessThanToday();
            }
            case EQUALTOTODAY: {
                return this.equalToToday();
            }
            case NOTEQUALTOTODAY: {
                return this.notEqualToToday();
            }
            case CONTAINSUNPARSABLE: {
                return this.containsUnparsable();
            }
            case DOESNOTCONTAINUNPARSABLE: {
                return this.notContainsUnparsable();
            }
            case NOTGREATERTHANTODAY: {
                return this.notGreaterThanToday();
            }
            case NOTLESSTHANTODAY: {
                return this.notLessThanToday();
            }
            case BETWEEN: {
                return this.between();
            }
        }
        throw new RuntimeException("Encountered the unsupported operator " + this.predicate.getSearchComplientOperator());
    }

    public static String getCondition(Predicate predicate) {
        ConditionBuilder conditionBuilder = ConditionBuilder.getConditionBuilder(predicate);
        return conditionBuilder.getCondition();
    }
}

