/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.search.assetconditionbuilder;

import com.ericsson.cms.criteria.Predicate;
import com.tandbergtv.metadatamanager.search.AssetSearchQueryBuilder;
import com.tandbergtv.metadatamanager.search.assetconditionbuilder.AssetConditionBuilder;

public class AssetStringConditionBuilder
extends AssetConditionBuilder {
    public static final String CUSTOM_FIELD = "Fields/CustomFields/CustomField/@value";
    public static final String CUSTOM_FIELD_CHECK = "/Fields/CustomFields/CustomField[@name=";

    public AssetStringConditionBuilder(Predicate predicate) {
        super(predicate);
    }

    @Override
    protected String equal() {
        return this.simpleConditionHelper(" = ");
    }

    @Override
    protected String notEqual() {
        return this.simpleConditionHelper(" != ");
    }

    @Override
    protected String getXpath() {
        String xpath = super.getXpath();
        if (this.isCustomField()) {
            return xpath;
        }
        if (this.predicate.getIgnoreCase() && !xpath.contains("@")) {
            return "fn:upper-case(" + xpath + "/text())";
        }
        return xpath;
    }

    @Override
    protected String getRhsValue(int index) {
        StringBuffer sb = new StringBuffer("\"");
        if (this.predicate.getIgnoreCase()) {
            sb.append(super.getRhsValue(index).toUpperCase());
        } else {
            sb.append(super.getRhsValue(index));
        }
        sb.append("\"");
        return sb.toString();
    }

    @Override
    protected String in() {
        return this.inHelper("or", "=");
    }

    @Override
    protected String notIn() {
        return this.inHelper("and", "!=");
    }

    @Override
    protected String contains() {
        return this.containsHelper(">");
    }

    @Override
    protected String notContains() {
        return this.containsHelper("=");
    }

    private String containsHelper(String operator) {
        StringBuffer condition = new StringBuffer();
        condition.append("ora:contains(");
        String xpath = super.getXpath();
        if (!xpath.contains("@")) {
            xpath = xpath + "/text()";
        }
        condition.append(xpath);
        condition.append(", \"");
        condition.append(AssetSearchQueryBuilder.encodeString(this.getRhsValue(0)));
        condition.append("\")");
        condition.append(operator);
        condition.append(" 0");
        return condition.toString();
    }

    @Override
    protected String startsWith() {
        return this.getFuncCondition("fn:starts-with");
    }

    private String getFuncCondition(String function) {
        String xpath = this.getXpath();
        StringBuffer condition = new StringBuffer();
        condition.append(function);
        condition.append("(");
        condition.append(xpath);
        if (!xpath.contains("text()") && !xpath.contains("@")) {
            condition.append("/text()");
        }
        condition.append(", ");
        condition.append(this.getRhsValue(0));
        condition.append(")");
        return condition.toString();
    }

    @Override
    protected String doesNotStartWith() {
        return "not(" + this.startsWith() + ")";
    }

    @Override
    protected String endsWith() {
        return this.getFuncCondition("fn:ends-with");
    }

    @Override
    protected String doesNotEndWith() {
        return "not(" + this.endsWith() + ")";
    }
}

