/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.specimpl.ttv;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.compare.AssetCompareReport;
import com.tandbergtv.metadatamanager.model.compare.AssetDifference;
import com.tandbergtv.metadatamanager.model.compare.FieldDifference;
import com.tandbergtv.metadatamanager.model.compare.IAssetCompareReport;
import com.tandbergtv.metadatamanager.model.compare.IAssetDifference;
import com.tandbergtv.metadatamanager.model.compare.IFieldDifference;
import com.tandbergtv.metadatamanager.specimpl.ttv.TTVId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class AssetComparator {
    AssetComparator() {
    }

    public boolean isDifferent(Asset asset1, Asset asset2) {
        return this.isDifferent(asset1, asset2, true);
    }

    public boolean isDifferent(Asset asset1, Asset asset2, boolean compareRelations) {
        IAssetDifference difference = this.compareAssetTrees(asset1, asset2, compareRelations, false);
        return difference != null;
    }

    public IAssetCompareReport compare(Asset asset1, Asset asset2) {
        return this.compare(asset1, asset2, true);
    }

    public IAssetCompareReport compare(Asset asset1, Asset asset2, boolean compareRelations) {
        AssetCompareReport report = new AssetCompareReport(asset1, asset2);
        IAssetDifference difference = this.compareAssetTrees(asset1, asset2, compareRelations, true);
        report.setDifference(difference);
        return report;
    }

    private IAssetDifference compareAssetTrees(Asset asset1, Asset asset2, boolean compareRelations, boolean getAll) {
        MappingType mappingType = this.getMappingType(asset1, asset2);
        return this.compareAssets(asset1, asset2, compareRelations, getAll, mappingType);
    }

    private IAssetDifference compareAssets(Asset asset1, Asset asset2, boolean compareRelations, boolean getAll, MappingType mappingType) {
        boolean fieldsDifferent;
        AssetDifference difference = null;
        if (asset1 == asset2) {
            return null;
        }
        Collection<IFieldDifference> fieldDifferences = this.compareFields(asset1, asset2, getAll);
        boolean bl = fieldsDifferent = fieldDifferences != null && fieldDifferences.size() > 0;
        if (!getAll && fieldsDifferent) {
            difference = new AssetDifference(asset1, asset2);
            difference.setFieldDifferences(fieldDifferences);
            return difference;
        }
        Collection<IAssetDifference> childDifferences = null;
        boolean childrenDifferent = false;
        if (compareRelations) {
            childDifferences = this.compareRelations(asset1, asset2, getAll, mappingType);
            boolean bl2 = childrenDifferent = childDifferences != null && childDifferences.size() > 0;
        }
        if (fieldsDifferent || childrenDifferent) {
            difference = new AssetDifference(asset1, asset2);
            difference.setFieldDifferences(fieldDifferences);
            difference.setChildAssetDifferences(childDifferences);
        }
        return difference;
    }

    private Collection<IFieldDifference> compareFields(Asset asset1, Asset asset2, boolean getAll) {
        HashSet<IFieldDifference> differences = new HashSet<IFieldDifference>();
        Map<String, Field> assetFieldMap1 = this.buildAssetFieldMap(asset1);
        Map<String, Field> assetFieldMap2 = this.buildAssetFieldMap(asset2);
        HashSet<String> allNames = new HashSet<String>();
        allNames.addAll(assetFieldMap1.keySet());
        allNames.addAll(assetFieldMap2.keySet());
        for (String fieldName : allNames) {
            String value2;
            Field field1 = assetFieldMap1.get(fieldName);
            Field field2 = assetFieldMap2.get(fieldName);
            String value1 = this.getFieldValue(field1);
            if (this.isMatchingValue(value1, value2 = this.getFieldValue(field2))) continue;
            FieldDifference difference = new FieldDifference(field1, field2);
            differences.add(difference);
            if (getAll) continue;
            break;
        }
        return differences;
    }

    private Map<String, Field> buildAssetFieldMap(Asset asset) {
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        if (asset != null && asset.getFields() != null) {
            for (Field field : asset.getFields()) {
                String qualifiedFieldName = field.getTtvXPathWithIndices();
                fieldMap.put(qualifiedFieldName, field);
            }
        }
        return fieldMap;
    }

    private String getFieldValue(Field field) {
        String value;
        String string = value = field != null ? field.getValue() : null;
        if (value != null && value.length() == 0) {
            value = null;
        }
        return value;
    }

    private boolean isMatchingValue(String value1, String value2) {
        return value1 == value2 || value1 != null && value1.equals(value2);
    }

    private Collection<IAssetDifference> compareRelations(Asset asset1, Asset asset2, boolean getAll, MappingType mappingType) {
        HashSet<IAssetDifference> differences = new HashSet<IAssetDifference>();
        HashMap<Asset, Asset> mappedAssets = new HashMap<Asset, Asset>();
        HashSet<Asset> unmappedAssets1 = new HashSet<Asset>();
        HashSet<Asset> unmappedAssets2 = new HashSet<Asset>();
        this.mapRelations(asset1, asset2, mappingType, mappedAssets, unmappedAssets1, unmappedAssets2);
        for (Asset childAsset1 : mappedAssets.keySet()) {
            Asset childAsset2 = (Asset)mappedAssets.get(childAsset1);
            this.compareChildAssets(childAsset1, childAsset2, getAll, mappingType, differences);
            if (getAll || differences.size() <= 0) continue;
            return differences;
        }
        for (Asset childAsset1 : unmappedAssets1) {
            this.compareChildAssets(childAsset1, null, getAll, mappingType, differences);
            if (getAll || differences.size() <= 0) continue;
            return differences;
        }
        for (Asset childAsset2 : unmappedAssets2) {
            this.compareChildAssets(null, childAsset2, getAll, mappingType, differences);
            if (getAll || differences.size() <= 0) continue;
            return differences;
        }
        return differences;
    }

    private void compareChildAssets(Asset asset1, Asset asset2, boolean getAll, MappingType mappingType, Collection<IAssetDifference> childDifferences) {
        IAssetDifference difference = this.compareAssets(asset1, asset2, true, getAll, mappingType);
        if (difference != null) {
            childDifferences.add(difference);
        }
    }

    private void mapRelations(Asset asset1, Asset asset2, MappingType mappingType, Map<Asset, Asset> mappedAssets, Set<Asset> unmappedAssets1, Set<Asset> unmappedAssets2) {
        ArrayList children1 = asset1 != null ? asset1.getImmediateChildren() : new ArrayList();
        ArrayList<Asset> children2 = asset2 != null ? asset2.getImmediateChildren() : new ArrayList<Asset>();
        for (Asset childAsset1 : children1) {
            Asset mappedAsset = this.findMappedAsset(childAsset1, children2, mappingType);
            if (mappedAsset != null) {
                mappedAssets.put(childAsset1, mappedAsset);
                continue;
            }
            unmappedAssets1.add(childAsset1);
        }
        for (Asset childAsset2 : children2) {
            if (mappedAssets.values().contains(childAsset2)) continue;
            unmappedAssets2.add(childAsset2);
        }
    }

    private Asset findMappedAsset(Asset asset, List<Asset> mapTargets, MappingType mappingType) {
        for (Asset mapTarget : mapTargets) {
            if (!this.isMappedAsset(asset, mapTarget, mappingType)) continue;
            return mapTarget;
        }
        return null;
    }

    private boolean isMappedAsset(Asset asset, Asset mapTarget, MappingType mappingType) {
        switch (mappingType) {
            case SAME_ASSET: {
                return this.isSameAsset(asset, mapTarget);
            }
            case COPY_OF_ASSET1: {
                return this.isCopyOfAsset(mapTarget, asset);
            }
            case COPY_OF_ASSET2: {
                return this.isCopyOfAsset(asset, mapTarget);
            }
            case COPIES_OF_SAME_ASSET: {
                return this.isCopiedFromSameAsset(asset, mapTarget);
            }
            case UNRELATED: {
                return false;
            }
        }
        return false;
    }

    private MappingType getMappingType(Asset asset1, Asset asset2) {
        if (asset1 == null || asset2 == null) {
            return MappingType.UNRELATED;
        }
        if (this.isSameAsset(asset1, asset2)) {
            return MappingType.SAME_ASSET;
        }
        if (this.isCopyOfAsset(asset2, asset1)) {
            return MappingType.COPY_OF_ASSET1;
        }
        if (this.isCopyOfAsset(asset1, asset2)) {
            return MappingType.COPY_OF_ASSET2;
        }
        if (this.isCopiedFromSameAsset(asset1, asset2)) {
            return MappingType.COPIES_OF_SAME_ASSET;
        }
        return MappingType.UNRELATED;
    }

    private boolean isSameAsset(Asset asset1, Asset asset2) {
        TTVId asset1Id = asset1.getTTVId();
        return asset1Id.isValidIdentifier() && asset1Id.getId() == asset2.getId();
    }

    private boolean isCopyOfAsset(Asset copy, Asset original) {
        Long originalID = copy.getOriginalAssetID();
        return originalID != null && originalID.longValue() == original.getId();
    }

    private boolean isCopiedFromSameAsset(Asset asset1, Asset asset2) {
        Long originalID1 = asset1.getOriginalAssetID();
        Long originalID2 = asset2.getOriginalAssetID();
        return originalID1 != null && originalID1.equals(originalID2);
    }

    private static enum MappingType {
        SAME_ASSET,
        COPY_OF_ASSET1,
        COPY_OF_ASSET2,
        COPIES_OF_SAME_ASSET,
        UNRELATED;

    }
}

