/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginRegistry;

public class FileFieldMappingReader {
    private static final String PARAMETER_ID = "fileFieldMapping";
    private static final String EXTENSION_ID = "fileFieldMapping";
    private static final String PLUGIN_ID = "com.tandbergtv.metadata";
    private static FileFieldMappingReader instance = null;
    Map<String, Map<String, String>> assetFileFieldMap;
    private static final Logger logger = Logger.getLogger(FileFieldMappingReader.class);

    private FileFieldMappingReader(String dataTypeMappingFile, PluginManager pm) {
        if (pm != null) {
            try {
                PluginRegistry pluginRegistry = pm.getRegistry();
                ExtensionPoint point = pluginRegistry.getExtensionPoint(PLUGIN_ID, "fileFieldMapping");
                Collection extensions = point.getAvailableExtensions();
                if (!extensions.isEmpty()) {
                    Extension extension = (Extension)extensions.iterator().next();
                    Extension.Parameter param = extension.getParameter("fileFieldMapping");
                    PluginDescriptor descriptor = extension.getDeclaringPluginDescriptor();
                    PluginClassLoader classLoader = pm.getPluginClassLoader(descriptor);
                    InputStream is = classLoader.getResourceAsStream(param.valueAsString());
                    this.assetFileFieldMap = FileFieldMappingReader.readFieldMapping(is);
                }
            }
            catch (Exception e) {
                logger.warn((Object)"You do not have a FileFieldMapping.dat file in your com.tandbergtv.metadata plugin.", (Throwable)e);
            }
        }
    }

    public static FileFieldMappingReader getInstance() {
        return FileFieldMappingReader.getInstance(null, null);
    }

    public static FileFieldMappingReader getInstance(String file) {
        return FileFieldMappingReader.getInstance(file, null);
    }

    public static FileFieldMappingReader getInstance(PluginManager pm) {
        return FileFieldMappingReader.getInstance(null, pm);
    }

    public static synchronized FileFieldMappingReader getInstance(String dataTypeMappingFile, PluginManager pm) {
        if (instance == null) {
            if (dataTypeMappingFile == null) {
                dataTypeMappingFile = "FileFieldMapping.dat";
            }
            instance = new FileFieldMappingReader(dataTypeMappingFile, pm);
        }
        return instance;
    }

    public Map<String, String> getAssetFileFieldMap(String type) {
        return this.assetFileFieldMap.get(type);
    }

    private static Map<String, Map<String, String>> readFieldMapping(InputStream is) {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String type = "";
        HashMap fieldMap = null;
        String line = "";
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        try {
            while ((line = br.readLine()) != null) {
                if (line.equals("")) continue;
                if (line.startsWith("[")) {
                    type = line.replaceAll("\\[", "");
                    type = type.replaceAll("\\]", "");
                    if (map.containsKey(type = type.trim().toLowerCase())) continue;
                    fieldMap = new HashMap();
                    map.put(type, fieldMap);
                    continue;
                }
                String[] fields = line.split(",");
                ((Map)map.get(type)).put(fields[0].trim(), fields[1].trim());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Unable to close reader ", (Throwable)ex);
            }
        }
        return map;
    }
}

