/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.util;

import com.tandbergtv.metadatamanager.customfield.model.CustomField;
import com.tandbergtv.metadatamanager.customfield.model.CustomFieldGroup;
import com.tandbergtv.metadatamanager.util.MappingFileParser;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.java.plugin.PluginManager;

public class DataTypeMappingReader {
    private static final String NON_NEGATIVE = "nonnegative";
    private static DataTypeMappingReader instance = null;
    Map<String, String> dataTypeXpathMap;
    Map<String, String> dataTypeExtXpathMap;
    private static final Logger logger = Logger.getLogger(DataTypeMappingReader.class);

    protected DataTypeMappingReader(String dataTypeMappingFile, PluginManager pm) {
        this.dataTypeXpathMap = MappingFileParser.readFieldMapping(dataTypeMappingFile);
        this.dataTypeExtXpathMap = MappingFileParser.readFieldExtMapping(dataTypeMappingFile);
    }

    public static DataTypeMappingReader getInstance() {
        return DataTypeMappingReader.getInstance(null, null);
    }

    public static DataTypeMappingReader getInstance(PluginManager pm) {
        return DataTypeMappingReader.getInstance(null, pm);
    }

    public static synchronized DataTypeMappingReader getInstance(String dataTypeMappingFile, PluginManager pm) {
        if (instance == null) {
            if (dataTypeMappingFile == null) {
                dataTypeMappingFile = "DatatypeMapping.dat";
            }
            instance = new DataTypeMappingReader(dataTypeMappingFile, pm);
        }
        return instance;
    }

    public synchronized String determineDataType(String ttvXPath) {
        Map<String, String> customFieldsDataTypeXpathMap;
        String type = null;
        if (this.dataTypeXpathMap.containsKey(ttvXPath)) {
            type = this.dataTypeXpathMap.get(ttvXPath);
        }
        if ((customFieldsDataTypeXpathMap = DataTypeMappingReader.getCustomFieldsExtraDatatypeMap()).containsKey(ttvXPath)) {
            type = customFieldsDataTypeXpathMap.get(ttvXPath);
        }
        return type;
    }

    private static Map<String, String> getCustomFieldsExtraDatatypeMap() {
        HashMap<String, String> customFieldsDataTypeXpathMap = new HashMap<String, String>();
        customFieldsDataTypeXpathMap.put("/Fields/CustomFields/CustomField[@name=LookupKey]/@value", "string");
        customFieldsDataTypeXpathMap.put("/Fields/CustomFields/CustomField[@name=MaterialId]/@value", "string");
        customFieldsDataTypeXpathMap.put("/Fields/CustomFields/CustomField[@name=EncodeFormat]/@value", "string");
        customFieldsDataTypeXpathMap.put("/Fields/CustomFields/CustomField[@name=EncodeProfile]/@value", "string");
        return customFieldsDataTypeXpathMap;
    }

    public synchronized boolean isNonNegative(String ttvXPath) {
        String ext;
        boolean isNonNegative = false;
        if (this.dataTypeExtXpathMap.containsKey(ttvXPath) && (ext = this.dataTypeExtXpathMap.get(ttvXPath)).equals(NON_NEGATIVE)) {
            isNonNegative = true;
        }
        return isNonNegative;
    }

    public synchronized boolean hasChildren(String ttvXPath) {
        String prefix = ttvXPath + "/";
        for (String key : this.dataTypeXpathMap.keySet()) {
            if (!key.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public synchronized void refreshCustomFieldDataTypeMap(List<CustomFieldGroup> grps) {
        if (grps == null) {
            return;
        }
        Iterator<String> it = this.dataTypeXpathMap.keySet().iterator();
        while (it.hasNext()) {
            String xpath = it.next();
            if (!xpath.startsWith("/Fields/CustomFields")) continue;
            it.remove();
        }
        for (CustomFieldGroup g : grps) {
            List<CustomField> cflds = g.getCustomFieldList();
            if (cflds == null) continue;
            for (CustomField cfld : cflds) {
                String cfName = cfld.getName();
                String dataType = cfld.getDataType();
                this.dataTypeXpathMap.put("/Fields/CustomFields/CustomField[@name=" + cfName + "]/@value", dataType.toLowerCase());
            }
        }
    }
}

