/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.upgrade;

import com.tandbergtv.cms.entity.CustomField;
import com.tandbergtv.cms.entity.CustomFieldGroup;
import com.tandbergtv.cms.upgrade.UpgradeDBManager;
import com.tandbergtv.watchpoint.pmm.title.conf.BooleanVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.ComplexVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.DateVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.FloatVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.IntegerVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.SimpleVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.SpecificationReader;
import com.tandbergtv.watchpoint.pmm.title.conf.StringVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.TimeVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConf;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import com.tandbergtv.watchpoint.pmm.title.conf.Variable;
import com.tandbergtv.watchpoint.pmm.title.conf.VariableOption;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class CustomFieldUpgradeManager {
    private static Logger logger = Logger.getLogger(CustomFieldUpgradeManager.class);
    private UpgradeDBManager dbManager = null;
    private Properties properties = null;
    private Properties seriesProperties = null;
    private Properties configProperties = null;
    private String defPath = null;
    private String seriesPath = null;
    private String ecmfPath = null;

    public void upgradeCustomFieldsSpecification() throws Exception {
        CustomFieldGroup customFieldGroup;
        List list;
        ArrayList<CustomFieldGroup> arrayList;
        List list2;
        SpecificationReader specificationReader = new SpecificationReader();
        this.dbManager = new UpgradeDBManager();
        UISpecification uISpecification = null;
        UISpecification uISpecification2 = null;
        this.configProperties = new Properties();
        this.properties = new Properties();
        this.seriesProperties = new Properties();
        try {
            this.configProperties.load(new FileInputStream("resources/config.properties"));
            System.out.println("read config properties");
            this.defPath = this.configProperties.getProperty("definition");
            this.seriesPath = this.configProperties.getProperty("series_definition");
            this.ecmfPath = this.configProperties.getProperty("ecmf_properties");
            this.properties.load(new FileInputStream(this.ecmfPath));
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.error((Object)("Could not load properties: " + fileNotFoundException));
        }
        catch (IOException iOException) {
            logger.error((Object)("Could not load properties: " + iOException));
        }
        try {
            uISpecification = specificationReader.unmarshal(this.defPath, this.getClass().getClassLoader(), null);
            uISpecification2 = specificationReader.unmarshal(this.seriesPath, this.getClass().getClassLoader(), null);
        }
        catch (Exception exception) {
            logger.error((Object)("Could not load definition or series_definition xml: " + exception));
        }
        if (uISpecification != null && this.properties != null) {
            System.out.println("Loaded definition.xml and ecmf.xml. Processing...");
            logger.info((Object)"Loaded definition.xml and ecmf.xml. Processing...");
            list2 = uISpecification.getAllTitleConf();
            arrayList = new ArrayList<CustomFieldGroup>();
            if (list2 != null) {
                for (TitleConf titleConf : list2) {
                    list = titleConf.getMetadata();
                    if (list == null) continue;
                    for (Variable variable : list) {
                        if (!variable.getName().equalsIgnoreCase("CustomFields")) continue;
                        customFieldGroup = new CustomFieldGroup();
                        this.convertCustomFields(variable, titleConf, customFieldGroup, this.properties);
                        arrayList.add(customFieldGroup);
                        this.saveCustomFields(customFieldGroup);
                    }
                }
            }
        }
        if (uISpecification2 != null && this.properties != null) {
            System.out.println("Loaded series_definition.xml and ecmf.properties. Processing...");
            logger.info((Object)"Loaded series_definition.xml and ecmf.properties. Processing...");
            list2 = uISpecification2.getAllTitleConf();
            arrayList = new ArrayList();
            if (list2 != null) {
                for (TitleConf titleConf : list2) {
                    list = titleConf.getMetadata();
                    if (list == null) continue;
                    for (Variable variable : list) {
                        if (!variable.getName().equalsIgnoreCase("CustomFields")) continue;
                        customFieldGroup = new CustomFieldGroup();
                        this.convertCustomFields(variable, titleConf, customFieldGroup, this.properties);
                        arrayList.add(customFieldGroup);
                        this.saveCustomFields(customFieldGroup);
                    }
                }
            }
        }
        this.updateCCGroups();
    }

    private void updateCCGroups() throws Exception {
        this.dbManager.saveCustomFieldGroupsToCC();
    }

    private void convertCustomFields(Variable variable, TitleConf titleConf, CustomFieldGroup customFieldGroup, Properties properties) {
        if (variable == null) {
            return;
        }
        if (variable instanceof ComplexVariable) {
            ComplexVariable complexVariable = (ComplexVariable)variable;
            String string = complexVariable.getDisplayName();
            String string2 = complexVariable.getName();
            String string3 = titleConf.getPath();
            customFieldGroup.setAssetPath(string3);
            customFieldGroup.setName(string2);
            String string4 = properties.getProperty(string);
            if (string4 != null) {
                customFieldGroup.setDisplayName(properties.getProperty(string));
            } else {
                customFieldGroup.setDisplayName(string);
            }
            List list = complexVariable.getChildren();
            if (list != null) {
                for (Variable variable2 : list) {
                    if (!(variable2 instanceof ComplexVariable)) continue;
                    ComplexVariable complexVariable2 = (ComplexVariable)variable2;
                    CustomField customField = new CustomField();
                    customField.setName(this.parseName(complexVariable2.getName()));
                    customField.setMultiValue(this.convertBool(complexVariable2.isMultiValue()));
                    List list2 = complexVariable2.getChildren();
                    if (list2 == null) continue;
                    for (Variable variable3 : list2) {
                        List list3;
                        if (!(variable3 instanceof SimpleVariable)) continue;
                        SimpleVariable simpleVariable = (SimpleVariable)variable3;
                        String string5 = properties.getProperty(simpleVariable.getDisplayName());
                        if (string5 != null) {
                            customField.setDisplayName(properties.getProperty(simpleVariable.getDisplayName()));
                        } else {
                            customField.setDisplayName(simpleVariable.getDisplayName());
                        }
                        customField.setDataType(this.getDatatype(simpleVariable));
                        customField.setJobParameter(this.convertBool(simpleVariable.isJobParameter()));
                        if (simpleVariable instanceof DateVariable) {
                            customField.setJobScheduleParameter(this.convertBool(simpleVariable.isJobRuleParameter()));
                        }
                        if (!complexVariable2.isMultiValue()) {
                            customField.setMultiValue(this.convertBool(simpleVariable.isMultiValue()));
                        }
                        if ((list3 = simpleVariable.getOptions()) != null && !list3.isEmpty()) {
                            this.convertOptions(list3, properties);
                            customField.setOptionList(list3);
                            if (simpleVariable.isAnyValueAllowed()) {
                                customField.setFieldType(3);
                            } else {
                                customField.setFieldType(2);
                            }
                        } else {
                            StringVariable stringVariable;
                            customField.setFieldType(1);
                            if (simpleVariable instanceof StringVariable && (stringVariable = (StringVariable)simpleVariable).isLongFormat()) {
                                customField.setFieldType(4);
                            }
                        }
                        if (simpleVariable instanceof BooleanVariable) {
                            customField.setFieldType(2);
                        }
                        customField.setGroup(customFieldGroup);
                        customFieldGroup.addCustomField(customField);
                    }
                }
            }
        }
    }

    private void convertOptions(List<VariableOption> list, Properties properties) {
        for (VariableOption variableOption : list) {
            String string = variableOption.getName();
            String string2 = properties.getProperty(string);
            if (string2 == null) continue;
            variableOption.setName(string2);
        }
    }

    private String parseName(String string) {
        String string2 = null;
        if (string != null) {
            string.trim();
            String[] stringArray = string.split("@name=");
            String[] stringArray2 = stringArray[1].split("]");
            string2 = stringArray2[0];
        }
        return string2;
    }

    private void saveCustomFields(CustomFieldGroup customFieldGroup) throws Exception {
        this.dbManager.saveCustomFieldGroups(customFieldGroup);
    }

    private String getDatatype(SimpleVariable simpleVariable) {
        if (simpleVariable instanceof BooleanVariable) {
            return "Boolean";
        }
        if (simpleVariable instanceof DateVariable) {
            return "Date";
        }
        if (simpleVariable instanceof FloatVariable) {
            return "Float";
        }
        if (simpleVariable instanceof IntegerVariable) {
            return "Integer";
        }
        if (simpleVariable instanceof StringVariable) {
            return "String";
        }
        if (simpleVariable instanceof TimeVariable) {
            return "Time";
        }
        return null;
    }

    private String convertBool(boolean bl) {
        if (bl) {
            return "Y";
        }
        return "N";
    }

    public static void main(String[] stringArray) throws Exception {
        CustomFieldUpgradeManager customFieldUpgradeManager = new CustomFieldUpgradeManager();
        customFieldUpgradeManager.upgradeCustomFieldsSpecification();
    }
}

