/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.image;

import com.tandbergtv.cms.portal.util.locale.ResourceBundleLocaleModifier;
import com.tandbergtv.content.image.IThumbnailGenerator;
import com.tandbergtv.content.image.ThumbnailGenerator;
import com.tandbergtv.content.image.ThumbnailGeneratorFactory;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;

public class DefaultThumbnailGeneratorFactory
extends ThumbnailGeneratorFactory {
    private static final Logger logger = Logger.getLogger(DefaultThumbnailGeneratorFactory.class);
    private static final String PREFERRED_HEIGHT = "preferredHeight";
    private static final String PREFERRED_WIDTH = "preferredWidth";
    private static final String OUTPUT_FORMAT = "outputFormat";
    private static final int PREFERRED_HEIGHT_VALUE = 100;
    private static final int PREFERRED_WIDTH_VALUE = 100;
    private static final String OUTPUT_FORMAT_VALUE = "PNG";

    public DefaultThumbnailGeneratorFactory() {
        this.readPreferredHeight();
        this.readPreferredWidth();
        this.readOutputFormat();
    }

    public IThumbnailGenerator createThumbnailGenerator() {
        return new ThumbnailGenerator(this.getPreferredHeight(), this.getPreferredWidth(), this.getThumbnailFormat());
    }

    private void readPreferredHeight() {
        int height = -1;
        try {
            String string = ((Object)((Object)this)).getClass().getName();
            ResourceBundle bundle = DefaultThumbnailGeneratorFactory.getBundle_aroundBody1$advice(this, string, ResourceBundleLocaleModifier.aspectOf(), string, null);
            String heightValue = bundle.getString(PREFERRED_HEIGHT);
            height = Integer.parseInt(heightValue);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to read the preffered thumbnail image height, using default value.", (Throwable)e);
        }
        if (height <= 0) {
            height = 100;
        }
        this.setPreferredHeight(height);
    }

    private void readPreferredWidth() {
        int width = -1;
        try {
            String string = ((Object)((Object)this)).getClass().getName();
            ResourceBundle bundle = DefaultThumbnailGeneratorFactory.getBundle_aroundBody3$advice(this, string, ResourceBundleLocaleModifier.aspectOf(), string, null);
            String widthValue = bundle.getString(PREFERRED_WIDTH);
            width = Integer.parseInt(widthValue);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to read the preffered thumbnail image height, using default value.", (Throwable)e);
        }
        if (width <= 0) {
            width = 100;
        }
        this.setPreferredWidth(width);
    }

    private void readOutputFormat() {
        String format = null;
        try {
            String string = ((Object)((Object)this)).getClass().getName();
            ResourceBundle bundle = DefaultThumbnailGeneratorFactory.getBundle_aroundBody5$advice(this, string, ResourceBundleLocaleModifier.aspectOf(), string, null);
            format = bundle.getString(OUTPUT_FORMAT);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to read the output format to use for thumbnail image, using default value.", (Throwable)e);
        }
        if (format == null || format.trim().length() == 0) {
            format = OUTPUT_FORMAT_VALUE;
        }
        this.setThumbnailFormat(format);
    }

    private static final /* synthetic */ ResourceBundle getBundle_aroundBody0(DefaultThumbnailGeneratorFactory defaultThumbnailGeneratorFactory, String string) {
        return ResourceBundle.getBundle(string);
    }

    private static final /* synthetic */ ResourceBundle getBundle_aroundBody1$advice(DefaultThumbnailGeneratorFactory this_, String arg0, ResourceBundleLocaleModifier ajc$aspectInstance, String baseName, AroundClosure ajc$aroundClosure) {
        return ResourceBundle.getBundle(baseName, ResourceBundleLocaleModifier.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_locale_ResourceBundleLocaleModifier$com_tandbergtv_cms_portal_util_locale_ResourceBundleLocaleModifier$locale((ResourceBundleLocaleModifier)ajc$aspectInstance));
    }

    private static final /* synthetic */ ResourceBundle getBundle_aroundBody2(DefaultThumbnailGeneratorFactory defaultThumbnailGeneratorFactory, String string) {
        return ResourceBundle.getBundle(string);
    }

    private static final /* synthetic */ ResourceBundle getBundle_aroundBody3$advice(DefaultThumbnailGeneratorFactory this_, String arg0, ResourceBundleLocaleModifier ajc$aspectInstance, String baseName, AroundClosure ajc$aroundClosure) {
        return ResourceBundle.getBundle(baseName, ResourceBundleLocaleModifier.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_locale_ResourceBundleLocaleModifier$com_tandbergtv_cms_portal_util_locale_ResourceBundleLocaleModifier$locale((ResourceBundleLocaleModifier)ajc$aspectInstance));
    }

    private static final /* synthetic */ ResourceBundle getBundle_aroundBody4(DefaultThumbnailGeneratorFactory defaultThumbnailGeneratorFactory, String string) {
        return ResourceBundle.getBundle(string);
    }

    private static final /* synthetic */ ResourceBundle getBundle_aroundBody5$advice(DefaultThumbnailGeneratorFactory this_, String arg0, ResourceBundleLocaleModifier ajc$aspectInstance, String baseName, AroundClosure ajc$aroundClosure) {
        return ResourceBundle.getBundle(baseName, ResourceBundleLocaleModifier.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_locale_ResourceBundleLocaleModifier$com_tandbergtv_cms_portal_util_locale_ResourceBundleLocaleModifier$locale((ResourceBundleLocaleModifier)ajc$aspectInstance));
    }
}

