/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.image;

import com.tandbergtv.content.image.IThumbnailGenerator;
import com.tandbergtv.content.image.ThumbnailGenerationException;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class ThumbnailGenerator
implements IThumbnailGenerator {
    private int preferredHeight;
    private int preferredWidth;
    private String outputFormat;
    private double minAdjustPercent = 0.1;

    public ThumbnailGenerator(int preferredHeight, int preferredWidth, String outputFormat) {
        this.preferredHeight = preferredHeight;
        this.preferredWidth = preferredWidth;
        this.outputFormat = outputFormat;
    }

    public void generateThumbnail(InputStream imageStream, OutputStream thumbnailStream) throws ThumbnailGenerationException {
        this.generateThumbnail(imageStream, thumbnailStream, this.preferredHeight, this.preferredWidth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateThumbnail(InputStream imageStream, OutputStream thumbnailStream, int thumbnailHeight, int thumbnailWidth) throws ThumbnailGenerationException {
        BufferedImage image = null;
        try {
            image = ImageIO.read(imageStream);
        }
        catch (IOException e) {
            String msg = "Failed to read the image from provided input stream, error: " + e.getLocalizedMessage();
            throw new ThumbnailGenerationException(msg, (Throwable)e);
        }
        if (image == null) {
            String msg = "Failed to read the image from provided input stream.";
            throw new ThumbnailGenerationException(msg);
        }
        BufferedImage thumbnail = new BufferedImage(thumbnailWidth, thumbnailHeight, 2);
        int imageHeight = image.getHeight(null);
        int imageWidth = image.getWidth(null);
        double imageRatio = (double)imageHeight / (double)imageWidth;
        double thumbnailRatio = (double)thumbnailHeight / (double)thumbnailWidth;
        int x = 0;
        int y = 0;
        int adjustedHeight = thumbnailHeight;
        int adjustedWidth = thumbnailWidth;
        if (imageRatio > thumbnailRatio) {
            int minAdjustedWidth;
            adjustedWidth = (int)Math.ceil((double)thumbnailHeight / imageRatio);
            if (adjustedWidth < (minAdjustedWidth = (int)Math.ceil(this.minAdjustPercent * (double)thumbnailWidth))) {
                adjustedWidth = minAdjustedWidth;
            }
            x = (thumbnailWidth - adjustedWidth) / 2;
        } else if (imageRatio < thumbnailRatio) {
            int minAdjustedHeight;
            adjustedHeight = (int)Math.ceil((double)thumbnailWidth * imageRatio);
            if (adjustedHeight < (minAdjustedHeight = (int)Math.ceil(this.minAdjustPercent * (double)thumbnailHeight))) {
                adjustedHeight = minAdjustedHeight;
            }
            y = (thumbnailHeight - adjustedHeight) / 2;
        }
        Graphics2D graphics = null;
        try {
            graphics = thumbnail.createGraphics();
            graphics.setComposite(AlphaComposite.Src);
            graphics.setColor(new Color(0, 0, 0, 0));
            graphics.fillRect(0, 0, thumbnailWidth, thumbnailHeight);
            graphics.drawImage(image, x, y, adjustedWidth, adjustedHeight, null);
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
        }
        try {
            if (!ImageIO.write((RenderedImage)thumbnail, this.outputFormat, thumbnailStream)) {
                String msg = "Failed to write the thumbnail to provided output stream.";
                throw new ThumbnailGenerationException(msg);
            }
        }
        catch (IOException e) {
            String msg = "Failed to write the thumbnail to the provided output stream, error: " + e.getLocalizedMessage();
            throw new ThumbnailGenerationException(msg, (Throwable)e);
        }
    }

    public int getPreferredHeight() {
        return this.preferredHeight;
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }
}

