/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.metadata;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.content.contentclass.service.ICustomFieldManager;
import com.tandbergtv.metadatamanager.customfield.CustomFieldDeleteCallbackException;
import com.tandbergtv.metadatamanager.customfield.model.CustomField;
import com.tandbergtv.metadatamanager.customfield.model.CustomFieldGroup;
import com.tandbergtv.metadatamanager.customfield.persistence.CustomFieldPersistenceService;
import com.tandbergtv.metadatamanager.customfield.persistence.ICustomFieldPersistenceService;
import com.tandbergtv.metadatamanager.enums.CustomFieldOptionsEnum;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import com.tandbergtv.watchpoint.pmm.title.conf.CustomField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;

public class CustomFieldManager
implements ICustomFieldManager {
    private static Logger logger = Logger.getLogger(CustomFieldManager.class);

    public String getServiceName() {
        return "CustomFieldManager";
    }

    public void start() {
    }

    public void stop() {
    }

    @Transactional
    public List<CustomFieldGroup> getAllGroups() {
        return (List)CustomFieldManager.getAllGroups_aroundBody1$advice(this, TransactionEnforcer.aspectOf(), CustomFieldManager.class.getDeclaredMethod("getAllGroups", new Class[0]).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public void saveGroups(List<CustomFieldGroup> groupList) throws CustomFieldDeleteCallbackException {
        List<CustomFieldGroup> list = groupList;
        CustomFieldManager.saveGroups_aroundBody3$advice(this, list, TransactionEnforcer.aspectOf(), CustomFieldManager.class.getDeclaredMethod("saveGroups", List.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public Map<String, List<com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup>> getAllCustomFieldsForUISpec() {
        return (Map)CustomFieldManager.getAllCustomFieldsForUISpec_aroundBody5$advice(this, TransactionEnforcer.aspectOf(), CustomFieldManager.class.getDeclaredMethod("getAllCustomFieldsForUISpec", new Class[0]).getAnnotation(Transactional.class), null);
    }

    private Map<String, List<com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup>> createCustomFieldMap(List<CustomFieldGroup> groups) {
        HashMap<String, List<com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup>> map = new HashMap<String, List<com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup>>();
        if (groups != null) {
            for (CustomFieldGroup group : groups) {
                String path = group.getAssetPath();
                ArrayList<com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup> newList = (ArrayList<com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup>)map.get(path);
                if (newList == null) {
                    newList = new ArrayList<com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup>();
                    map.put(path, newList);
                }
                com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup newGroup = new com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup(group.getUuid(), group.getDisplayName());
                List list = group.getCustomFieldList();
                if (list != null) {
                    for (CustomField cf : list) {
                        com.tandbergtv.watchpoint.pmm.title.conf.CustomField newCf = this.createCf(cf);
                        newGroup.fields.add(newCf);
                    }
                }
                newList.add(newGroup);
            }
        }
        return map;
    }

    private com.tandbergtv.watchpoint.pmm.title.conf.CustomField createCf(CustomField cf) {
        com.tandbergtv.watchpoint.pmm.title.conf.CustomField newCf = new com.tandbergtv.watchpoint.pmm.title.conf.CustomField();
        String type = cf.getDataType();
        if ("Boolean".equalsIgnoreCase(type)) {
            newCf.dataType = CustomField.DataType.BOOLEAN;
        } else if ("Date".equalsIgnoreCase(type)) {
            newCf.dataType = CustomField.DataType.DATE;
        } else if ("Float".equalsIgnoreCase(type)) {
            newCf.dataType = CustomField.DataType.FLOAT;
        } else if ("Integer".equalsIgnoreCase(type)) {
            newCf.dataType = CustomField.DataType.INTEGER;
        } else if ("String".equalsIgnoreCase(type)) {
            newCf.dataType = CustomField.DataType.STRING;
            if (CustomFieldOptionsEnum.fromId((int)cf.getFieldType()) == CustomFieldOptionsEnum.TEXT_AREA) {
                newCf.multiLine = true;
            }
        } else if ("Time".equalsIgnoreCase(type)) {
            newCf.dataType = CustomField.DataType.TIME;
        } else {
            throw new RuntimeException("Invalid data type " + type);
        }
        newCf.displayName = cf.getDisplayName();
        newCf.name = cf.getName();
        newCf.groupId = cf.getGroup().getUuid();
        if (CustomFieldOptionsEnum.fromId((int)cf.getFieldType()) == CustomFieldOptionsEnum.TEXT_BOX) {
            newCf.dropDown = false;
            newCf.anyValueAllowed = false;
        } else if (CustomFieldOptionsEnum.fromId((int)cf.getFieldType()) == CustomFieldOptionsEnum.DROP_DOWN) {
            newCf.anyValueAllowed = false;
            newCf.dropDown = true;
        } else if (CustomFieldOptionsEnum.fromId((int)cf.getFieldType()) == CustomFieldOptionsEnum.COMBO_BOX) {
            newCf.dropDown = true;
            newCf.anyValueAllowed = true;
        }
        newCf.multiValue = this.toBoolean(cf.getMultiValue());
        newCf.jobParameter = this.toBoolean(cf.getJobParameter());
        newCf.jobScheduleParameter = this.toBoolean(cf.getJobScheduleParameter());
        return newCf;
    }

    private boolean toBoolean(String str) {
        return "Y".equalsIgnoreCase(str);
    }

    public boolean isValidField(String name, String displayName, String path, String groupDisplayName) {
        ICustomFieldPersistenceService dao = CustomFieldPersistenceService.getInstance();
        return dao.validField(name, displayName, path, groupDisplayName);
    }

    @Transactional
    public void deleteCustomField(CustomField field) {
        CustomField customField = field;
        CustomFieldManager.deleteCustomField_aroundBody7$advice(this, customField, TransactionEnforcer.aspectOf(), CustomFieldManager.class.getDeclaredMethod("deleteCustomField", CustomField.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public void deleteCustomFieldGroup(CustomFieldGroup group) {
        CustomFieldGroup customFieldGroup = group;
        CustomFieldManager.deleteCustomFieldGroup_aroundBody9$advice(this, customFieldGroup, TransactionEnforcer.aspectOf(), CustomFieldManager.class.getDeclaredMethod("deleteCustomFieldGroup", CustomFieldGroup.class).getAnnotation(Transactional.class), null);
    }

    private List<CustomFieldGroup> getDeletedGroups(List<CustomFieldGroup> allGroups, List<CustomFieldGroup> groupList) {
        ArrayList<CustomFieldGroup> deletedGroups = new ArrayList<CustomFieldGroup>();
        for (CustomFieldGroup oldGroup : allGroups) {
            if (groupList.contains(oldGroup)) continue;
            deletedGroups.add(oldGroup);
        }
        return deletedGroups;
    }

    public void deleteCustomFieldGroups(List<CustomFieldGroup> groupList) {
    }

    @Transactional
    public void saveImportedCustomFields(List<CustomFieldGroup> groupList) throws Exception {
        List<CustomFieldGroup> list = groupList;
        CustomFieldManager.saveImportedCustomFields_aroundBody11$advice(this, list, TransactionEnforcer.aspectOf(), CustomFieldManager.class.getDeclaredMethod("saveImportedCustomFields", List.class).getAnnotation(Transactional.class), null);
    }

    private static final /* synthetic */ List getAllGroups_aroundBody0(CustomFieldManager this_) {
        ICustomFieldPersistenceService dao = CustomFieldPersistenceService.getInstance();
        List groupList = dao.getAllGroups();
        return groupList;
    }

    private static final /* synthetic */ Object getAllGroups_aroundBody1$advice(CustomFieldManager this_, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return CustomFieldManager.getAllGroups_aroundBody0(this_);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = CustomFieldManager.getAllGroups_aroundBody0(this_);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void saveGroups_aroundBody2(CustomFieldManager this_, List groupList) {
        ICustomFieldPersistenceService dao = CustomFieldPersistenceService.getInstance();
        List allGroups = dao.getAllGroups();
        List<CustomFieldGroup> deletedGroups = this_.getDeletedGroups(allGroups, groupList);
        try {
            dao.saveGroups(groupList);
        }
        catch (CustomFieldDeleteCallbackException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new CustomFieldDeleteCallbackException("save error: " + e.getMessage());
        }
        if (deletedGroups != null && !deletedGroups.isEmpty()) {
            try {
                dao.deleteCustomFieldGroups(deletedGroups);
            }
            catch (CustomFieldDeleteCallbackException e) {
                throw e;
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new CustomFieldDeleteCallbackException("save error: " + e.getMessage());
            }
        }
        DataTypeMappingReader dt = DataTypeMappingReader.getInstance(null, null);
        dt.refreshCustomFieldDataTypeMap(dao.getAllGroups());
    }

    private static final /* synthetic */ Object saveGroups_aroundBody3$advice(CustomFieldManager this_, List groupList, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            CustomFieldManager.saveGroups_aroundBody2(this_, groupList);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            CustomFieldManager.saveGroups_aroundBody2(this_, groupList);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Map getAllCustomFieldsForUISpec_aroundBody4(CustomFieldManager this_) {
        List<CustomFieldGroup> groups = this_.getAllGroups();
        return this_.createCustomFieldMap(groups);
    }

    private static final /* synthetic */ Object getAllCustomFieldsForUISpec_aroundBody5$advice(CustomFieldManager this_, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return CustomFieldManager.getAllCustomFieldsForUISpec_aroundBody4(this_);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Map object = CustomFieldManager.getAllCustomFieldsForUISpec_aroundBody4(this_);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void deleteCustomField_aroundBody6(CustomFieldManager this_, CustomField field) {
        ICustomFieldPersistenceService dao = CustomFieldPersistenceService.getInstance();
        dao.deleteCustomField(field);
    }

    private static final /* synthetic */ Object deleteCustomField_aroundBody7$advice(CustomFieldManager this_, CustomField field, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            CustomFieldManager.deleteCustomField_aroundBody6(this_, field);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            CustomFieldManager.deleteCustomField_aroundBody6(this_, field);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void deleteCustomFieldGroup_aroundBody8(CustomFieldManager this_, CustomFieldGroup group) {
        ICustomFieldPersistenceService dao = CustomFieldPersistenceService.getInstance();
        dao.deleteCustomFieldGroup(group);
    }

    private static final /* synthetic */ Object deleteCustomFieldGroup_aroundBody9$advice(CustomFieldManager this_, CustomFieldGroup group, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            CustomFieldManager.deleteCustomFieldGroup_aroundBody8(this_, group);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            CustomFieldManager.deleteCustomFieldGroup_aroundBody8(this_, group);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void saveImportedCustomFields_aroundBody10(CustomFieldManager this_, List groupList) {
        ICustomFieldPersistenceService dao = CustomFieldPersistenceService.getInstance();
        dao.saveImportedCustomFields(groupList);
    }

    private static final /* synthetic */ Object saveImportedCustomFields_aroundBody11$advice(CustomFieldManager this_, List groupList, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            CustomFieldManager.saveImportedCustomFields_aroundBody10(this_, groupList);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            CustomFieldManager.saveImportedCustomFields_aroundBody10(this_, groupList);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

