/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.assetlist;

import com.tandbergtv.watchpoint.pmm.schedule.DistSchedulePersistenceService;
import com.tandbergtv.watchpoint.pmm.schedule.IDistSchedulePersistenceService;
import com.tandbergtv.watchpoint.pmm.schedule.ISchedulePersistenceService;
import com.tandbergtv.watchpoint.pmm.schedule.SchedulePersistenceService;
import com.tandbergtv.watchpoint.pmm.schedule.monitor.IScheduleMonitor;
import com.tandbergtv.watchpoint.pmm.schedule.notify.IScheduleNotifier;
import com.tandbergtv.watchpoint.pmm.schedule.notify.ScheduleNotifierService;
import com.tandbergtv.watchpoint.pmm.schedule.search.IScheduleSearchService;
import com.tandbergtv.watchpoint.pmm.schedule.search.ScheduleSearchService;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.log4j.Logger;

public class AssetListActivator {
    private static Logger logger = Logger.getLogger(AssetListActivator.class);
    private static final String SCHEDULE_MONITOR_MBEAN = "com.tandbergtv.watchpoint:type=ScheduleMonitor";

    public void start() {
        this.addService((Service)new SchedulePersistenceService());
        this.addService((Service)new ScheduleSearchService());
        this.addService((Service)new DistSchedulePersistenceService());
        ScheduleNotifierService service = new ScheduleNotifierService();
        this.addService((Service)service);
        this.registerMBean(service);
    }

    public void stop() {
        this.unregisterMBean();
        this.removeService(IScheduleNotifier.class);
        this.removeService(IDistSchedulePersistenceService.class);
        this.removeService(IScheduleSearchService.class);
        this.removeService(ISchedulePersistenceService.class);
    }

    private void addService(Service service) {
        ServiceRegistry.getDefault().register(service.getServiceName(), service);
        service.start();
    }

    private void removeService(Class<? extends Service> clazz) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        Service service = (Service)registry.lookup(clazz);
        if (service != null) {
            service.stop();
            registry.unregister(service);
        }
    }

    private void registerMBean(IScheduleNotifier service) {
        IScheduleMonitor statistics = service.getScheduleStatistics();
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            StandardMBean mbean = new StandardMBean(statistics, IScheduleMonitor.class);
            server.registerMBean(mbean, new ObjectName(SCHEDULE_MONITOR_MBEAN));
        }
        catch (Exception ex) {
            logger.warn((Object)"Registration of ScheduleMonitor MBean failed", (Throwable)ex);
        }
    }

    private void unregisterMBean() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            server.unregisterMBean(new ObjectName(SCHEDULE_MONITOR_MBEAN));
        }
        catch (Exception ex) {
            logger.warn((Object)"ScheduleMonitor MBean unregistration failed", (Throwable)ex);
        }
    }
}

