/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.partner.scheduling;

import com.ericsson.cms.scheduler.ActionContext;
import com.ericsson.cms.scheduler.ExecutionContext;
import com.ericsson.cms.scheduler.IWOSchedulerClient;
import com.ericsson.cms.scheduler.Node;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.PartnerType;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.watchpoint.pmm.partner.scheduling.Util;
import com.tandbergtv.watchpoint.pmm.schedule.search.IScheduleSearchService;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SourcePartnerWOSchedulerClient
implements IWOSchedulerClient {
    private static final String PLANNER = "Planner";
    private static final String ID = "Id";
    private static final String DATE = "Date";

    public String getName() {
        return PartnerType.SOURCE.name();
    }

    public String getDisplayName() {
        return "Source Partner";
    }

    public Map<Long, String> getAllEntities() {
        HashMap<Long, String> entities = new HashMap<Long, String>();
        IPartnerManagement partnerManager = (IPartnerManagement)ServiceRegistry.getDefault().lookup(IPartnerManagement.class);
        List partners = partnerManager.getAllActivePartnerDTOsForCurrentUser();
        if (partners != null) {
            for (Partner partner : partners) {
                if (partner.getType() != PartnerType.SOURCE) continue;
                entities.put(partner.getId(), partner.getName());
            }
        }
        return entities;
    }

    public List<Node> getParametersForFilter() {
        ArrayList<Node> roots = new ArrayList<Node>();
        Node root = new Node(PLANNER);
        roots.add(root);
        Node ari = new Node(DATE);
        root.addChild(ari);
        return roots;
    }

    public List<Node> getParametersForWorkOrderMapping(boolean associatedWithTitles) {
        ArrayList<Node> rootList = new ArrayList<Node>();
        rootList.add(Util.getPartnerParameters());
        if (associatedWithTitles) {
            Node scheduleNode = new Node(PLANNER);
            rootList.add(scheduleNode);
            scheduleNode.addChild(new Node(DATE));
            scheduleNode.addChild(new Node(ID));
        }
        return rootList;
    }

    public Map<String, String> getParameterValuesForWorkOrderMapping(Long associatedEntityId) {
        return Util.getPartnerParameterValues(associatedEntityId);
    }

    public ExecutionContext getExecutionContext(Long associatedEntityId, String filterName, Date filterValue) {
        ExecutionContext ec = new ExecutionContext();
        ec.setCommonWOParams(Util.getPartnerParameterValues(associatedEntityId));
        IScheduleSearchService searchService = (IScheduleSearchService)ServiceRegistry.getDefault().lookup(IScheduleSearchService.class);
        Util.setTimeToStartOfTheDay(filterValue);
        Map plannerTitlesMap = searchService.getPlanners(associatedEntityId.longValue(), filterValue);
        for (Map.Entry mapEntry : plannerTitlesMap.entrySet()) {
            Map<String, String> paramRefValues = this.getParameterReferenceValues((Long)mapEntry.getKey(), filterValue);
            for (Long titleId : (Set)mapEntry.getValue()) {
                ActionContext ac = new ActionContext();
                ac.setTitleId(titleId.longValue());
                ac.setWorkOrderMappingParams(paramRefValues);
                ec.add(ac);
            }
        }
        return ec;
    }

    public String getAssociationDescription(List<Long> associatedEntityIds) {
        String associationDescription = this.getName() + ": [";
        IPartnerManagement partnerManager = (IPartnerManagement)ServiceRegistry.getDefault().lookup(IPartnerManagement.class);
        int count = 0;
        for (Long associatedEntityId : associatedEntityIds) {
            ++count;
            Partner partner = partnerManager.getPartner(associatedEntityId.longValue());
            if (partner == null) continue;
            if (count > 1) {
                associationDescription = associationDescription + ", ";
            }
            String partnerName = partner.getName();
            associationDescription = associationDescription + partnerName;
        }
        associationDescription = associationDescription + "]";
        return associationDescription;
    }

    private Map<String, String> getParameterReferenceValues(Long plannerId, Date date) {
        HashMap<String, String> refValues = new HashMap<String, String>();
        refValues.put("Planner.Id", plannerId.toString());
        refValues.put("Planner.Date", Util.formatForWorkflow(date));
        return refValues;
    }
}

