/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title;

import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.content.contentclass.hibernate.ContentClassOptionsProvider;
import com.tandbergtv.content.contentclass.hibernate.ContentClassServiceHibernate;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.content.contentclass.service.ICustomFieldManager;
import com.tandbergtv.content.lookupkey.LookupKeyManager;
import com.tandbergtv.content.lookupkey.service.ILookupKeyManager;
import com.tandbergtv.content.metadata.CustomFieldManager;
import com.tandbergtv.content.metadata.IMetadataService;
import com.tandbergtv.content.metadata.MetadataServiceImpl;
import com.tandbergtv.metadatamanager.IAssetCompareService;
import com.tandbergtv.metadatamanager.IAssetCopyService;
import com.tandbergtv.metadatamanager.ITTVDataModelHandler;
import com.tandbergtv.metadatamanager.JPFActivator;
import com.tandbergtv.metadatamanager.customfield.persistence.CustomFieldPersistenceService;
import com.tandbergtv.metadatamanager.customfield.persistence.ICustomFieldPersistenceService;
import com.tandbergtv.metadatamanager.factoryImpl.SpecHandlerFactory;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.metadatamanager.util.CompatibilityInfo;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import com.tandbergtv.metadatamanager.util.FieldAliasMappingReader;
import com.tandbergtv.metadatamanager.util.FileFieldMappingReader;
import com.tandbergtv.metadatamanager.util.XPathMappingReader;
import com.tandbergtv.neptune.licensing.ILicenseManager;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.ApplicationContextHelper;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.metadataconfig.IMetadataConfigurationReader;
import com.tandbergtv.watchpoint.pmm.metadataconfig.IMetadataConfigurator;
import com.tandbergtv.watchpoint.pmm.metadataconfig.MetadataConfigurationReaderImpl;
import com.tandbergtv.watchpoint.pmm.metadataconfig.MetadataConfiguratorImpl;
import com.tandbergtv.watchpoint.pmm.title.DefaultTitlePersistenceService;
import com.tandbergtv.watchpoint.pmm.title.ITitleActivityService;
import com.tandbergtv.watchpoint.pmm.title.ITitleAssetPropertyManager;
import com.tandbergtv.watchpoint.pmm.title.ITitleAssetResourceManager;
import com.tandbergtv.watchpoint.pmm.title.ITitleCompareService;
import com.tandbergtv.watchpoint.pmm.title.ITitleCopyService;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.ITitlePersistenceService;
import com.tandbergtv.watchpoint.pmm.title.ITitleResourceManager;
import com.tandbergtv.watchpoint.pmm.title.ITitleService;
import com.tandbergtv.watchpoint.pmm.title.ITitleThumbnailReader;
import com.tandbergtv.watchpoint.pmm.title.TitleAssetPropertyManager;
import com.tandbergtv.watchpoint.pmm.title.TitleAssetResourceManager;
import com.tandbergtv.watchpoint.pmm.title.TitleManager;
import com.tandbergtv.watchpoint.pmm.title.TitleSearchPersistenceService;
import com.tandbergtv.watchpoint.pmm.title.TitleService;
import com.tandbergtv.watchpoint.pmm.title.activity.TitleActivityService;
import com.tandbergtv.watchpoint.pmm.title.compare.TitleCompareService;
import com.tandbergtv.watchpoint.pmm.title.conf.AssetTypesConfigurationService;
import com.tandbergtv.watchpoint.pmm.title.conf.IAssetTypesConfigurationService;
import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.watchpoint.pmm.title.conf.SpecificationBuilder;
import com.tandbergtv.watchpoint.pmm.title.conf.SpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecificationBuilder;
import com.tandbergtv.watchpoint.pmm.title.conf.specs.RightsManagerFactory;
import com.tandbergtv.watchpoint.pmm.title.copy.TitleCopyService;
import com.tandbergtv.watchpoint.pmm.title.ingest.ITitleIngestService;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleIngestService;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleIngester;
import com.tandbergtv.watchpoint.pmm.title.resource.TitleResourceManager;
import com.tandbergtv.watchpoint.pmm.title.search.AssetInfoProvider;
import com.tandbergtv.watchpoint.pmm.title.search.TitleSearchService;
import com.tandbergtv.watchpoint.pmm.title.template.ITitleTemplateProvider;
import com.tandbergtv.watchpoint.pmm.title.template.TitleTemplateProvider;
import com.tandbergtv.watchpoint.pmm.title.thumbnail.TitleThumbnailReader;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginRegistry;
import org.springframework.context.ApplicationContext;

public class TitleActivator {
    private static final String PLUGIN_ID = "com.tandbergtv.metadata";
    private static final String INTERNAL_SPECIFICATION = "TTV";
    public static final String CONTENT_PLUGIN_FOLDER_RELATIVE_PATH = "plugins" + File.separator + "content";
    public static final String JPF_PLUGIN_REPOSITORY_PROPERTY = "org.java.plugin.boot.pluginsRepositories";
    public static final String PRODUCT_DIR = "com.tandbergtv.cms.product.dir";
    private static final String[] CONTEXT_CONFIG_FILES = new String[]{"MetadataBeansContext.xml", "com/tandbergtv/watchpoint/pmm/dao/hibernate/TitleMetadataManagerDB_JTA_Context.xml", "META-INF/metadatamanager/MDM_DataSource.xml"};
    private static final Logger logger = Logger.getLogger(TitleActivator.class);

    public void start() {
        ApplicationContext context = this.initializeSpringContext();
        ITTVDataModelHandler assetDataModelHandler = this.getAssetDataModelHandler(context);
        PluginManager pluginManager = this.intializeMetadataPlugins();
        HibernateContext.getContext().initializeContext();
        this.addService((Service)new ContentClassServiceHibernate());
        this.addService((Service)new MetadataConfigurationReaderImpl());
        this.addService((Service)new MetadataConfiguratorImpl());
        this.addService((Service)new ContentClassOptionsProvider());
        this.addService(new DefaultTitlePersistenceService(assetDataModelHandler));
        this.addService((Service)new TitleSearchPersistenceService());
        this.addService((Service)new TitleSearchService());
        this.addService((Service)new AssetInfoProvider());
        this.addService((Service)new LookupKeyManager());
        this.addService((Service)new SpecificationManager());
        this.addService((Service)new TitleManager());
        this.addService((Service)TitleService.getInstance());
        this.addService(new TitleResourceManager());
        this.addService(new TitleAssetPropertyManager());
        this.addService((Service)new TitleAssetResourceManager());
        this.addService((Service)new TitleThumbnailReader());
        this.addService((Service)new TitleTemplateProvider());
        this.addService((Service)new TitleCopyService((IAssetCopyService)assetDataModelHandler));
        this.addService((Service)new TitleCompareService((IAssetCompareService)assetDataModelHandler));
        this.addService((Service)new TitleActivityService());
        this.addService((Service)new TitleIngestService());
        this.addService((Service)new TitleIngester());
        this.addService((Service)AssetTypesConfigurationService.newInstance());
        this.addService((Service)new MetadataServiceImpl());
        this.addService((Service)new CustomFieldManager());
        this.addMetadataFormatSpecifications(pluginManager, context);
        this.initializeUISpecification(pluginManager);
        this.loadRightsManager(pluginManager);
        logger.debug((Object)"Title services started");
    }

    private void initializeUISpecification(PluginManager pluginManager) {
        ISpecificationManager sm = (ISpecificationManager)ServiceRegistry.getDefault().lookup(ISpecificationManager.class);
        UISpecificationBuilder builder = new UISpecificationBuilder(pluginManager);
        UISpecification packageSpec = builder.buildPackageSpecification();
        UISpecification seriesSpec = builder.buildSeriesSpecification(packageSpec);
        sm.setUISpecification(UISpecification.Type.PACKAGE, packageSpec);
        sm.setUISpecification(UISpecification.Type.SERIES, seriesSpec);
        ICustomFieldManager cfm = (ICustomFieldManager)ServiceRegistry.getDefault().lookup(ICustomFieldManager.class);
        Map groups = cfm.getAllCustomFieldsForUISpec();
        sm.updateUISpecifications(groups);
    }

    private void loadRightsManager(PluginManager pluginManager) {
        PluginRegistry registry = pluginManager.getRegistry();
        ExtensionPoint point = registry.getExtensionPoint(PLUGIN_ID, "rightsManager");
        RightsManagerFactory.createRightsManager(pluginManager, point);
    }

    public void stop() {
        this.removeService(ICustomFieldManager.class);
        this.removeService(IMetadataService.class);
        this.removeService(ITitleIngestService.class);
        this.removeService(ITitleActivityService.class);
        this.removeService(ITitleCompareService.class);
        this.removeService(ITitleCopyService.class);
        this.removeService(ITitleTemplateProvider.class);
        this.removeService(ITitleThumbnailReader.class);
        this.removeService(ITitleAssetResourceManager.class);
        this.removeService(ITitleAssetPropertyManager.class);
        this.removeService(ITitleResourceManager.class);
        this.removeService(ITitleService.class);
        this.removeService(ITitleManager.class);
        this.removeService(ISpecificationManager.class);
        this.removeService(ILookupKeyManager.class);
        this.removeService(ITitleSearchService.class);
        this.removeService(ITitlePersistenceService.class);
        this.removeService(IContentClassService.class);
        this.removeService(IAssetTypesConfigurationService.class);
        this.removeService(IMetadataConfigurator.class);
        this.removeService(IMetadataConfigurationReader.class);
        HibernateContext.getContext().closeContext();
        logger.debug((Object)"Title services stopped");
    }

    private void addService(Service service) {
        ServiceRegistry.getDefault().register(service.getServiceName(), service);
        service.start();
    }

    private void removeService(Class<? extends Service> clazz) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        Service service = (Service)registry.lookup(clazz);
        if (service != null) {
            service.stop();
            registry.unregister(service);
        }
    }

    private void addMetadataFormatSpecifications(PluginManager pluginManager, ApplicationContext context) {
        DataTypeMappingReader dt = DataTypeMappingReader.getInstance((PluginManager)pluginManager);
        ICustomFieldPersistenceService cfs = CustomFieldPersistenceService.getInstance((ApplicationContext)context);
        dt.refreshCustomFieldDataTypeMap(cfs.getAllGroups());
        FileFieldMappingReader.getInstance((PluginManager)pluginManager);
        FieldAliasMappingReader.getInstance((PluginManager)pluginManager);
        CompatibilityInfo.getInstance((PluginManager)pluginManager);
        XPathMappingReader.getInstance();
        new com.tandbergtv.metadatamanager.conf.SpecificationBuilder(pluginManager, context).buildSpecifications();
        int maxCount = this.getMetadataPluginMaxCount();
        if (maxCount > 0) {
            Map map = SpecHandlerFactory.getHandlers();
            int count = 0;
            TreeSet<String> keysToRemove = new TreeSet<String>();
            for (ISpecHandler handler : map.values()) {
                if (!INTERNAL_SPECIFICATION.equals(handler.getSpecName())) {
                    ++count;
                }
                if (count <= maxCount || INTERNAL_SPECIFICATION.equals(handler.getSpecName())) continue;
                keysToRemove.add(handler.getSpecName());
            }
            if (!keysToRemove.isEmpty()) {
                logger.info((Object)("Your license only allows to load " + maxCount + " plugins."));
                for (String key : keysToRemove) {
                    logger.info((Object)("Removing " + key));
                    map.remove(key);
                }
            }
        }
        ISpecificationManager sm = (ISpecificationManager)ServiceRegistry.getDefault().lookup(ISpecificationManager.class);
        SpecificationBuilder builder = SpecificationBuilder.createInstance(pluginManager, SpecHandlerFactory.getHandlers());
        for (Specification specification : builder.buildSpecifications()) {
            if (INTERNAL_SPECIFICATION.equals(specification.getAlias())) {
                sm.setInternalSpecification(specification);
                continue;
            }
            sm.addSpecification(specification);
        }
    }

    private int getMetadataPluginMaxCount() {
        try {
            ILicenseManager mgr = (ILicenseManager)InjectionUtil.injectInstance((String)"cms/LicenseManager/local", ILicenseManager.class);
            String str = mgr.getProperty("MetadataFormats.MaxCount");
            if (str == null || str.isEmpty()) {
                return 0;
            }
            return Integer.parseInt(str);
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to get Metadata Plugin max count from the license manager.", (Throwable)ex);
            return 0;
        }
    }

    private ApplicationContext initializeSpringContext() {
        logger.debug((Object)"Initializing the Metadata Manager spring context...");
        ApplicationContextHelper helper = new ApplicationContextHelper(CONTEXT_CONFIG_FILES);
        logger.debug((Object)"Successfully initialized the Metadata Manager spring context.");
        return helper.getContext();
    }

    private PluginManager intializeMetadataPlugins() {
        Properties properties = new Properties();
        String installFolder = System.getProperty(PRODUCT_DIR);
        File pluginFolder = new File(installFolder, CONTENT_PLUGIN_FOLDER_RELATIVE_PATH);
        properties.put(JPF_PLUGIN_REPOSITORY_PROPERTY, pluginFolder.getAbsolutePath());
        JPFActivator jpfActivator = new JPFActivator();
        jpfActivator.start(properties);
        return jpfActivator.getPluginManager();
    }

    private ITTVDataModelHandler getAssetDataModelHandler(ApplicationContext context) {
        return (ITTVDataModelHandler)context.getBean("TTVSpecHandler");
    }
}

