/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.factoryImpl.SpecHandlerFactory;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.FieldName;
import com.tandbergtv.metadatamanager.search.AssetSearchService;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.metadatamanager.util.binder.AssetType;
import com.tandbergtv.watchpoint.pmm.core.ITitleStatusService;
import com.tandbergtv.watchpoint.pmm.core.TitlePersistenceException;
import com.tandbergtv.watchpoint.pmm.core.TitlePropertyManager;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationMessage;
import com.tandbergtv.watchpoint.pmm.entities.ISavedTitle;
import com.tandbergtv.watchpoint.pmm.entities.ITitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.SaveResult;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleProperty;
import com.tandbergtv.watchpoint.pmm.entities.TitleResource;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.entities.event.TitleStatusUpdatedEvent;
import com.tandbergtv.watchpoint.pmm.entities.event.TitleUpdatedEvent;
import com.tandbergtv.watchpoint.pmm.title.ITitleAssetManager;
import com.tandbergtv.watchpoint.pmm.title.ITitleDeleteCallback;
import com.tandbergtv.watchpoint.pmm.title.ITitleDocumentManager;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.ITitlePersistCallback;
import com.tandbergtv.watchpoint.pmm.title.ITitlePersistenceService;
import com.tandbergtv.watchpoint.pmm.title.ITitleResourceManager;
import com.tandbergtv.watchpoint.pmm.title.TitleAssetManager;
import com.tandbergtv.watchpoint.pmm.title.TitleDeleteException;
import com.tandbergtv.watchpoint.pmm.title.TitleDocumentActionException;
import com.tandbergtv.watchpoint.pmm.title.TitleDocumentManager;
import com.tandbergtv.watchpoint.pmm.title.TitleStatusService;
import com.tandbergtv.watchpoint.pmm.title.TitleThumbnailHandler;
import com.tandbergtv.watchpoint.pmm.title.TitleValidator;
import com.tandbergtv.watchpoint.pmm.title.autofill.AutoFillService;
import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import com.tandbergtv.watchpoint.pmm.title.resource.FileManager;
import com.tandbergtv.watchpoint.pmm.util.ProgressStatusHelper;
import com.tandbergtv.watchpoint.pmm.util.RulesEngineFacade;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.w3c.dom.Document;

public class TitleManager
implements ITitleManager {
    private ITitlePersistenceService titlePersistenceService;
    private ITitleStatusService statusService;
    private ITitleAssetManager titleAssetManager;
    private ITitleDocumentManager titleDocumentManager;
    private TitleValidator titleValidator;
    private TitleThumbnailHandler thumbnailHandler;
    private FileManager fileManager;
    private static final String SERVICE_NAME = "Title Manager Service";
    static final String FILE_LOOKUP_KEY_XPATH = "/Fields/CustomFields/CustomField[@name=LookupKey]/@value";
    private static final Logger logger = Logger.getLogger(TitleManager.class);

    @Transactional
    public ISavedTitle create(Title title, boolean draft, ITitleActionSource source) throws TitleValidationException {
        Title title2 = title;
        boolean bl = draft;
        ITitleActionSource iTitleActionSource = source;
        return (ISavedTitle)TitleManager.create_aroundBody1$advice(this, title2, bl, iTitleActionSource, TransactionEnforcer.aspectOf(), TitleManager.class.getDeclaredMethod("create", Title.class, Boolean.TYPE, ITitleActionSource.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public ISavedTitle update(Title title, boolean draft, ITitleActionSource source) throws TitleValidationException {
        Title title2 = title;
        boolean bl = draft;
        ITitleActionSource iTitleActionSource = source;
        return (ISavedTitle)TitleManager.update_aroundBody3$advice(this, title2, bl, iTitleActionSource, TransactionEnforcer.aspectOf(), TitleManager.class.getDeclaredMethod("update", Title.class, Boolean.TYPE, ITitleActionSource.class).getAnnotation(Transactional.class), null);
    }

    private ISavedTitle save(Title title, boolean draft, ITitleActionSource source, String statusName, String statusValue) throws TitleValidationException {
        return this.saveOrRollback(title, null, draft, source, statusName, statusValue, false);
    }

    @Transactional
    public ISavedTitle rollback(Long titleID, String version, boolean draft, ITitleActionSource source) throws TitleValidationException {
        Long l = titleID;
        String string = version;
        boolean bl = draft;
        ITitleActionSource iTitleActionSource = source;
        return (ISavedTitle)TitleManager.rollback_aroundBody5$advice(this, l, string, bl, iTitleActionSource, TransactionEnforcer.aspectOf(), TitleManager.class.getDeclaredMethod("rollback", Long.class, String.class, Boolean.TYPE, ITitleActionSource.class).getAnnotation(Transactional.class), null);
    }

    private ISavedTitle rollback(Title oldTitle, String version, boolean draft, ITitleActionSource source, String statusName, String statusValue) throws TitleValidationException {
        return this.saveOrRollback(oldTitle, version, draft, source, statusName, statusValue, true);
    }

    private ISavedTitle saveOrRollback(Title title, String version, boolean draft, ITitleActionSource source, String statusName, String statusValue, boolean isRollback) throws TitleValidationException {
        ISpecificationManager specManager = this.getService(ISpecificationManager.class);
        UISpecification uiSpec = specManager.getUISpecification(UISpecification.Type.PACKAGE);
        ContentClass contentClass = null;
        IContentClassService ccService = this.getService(IContentClassService.class);
        try {
            contentClass = ccService.getContentClassById(title.getContentClassId().longValue());
        }
        catch (ContentClassPersistenceException ex) {
            // empty catch block
        }
        if (contentClass == null) {
            String str = "Unable to get content class with id: " + title.getContentClassId();
            TitleValidationMessage msg = TitleValidationMessage.createMessage((TitleValidationMessage.Type)TitleValidationMessage.Type.Error, (String)"ContentClass", (String)str);
            ArrayList<TitleValidationMessage> list = new ArrayList<TitleValidationMessage>(1);
            list.add(msg);
            throw new TitleValidationException(list);
        }
        AutoFillService autoFillService = new AutoFillService(uiSpec, contentClass, title);
        autoFillService.autoFill();
        List<TitleValidationMessage> messages = this.validate(title, draft);
        TitleStatus oldStatus = title.getStatus();
        if (draft) {
            title.setStatus(TitleStatus.DRAFT);
        } else {
            this.statusService.updateTitleStatus(title, contentClass);
        }
        title.setLastModifiedTime(new Date());
        Title oldTitle = null;
        if (title.getAsset() != null && title.getAsset().getId() > 0L) {
            Asset rootAsset = this.titlePersistenceService.getAsset(title.getAsset().getId());
            oldTitle = new Title(title.getId());
            oldTitle.setAsset(rootAsset);
        }
        ServiceLoader<ITitlePersistCallback> loader = ServiceLoader.load(ITitlePersistCallback.class);
        Iterator<ITitlePersistCallback> serviceIterator = loader.iterator();
        while (serviceIterator != null && serviceIterator.hasNext()) {
            serviceIterator.next().onBeforePersist(title);
        }
        if (isRollback) {
            this.titlePersistenceService.rollback(title, version);
        } else {
            this.titlePersistenceService.save(title);
        }
        serviceIterator = loader.iterator();
        while (serviceIterator != null && serviceIterator.hasNext()) {
            serviceIterator.next().onPersist(title);
        }
        this.thumbnailHandler.updateThumbnails(title, oldTitle);
        if (!draft) {
            if (title.getStatus() != oldStatus) {
                TitleStatusUpdatedEvent event = new TitleStatusUpdatedEvent((Object)this, title, oldStatus, title.getStatus());
                DefaultMediator.getInstance().sendAsync((WorkflowEvent)event);
            }
            TitleUpdatedEvent titleUpdatedEvent = new TitleUpdatedEvent((Object)this, title);
            DefaultMediator.getInstance().sendAsync((WorkflowEvent)titleUpdatedEvent);
        }
        if (!draft || isRollback) {
            this.statusService.sendStatus(title, statusName, statusValue, true, source.getComponentName(), source.getEntityName(), source.getID());
        }
        if (!draft) {
            this.statusService.sendStatus(title, ProgressStatusHelper.VALIDATION_SUCCESS, null, true, source.getComponentName(), source.getEntityName(), source.getID());
        }
        return new SaveResult(title, messages);
    }

    @Transactional
    public boolean delete(Long titleID) throws TitleDeleteException {
        Long l = titleID;
        return Conversions.booleanValue((Object)TitleManager.delete_aroundBody7$advice(this, l, TransactionEnforcer.aspectOf(), TitleManager.class.getDeclaredMethod("delete", Long.class).getAnnotation(Transactional.class), null));
    }

    @Transactional
    public Title get(Long titleID) {
        Long l = titleID;
        return (Title)TitleManager.get_aroundBody9$advice(this, l, TransactionEnforcer.aspectOf(), TitleManager.class.getDeclaredMethod("get", Long.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public Title getForUpdate(Long titleID) {
        Long l = titleID;
        return (Title)TitleManager.getForUpdate_aroundBody11$advice(this, l, TransactionEnforcer.aspectOf(), TitleManager.class.getDeclaredMethod("getForUpdate", Long.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public Title get(Long titleID, String version) {
        Long l = titleID;
        String string = version;
        return (Title)TitleManager.get_aroundBody13$advice(this, l, string, TransactionEnforcer.aspectOf(), TitleManager.class.getDeclaredMethod("get", Long.class, String.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    @Deprecated
    public Title getWithHistory(Long titleID) {
        Long l = titleID;
        return (Title)TitleManager.getWithHistory_aroundBody15$advice(this, l, TransactionEnforcer.aspectOf(), TitleManager.class.getDeclaredMethod("getWithHistory", Long.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public Long getIDByAssetID(Long rootAssetID) {
        Long l = rootAssetID;
        return (Long)TitleManager.getIDByAssetID_aroundBody17$advice(this, l, TransactionEnforcer.aspectOf(), TitleManager.class.getDeclaredMethod("getIDByAssetID", Long.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public boolean isActive(Long titleID) {
        Long l = titleID;
        return Conversions.booleanValue((Object)TitleManager.isActive_aroundBody19$advice(this, l, TransactionEnforcer.aspectOf(), TitleManager.class.getDeclaredMethod("isActive", Long.class).getAnnotation(Transactional.class), null));
    }

    @Transactional
    public boolean isExisting(Long titleID) {
        Long l = titleID;
        return Conversions.booleanValue((Object)TitleManager.isExisting_aroundBody21$advice(this, l, TransactionEnforcer.aspectOf(), TitleManager.class.getDeclaredMethod("isExisting", Long.class).getAnnotation(Transactional.class), null));
    }

    @Transactional
    public void verifyTitleExists(Long titleID) {
        Long l = titleID;
        TitleManager.verifyTitleExists_aroundBody23$advice(this, l, TransactionEnforcer.aspectOf(), TitleManager.class.getDeclaredMethod("verifyTitleExists", Long.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public List<TitleValidationMessage> validate(Title title, boolean draft) throws TitleValidationException {
        Title title2 = title;
        boolean bl = draft;
        return (List)TitleManager.validate_aroundBody25$advice(this, title2, bl, TransactionEnforcer.aspectOf(), TitleManager.class.getDeclaredMethod("validate", Title.class, Boolean.TYPE).getAnnotation(Transactional.class), null);
    }

    public com.tandbergtv.metadatamanager.model.File createDerivedFile() {
        return this.titleAssetManager.createDerivedFile();
    }

    public com.tandbergtv.metadatamanager.model.File createOriginalFile() {
        return this.titleAssetManager.createOriginalFile();
    }

    public Set<String> getFileLookupKeys(Asset asset) {
        return this.titleAssetManager.getFileLookupKeys(asset);
    }

    public String getFileLookupKey(com.tandbergtv.metadatamanager.model.File file) {
        return this.titleAssetManager.getFileLookupKey(file);
    }

    public com.tandbergtv.metadatamanager.model.File getFileWithLookupKey(Asset asset, String fileLookupKey) {
        return this.titleAssetManager.getFileWithLookupKey(asset, fileLookupKey);
    }

    public Collection<com.tandbergtv.metadatamanager.model.File> getFilesWithoutLookupKey(Asset asset) {
        return this.titleAssetManager.getFilesWithoutLookupKey(asset);
    }

    public void filterFiles(Asset asset, Set<String> fileLookupKeys) {
        this.titleAssetManager.filterFiles(asset, fileLookupKeys);
    }

    public void filterFiles(Asset asset, String fileLookupKey) {
        this.titleAssetManager.filterFiles(asset, fileLookupKey);
    }

    public void updateWithFileMetadata(Asset asset, String fileLookupKey) throws MetadataException {
        this.titleAssetManager.updateWithFileMetadata(asset, fileLookupKey);
    }

    public void setLookupKey(com.tandbergtv.metadatamanager.model.File file, String value) {
        this.titleAssetManager.setLookupKey(file, value);
    }

    public Document getDocument(Title title, Specification specification) throws TitleDocumentActionException {
        return this.titleDocumentManager.getDocument(title, specification);
    }

    @Deprecated
    public Document getDocument(Title title) throws TitleDocumentActionException {
        return this.titleDocumentManager.getDocument(title);
    }

    public Document getTTVDocument(Title title) throws TitleDocumentActionException {
        return this.titleDocumentManager.getTTVDocument(title);
    }

    public Document getECMFDocument(Title title) throws TitleDocumentActionException {
        return this.titleDocumentManager.getECMFDocument(title);
    }

    public Title getTitle(Document document) throws TitleDocumentActionException {
        return this.titleDocumentManager.getTitle(document);
    }

    public List<Long> getTitleIDs(Document document) throws TitleDocumentActionException {
        return this.titleDocumentManager.getTitleIDs(document);
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void start() {
        this.titlePersistenceService = this.getService(ITitlePersistenceService.class);
        this.statusService = new TitleStatusService();
        this.titleValidator = new TitleValidator();
        this.titleAssetManager = new TitleAssetManager();
        this.titleDocumentManager = new TitleDocumentManager(this);
        this.thumbnailHandler = new TitleThumbnailHandler();
        this.fileManager = new FileManager();
    }

    public void stop() {
    }

    private <T extends Service> T getService(Class<T> serviceClass) {
        return (T)((Service)ServiceRegistry.getDefault().lookup(serviceClass));
    }

    @Transactional
    public ISavedTitle retire(Long titleID, ITitleActionSource source) throws TitlePersistenceException, TitleValidationException {
        Long l = titleID;
        ITitleActionSource iTitleActionSource = source;
        return (ISavedTitle)TitleManager.retire_aroundBody27$advice(this, l, iTitleActionSource, TransactionEnforcer.aspectOf(), TitleManager.class.getDeclaredMethod("retire", Long.class, ITitleActionSource.class).getAnnotation(Transactional.class), null);
    }

    private void removePhysicalFiles(Title title) {
        List files = title.getAllFiles();
        HashSet<String> deletedFileUrls = new HashSet<String>();
        for (com.tandbergtv.metadatamanager.model.File file : files) {
            deletedFileUrls.add(file.getURL());
        }
        this.collectOldRevisionFiles(title, deletedFileUrls);
        for (String fileUrl : deletedFileUrls) {
            this.deleteContentFile(fileUrl);
        }
    }

    private void collectOldRevisionFiles(Title title, Set<String> deletedFileUrls) {
        ISpecHandler specHandler = SpecHandlerFactory.getInstance((String)"TTV");
        AssetSearchService searchService = specHandler.getSearchService();
        String path = "/" + AssetType.FILE.toString() + FieldName.FILE_URL.toString();
        long documentId = title.getDocumentId();
        deletedFileUrls.addAll(searchService.getFieldValuesFromForRevision(path, Long.valueOf(documentId)));
    }

    private void deleteContentFile(String fileUrl) {
        try {
            if (fileUrl != null) {
                File ioFile = new File(fileUrl);
                this.fileManager.deleteFile(ioFile);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to delete title content file: " + fileUrl + ", error: " + e.getMessage()));
        }
    }

    private void removeAssetFiles(Title title) {
        for (com.tandbergtv.metadatamanager.model.File file : title.getAllFiles()) {
            title.removeAsset((Asset)file);
        }
    }

    private void deleteResourcesFromTitle(Long titleID) {
        List<TitleResource> resources = this.titleResourceManager().getByTitle(titleID);
        for (TitleResource resource : resources) {
            this.titleResourceManager().delete(resource.getId());
        }
    }

    @Transactional
    public Map<String, String> getProperties(Long titleID) {
        Long l = titleID;
        return (Map)TitleManager.getProperties_aroundBody29$advice(this, l, TransactionEnforcer.aspectOf(), TitleManager.class.getDeclaredMethod("getProperties", Long.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public String getProperty(Long titleID, String name) {
        Long l = titleID;
        String string = name;
        return (String)TitleManager.getProperty_aroundBody31$advice(this, l, string, TransactionEnforcer.aspectOf(), TitleManager.class.getDeclaredMethod("getProperty", Long.class, String.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public void setProperty(Long titleID, String name, String value) {
        Long l = titleID;
        String string = name;
        String string2 = value;
        TitleManager.setProperty_aroundBody33$advice(this, l, string, string2, TransactionEnforcer.aspectOf(), TitleManager.class.getDeclaredMethod("setProperty", Long.class, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    private TitleProperty createProperty(Long titleID, String name, String value) {
        TitleProperty result = new TitleProperty();
        result.setTitleId(titleID);
        result.setName(name);
        result.setValue(value);
        return result;
    }

    public Title normalize(Title title, String contentEventName) {
        if (title == null) {
            throw new IllegalArgumentException("title can't be null");
        }
        if (contentEventName == null) {
            throw new IllegalArgumentException("contentEventName can't be null");
        }
        return RulesEngineFacade.nationalize(title, contentEventName, null);
    }

    public Title normalizeWithMetatadataEnhancement(Title title, String contentEventName, String meRequestKey) {
        if (title == null) {
            throw new IllegalArgumentException("title can't be null");
        }
        if (contentEventName == null) {
            throw new IllegalArgumentException("contentEventName can't be null");
        }
        return RulesEngineFacade.nationalize(title, contentEventName, meRequestKey);
    }

    public ISavedTitle save(Title title, ITitleActionSource source) throws TitleValidationException {
        if (title == null) {
            throw new IllegalArgumentException("title can't be null");
        }
        try {
            return this.createOrUpdate(title, false, source);
        }
        catch (TitleValidationException e) {
            ISavedTitle savedTitle = this.createOrUpdate(title, true, source);
            title = savedTitle.getTitle();
            this.statusService.sendStatus(title, ProgressStatusHelper.VALIDATION_FAILURE, e.getMessage(), false, source.getComponentName(), source.getEntityName(), source.getID());
            return new SaveResult(savedTitle, e);
        }
    }

    @Transactional
    public ISavedTitle associateTitleToSeries(Long titleID, Long seriesDocumentId, Long seasonAssetId, ITitleActionSource source) throws TitleValidationException {
        Long l = titleID;
        Long l2 = seriesDocumentId;
        Long l3 = seasonAssetId;
        ITitleActionSource iTitleActionSource = source;
        return (ISavedTitle)TitleManager.associateTitleToSeries_aroundBody35$advice(this, l, l2, l3, iTitleActionSource, TransactionEnforcer.aspectOf(), TitleManager.class.getDeclaredMethod("associateTitleToSeries", Long.class, Long.class, Long.class, ITitleActionSource.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public void dissociateTitleFromSeries(Long titleID) throws TitleValidationException {
        Long l = titleID;
        TitleManager.dissociateTitleFromSeries_aroundBody37$advice(this, l, TransactionEnforcer.aspectOf(), TitleManager.class.getDeclaredMethod("dissociateTitleFromSeries", Long.class).getAnnotation(Transactional.class), null);
    }

    private ISavedTitle createOrUpdate(Title title, boolean draft, ITitleActionSource source) throws TitleValidationException {
        if (title.getId() == null) {
            return this.create(title, draft, source);
        }
        return this.update(title, draft, source);
    }

    public Long getPartnerId(Long titleId) {
        return this.titlePersistenceService.getPartnerId(titleId);
    }

    public ITitleResourceManager titleResourceManager() {
        return (ITitleResourceManager)ServiceRegistry.getDefault().lookup(ITitleResourceManager.class);
    }

    public Asset getAsset(Long id) {
        return this.titleAssetManager.getAsset(id);
    }

    private static final /* synthetic */ ISavedTitle create_aroundBody0(TitleManager this_, Title title, boolean draft, ITitleActionSource source) {
        if (title.getId() != null) {
            throw new RuntimeException("Cannot create title since ID is already defined.");
        }
        return this_.save(title, draft, source, ProgressStatusHelper.CREATED, null);
    }

    private static final /* synthetic */ Object create_aroundBody1$advice(TitleManager this_, Title title, boolean draft, ITitleActionSource source, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleManager.create_aroundBody0(this_, title, draft, source);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ISavedTitle object = TitleManager.create_aroundBody0(this_, title, draft, source);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ ISavedTitle update_aroundBody2(TitleManager this_, Title title, boolean draft, ITitleActionSource source) {
        if (!this_.isActive(title.getId())) {
            throw new RuntimeException("Cannot update title since it is not active.");
        }
        return this_.save(title, draft, source, ProgressStatusHelper.UPDATED, null);
    }

    private static final /* synthetic */ Object update_aroundBody3$advice(TitleManager this_, Title title, boolean draft, ITitleActionSource source, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleManager.update_aroundBody2(this_, title, draft, source);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ISavedTitle object = TitleManager.update_aroundBody2(this_, title, draft, source);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ ISavedTitle rollback_aroundBody4(TitleManager this_, Long titleID, String version, boolean draft, ITitleActionSource source) {
        if (!this_.isActive(titleID)) {
            throw new RuntimeException("Cannot rollback title since it is not active.");
        }
        Title title = this_.getForUpdate(titleID);
        if (title.getStatus(version) == TitleStatus.DRAFT) {
            throw new RuntimeException("Cannot rollback to a DRAFT version.");
        }
        Title oldTitle = this_.get(titleID, version);
        title.setAsset(oldTitle.getAsset());
        return this_.rollback(title, version, draft, source, ProgressStatusHelper.ROLLED_BACK, null);
    }

    private static final /* synthetic */ Object rollback_aroundBody5$advice(TitleManager this_, Long titleID, String version, boolean draft, ITitleActionSource source, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleManager.rollback_aroundBody4(this_, titleID, version, draft, source);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ISavedTitle object = TitleManager.rollback_aroundBody4(this_, titleID, version, draft, source);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ boolean delete_aroundBody6(TitleManager this_, Long titleID) {
        if (!this_.isActive(titleID)) {
            return false;
        }
        Title title = this_.getForUpdate(titleID);
        ServiceLoader<ITitleDeleteCallback> loader = ServiceLoader.load(ITitleDeleteCallback.class);
        Iterator<ITitleDeleteCallback> serviceIterator = loader.iterator();
        while (serviceIterator != null && serviceIterator.hasNext()) {
            serviceIterator.next().onBeforeDelete(title);
        }
        boolean result = this_.titlePersistenceService.delete(titleID);
        serviceIterator = loader.iterator();
        while (serviceIterator != null && serviceIterator.hasNext()) {
            serviceIterator.next().onDelete(title);
        }
        RulesEngineFacade.sendDeletedEvent(titleID);
        return result;
    }

    private static final /* synthetic */ Object delete_aroundBody7$advice(TitleManager this_, Long titleID, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.booleanObject((boolean)TitleManager.delete_aroundBody6(this_, titleID));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.booleanObject((boolean)TitleManager.delete_aroundBody6(this_, titleID));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Object get_aroundBody9$advice(TitleManager this_, Long titleID, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return this_.titlePersistenceService.get(titleID);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Title object = this_.titlePersistenceService.get(titleID);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Object getForUpdate_aroundBody11$advice(TitleManager this_, Long titleID, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return this_.titlePersistenceService.getTitleForUpdate(titleID);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Title object = this_.titlePersistenceService.getTitleForUpdate(titleID);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Object get_aroundBody13$advice(TitleManager this_, Long titleID, String version, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return this_.titlePersistenceService.get(titleID, version);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Title object = this_.titlePersistenceService.get(titleID, version);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Object getWithHistory_aroundBody15$advice(TitleManager this_, Long titleID, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return this_.titlePersistenceService.getWithHistory(titleID);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Title object = this_.titlePersistenceService.getWithHistory(titleID);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Object getIDByAssetID_aroundBody17$advice(TitleManager this_, Long rootAssetID, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return this_.titlePersistenceService.getIdByAssetId(rootAssetID);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Long object = this_.titlePersistenceService.getIdByAssetId(rootAssetID);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Object isActive_aroundBody19$advice(TitleManager this_, Long titleID, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.booleanObject((boolean)this_.titlePersistenceService.isActiveTitle(titleID));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.booleanObject((boolean)this_.titlePersistenceService.isActiveTitle(titleID));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Object isExisting_aroundBody21$advice(TitleManager this_, Long titleID, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.booleanObject((boolean)this_.titlePersistenceService.isExistingTitle(titleID));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.booleanObject((boolean)this_.titlePersistenceService.isExistingTitle(titleID));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void verifyTitleExists_aroundBody22(TitleManager this_, Long titleID) {
        if (!this_.isExisting(titleID)) {
            String msg = "The title[" + titleID + "] does not exist.";
            String errorCode = "TPS-007";
            TitlePersistenceException error = new TitlePersistenceException(errorCode, msg);
            error.getParameters().add(String.valueOf(titleID));
            error.getParameters().add("The title does not exist");
            throw error;
        }
    }

    private static final /* synthetic */ Object verifyTitleExists_aroundBody23$advice(TitleManager this_, Long titleID, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleManager.verifyTitleExists_aroundBody22(this_, titleID);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleManager.verifyTitleExists_aroundBody22(this_, titleID);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Object validate_aroundBody25$advice(TitleManager this_, Title title, boolean draft, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return this_.titleValidator.validate(title, draft);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = this_.titleValidator.validate(title, draft);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ ISavedTitle retire_aroundBody26(TitleManager this_, Long titleID, ITitleActionSource source) {
        Title title = this_.getForUpdate(titleID);
        this_.removePhysicalFiles(title);
        this_.deleteResourcesFromTitle(titleID);
        if (title.getIsActive().booleanValue()) {
            this_.removeAssetFiles(title);
            title.setStatus(TitleStatus.RETIRED);
        }
        Date now = new Date();
        title.setLastModifiedTime(now);
        title.setRetirementDate(now);
        this_.titlePersistenceService.retire(title);
        this_.statusService.sendStatus(title, ProgressStatusHelper.RETIRED, null, true, source.getComponentName(), source.getEntityName(), source.getID());
        return new SaveResult(title, new LinkedList());
    }

    private static final /* synthetic */ Object retire_aroundBody27$advice(TitleManager this_, Long titleID, ITitleActionSource source, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleManager.retire_aroundBody26(this_, titleID, source);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ISavedTitle object = TitleManager.retire_aroundBody26(this_, titleID, source);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Map getProperties_aroundBody28(TitleManager this_, Long titleID) {
        if (titleID == null) {
            throw new IllegalArgumentException("titleID can't be null");
        }
        this_.verifyTitleExists(titleID);
        TitlePropertyManager propertyManager = TitlePropertyManager.getInstance();
        List<TitleProperty> properties = propertyManager.retrieveAll(titleID, null, null);
        HashMap<String, String> result = new HashMap<String, String>();
        for (TitleProperty tp : properties) {
            result.put(tp.getName(), tp.getValue());
        }
        return result;
    }

    private static final /* synthetic */ Object getProperties_aroundBody29$advice(TitleManager this_, Long titleID, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleManager.getProperties_aroundBody28(this_, titleID);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Map object = TitleManager.getProperties_aroundBody28(this_, titleID);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ String getProperty_aroundBody30(TitleManager this_, Long titleID, String name) {
        if (titleID == null) {
            throw new IllegalArgumentException("titleID can't be null");
        }
        this_.verifyTitleExists(titleID);
        TitlePropertyManager propertyManager = TitlePropertyManager.getInstance();
        TitleProperty property = propertyManager.retrieve(name, titleID, null, null);
        if (property != null) {
            return property.getValue();
        }
        return null;
    }

    private static final /* synthetic */ Object getProperty_aroundBody31$advice(TitleManager this_, Long titleID, String name, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleManager.getProperty_aroundBody30(this_, titleID, name);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            String object = TitleManager.getProperty_aroundBody30(this_, titleID, name);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void setProperty_aroundBody32(TitleManager this_, Long titleID, String name, String value) {
        this_.verifyTitleExists(titleID);
        TitleProperty property = this_.createProperty(titleID, name, value);
        if (value == null || value.equals("")) {
            TitlePropertyManager.getInstance().remove(property);
        } else {
            TitlePropertyManager.getInstance().store(property);
        }
    }

    private static final /* synthetic */ Object setProperty_aroundBody33$advice(TitleManager this_, Long titleID, String name, String value, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleManager.setProperty_aroundBody32(this_, titleID, name, value);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleManager.setProperty_aroundBody32(this_, titleID, name, value);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ ISavedTitle associateTitleToSeries_aroundBody34(TitleManager this_, Long titleID, Long seriesDocumentId, Long seasonAssetId, ITitleActionSource source) {
        Title episodeTitle;
        TitleStatus status;
        if (titleID == null) {
            throw new IllegalArgumentException("titleID can't be null");
        }
        Long seriesTitleId = this_.getIDByAssetID(seriesDocumentId);
        if (seriesTitleId == null) {
            throw new IllegalArgumentException("No series title found for given seriesDocumentId");
        }
        Long episodePartnerId = this_.getPartnerId(titleID);
        Long seriesPartnerId = this_.getPartnerId(seriesTitleId);
        if (episodePartnerId != null && seriesPartnerId != null && episodePartnerId.longValue() != seriesPartnerId.longValue()) {
            throw new IllegalArgumentException("You cannot associate to a series title with different partner id");
        }
        if (seasonAssetId != null) {
            Asset seriesRootAsset = this_.getAsset(seriesDocumentId);
            List seasons = seriesRootAsset.getTargetAssets("Season");
            if (seasons.isEmpty()) {
                throw new IllegalArgumentException("Invalid seasonAssetId");
            }
            boolean isValid = false;
            for (Asset a : seasons) {
                Long assetId = a.getId();
                if (assetId.longValue() != seasonAssetId.longValue()) continue;
                isValid = true;
                break;
            }
            if (!isValid) {
                throw new IllegalArgumentException("Invalid seasonAssetId");
            }
        }
        if ((status = (episodeTitle = this_.getForUpdate(titleID)).getStatus()) == TitleStatus.DELETED) {
            throw new IllegalArgumentException("You cannot associate a deleted title to a series title");
        }
        if (episodeTitle.isCopy()) {
            throw new IllegalArgumentException("You cannot associate a site title to a series title");
        }
        ContentClass contentClass = null;
        IContentClassService ccService = this_.getService(IContentClassService.class);
        try {
            contentClass = ccService.getContentClassById(episodeTitle.getContentClassId().longValue());
        }
        catch (ContentClassPersistenceException ex) {
            throw new RuntimeException(ex);
        }
        if (contentClass.getType() == ContentClass.Type.Series) {
            throw new IllegalArgumentException("You cannot associate a series title to another series title.");
        }
        Asset episodeRootAsset = episodeTitle.getAsset();
        ISpecHandler specHandler = SpecHandlerFactory.getInstance((String)"TTV");
        ArrayList<TitleValidationMessage> msgs = new ArrayList<TitleValidationMessage>();
        try {
            specHandler.associateTitleToSeries(episodeRootAsset, seriesDocumentId, seasonAssetId);
        }
        catch (Exception e) {
            TitleValidationMessage msg = TitleValidationMessage.createErrorAssetMessage((String)"Package", (String)"", (String)e.getMessage());
            msgs.add(msg);
        }
        return new SaveResult(episodeTitle, msgs);
    }

    private static final /* synthetic */ Object associateTitleToSeries_aroundBody35$advice(TitleManager this_, Long titleID, Long seriesDocumentId, Long seasonAssetId, ITitleActionSource source, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleManager.associateTitleToSeries_aroundBody34(this_, titleID, seriesDocumentId, seasonAssetId, source);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ISavedTitle object = TitleManager.associateTitleToSeries_aroundBody34(this_, titleID, seriesDocumentId, seasonAssetId, source);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void dissociateTitleFromSeries_aroundBody36(TitleManager this_, Long titleID) {
        if (titleID == null) {
            throw new IllegalArgumentException("titleID can't be null");
        }
        Title episodeTitle = this_.getForUpdate(titleID);
        TitleStatus status = episodeTitle.getStatus();
        if (status == TitleStatus.DELETED) {
            throw new IllegalArgumentException("You cannot dissociate a deleted title");
        }
        Asset episodeRootAsset = episodeTitle.getAsset();
        ISpecHandler specHandler = SpecHandlerFactory.getInstance((String)"TTV");
        ArrayList<TitleValidationMessage> msgs = new ArrayList<TitleValidationMessage>();
        try {
            specHandler.associateTitleToSeries(episodeRootAsset, null, null);
        }
        catch (MetadataException e) {
            TitleValidationMessage msg = TitleValidationMessage.createErrorAssetMessage((String)"Package", (String)"", (String)e.getMessage());
            msgs.add(msg);
            throw new TitleValidationException(msgs);
        }
    }

    private static final /* synthetic */ Object dissociateTitleFromSeries_aroundBody37$advice(TitleManager this_, Long titleID, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleManager.dissociateTitleFromSeries_aroundBody36(this_, titleID);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleManager.dissociateTitleFromSeries_aroundBody36(this_, titleID);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

