/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.copy;

import com.tandbergtv.metadatamanager.AssetCopyException;
import com.tandbergtv.metadatamanager.IAssetCopyService;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.TitleCopyException;

class TitleCopier {
    private final IAssetCopyService assetCopyService;

    TitleCopier(IAssetCopyService assetCopyService) {
        this.assetCopyService = assetCopyService;
    }

    public Title copyTitle(Title title, boolean referenceOriginal) throws TitleCopyException {
        return this.copyTitle(title, null, referenceOriginal);
    }

    public void overwriteTitle(Title title, Title copy) throws TitleCopyException {
        if (copy == null) {
            throw new IllegalArgumentException("The copy title to overwrite cannot be null.");
        }
        this.copyTitle(title, copy, true);
    }

    private Title copyTitle(Title title, Title copy, boolean referenceOriginal) throws TitleCopyException {
        this.validateCopy(title, copy, referenceOriginal);
        if (copy == null) {
            copy = new Title();
            copy.setPartnerId(title.getPartnerId());
            copy.setContentClassId(title.getContentClassId());
        }
        if (referenceOriginal) {
            copy.setOriginalId(title.getId());
            copy.setOriginalVersion(title.getAsset().getVersion());
        }
        copy.setStatus(title.getStatus());
        copy.setExternalLocation(title.getExternalLocation());
        copy.setLastModifiedTime(title.getLastModifiedTime());
        if (copy.getAsset() != null) {
            long copiedAssetId = copy.getAsset().getId();
            try {
                copy.setAsset(this.assetCopyService.overwriteAssetCopy(copiedAssetId));
            }
            catch (AssetCopyException e) {
                String msg = "Failed to overwrite the root asset[" + copiedAssetId + "] when overwriting copied title[" + copy.getId() + "], error: " + e.getLocalizedMessage();
                throw new TitleCopyException(msg, (Throwable)e);
            }
        }
        try {
            copy.setAsset(this.assetCopyService.copyAsset(title.getAsset(), referenceOriginal));
        }
        catch (AssetCopyException e) {
            String msg = "Failed to copy the title root asset when creating title copy, error: " + e.getLocalizedMessage();
            throw new TitleCopyException(msg, (Throwable)e);
        }
        return copy;
    }

    private void validateCopy(Title original, Title copy, boolean referenceOriginal) throws TitleCopyException {
        Long originalId;
        if (!original.getIsActive().booleanValue()) {
            throw new TitleCopyException("Failed to copy title[" + original.getId() + "], cannot copy an inactive title.");
        }
        if (referenceOriginal && original.isCopy()) {
            String msg = "The copied title cannot reference the original title[" + original.getId() + "] since the original title is also a copy.";
            throw new TitleCopyException(msg);
        }
        if (referenceOriginal && original.getId() == null) {
            String msg = "The copied title cannot reference the original title since it does not have a valid identifier.";
            throw new TitleCopyException(msg);
        }
        if (!(copy == null || (originalId = copy.getOriginalId()) != null && originalId.equals(original.getId()))) {
            String msg = "Copied title[" + copy.getId() + "] cannot be overwritten by title[" + original.getId() + "] since it was not originally copied from this title.";
            throw new TitleCopyException(msg);
        }
    }
}

