/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.copy;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.metadatamanager.IAssetCopyService;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleCopyService;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.ITitlePersistenceService;
import com.tandbergtv.watchpoint.pmm.title.TitleCopyException;
import com.tandbergtv.watchpoint.pmm.title.copy.TitleCopier;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.Collection;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.aspectj.runtime.internal.AroundClosure;

public class TitleCopyService
implements ITitleCopyService {
    private static final String SERVICE_NAME = "Title Copy Service";
    private final IAssetCopyService assetCopyService;
    private ITitleManager titleManager;
    private ITitlePersistenceService titlePersistenceService;

    public TitleCopyService(IAssetCopyService assetCopyService) {
        this.assetCopyService = assetCopyService;
    }

    @Transactional
    public Title createTitleCopy(long titleId, boolean referenceOriginal) throws TitleCopyException {
        long l = titleId;
        boolean bl = referenceOriginal;
        return (Title)TitleCopyService.createTitleCopy_aroundBody1$advice(this, l, bl, TransactionEnforcer.aspectOf(), TitleCopyService.class.getDeclaredMethod("createTitleCopy", Long.TYPE, Boolean.TYPE).getAnnotation(Transactional.class), null);
    }

    public Title createTitleCopy(Title title, boolean referenceOriginal) throws TitleCopyException {
        TitleCopier copier = new TitleCopier(this.assetCopyService);
        return copier.copyTitle(title, referenceOriginal);
    }

    @Transactional
    public Title overwriteTitleCopy(long titleCopyId) throws TitleCopyException {
        long l = titleCopyId;
        return (Title)TitleCopyService.overwriteTitleCopy_aroundBody3$advice(this, l, TransactionEnforcer.aspectOf(), TitleCopyService.class.getDeclaredMethod("overwriteTitleCopy", Long.TYPE).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public Collection<Title> getTitleCopies(long titleId) {
        long l = titleId;
        return (Collection)TitleCopyService.getTitleCopies_aroundBody5$advice(this, l, TransactionEnforcer.aspectOf(), TitleCopyService.class.getDeclaredMethod("getTitleCopies", Long.TYPE).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public Collection<Long> getTitleCopyIds(long titleId) {
        long l = titleId;
        return (Collection)TitleCopyService.getTitleCopyIds_aroundBody7$advice(this, l, TransactionEnforcer.aspectOf(), TitleCopyService.class.getDeclaredMethod("getTitleCopyIds", Long.TYPE).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public Title getOriginalTitle(long titleCopyId) {
        long l = titleCopyId;
        return (Title)TitleCopyService.getOriginalTitle_aroundBody9$advice(this, l, TransactionEnforcer.aspectOf(), TitleCopyService.class.getDeclaredMethod("getOriginalTitle", Long.TYPE).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public Long getOriginalTitleId(long titleCopyId) {
        long l = titleCopyId;
        return (Long)TitleCopyService.getOriginalTitleId_aroundBody11$advice(this, l, TransactionEnforcer.aspectOf(), TitleCopyService.class.getDeclaredMethod("getOriginalTitleId", Long.TYPE).getAnnotation(Transactional.class), null);
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void start() {
        this.titleManager = this.getService(ITitleManager.class);
        this.titlePersistenceService = this.getService(ITitlePersistenceService.class);
    }

    public void stop() {
    }

    private <T extends Service> T getService(Class<T> serviceClass) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        return (T)((Service)registry.lookup(serviceClass));
    }

    private static final /* synthetic */ Title createTitleCopy_aroundBody0(TitleCopyService this_, long titleId, boolean referenceOriginal) {
        Title title = this_.titleManager.get(Long.valueOf(titleId));
        return this_.createTitleCopy(title, referenceOriginal);
    }

    private static final /* synthetic */ Object createTitleCopy_aroundBody1$advice(TitleCopyService this_, long titleId, boolean referenceOriginal, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleCopyService.createTitleCopy_aroundBody0(this_, titleId, referenceOriginal);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Title object = TitleCopyService.createTitleCopy_aroundBody0(this_, titleId, referenceOriginal);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Title overwriteTitleCopy_aroundBody2(TitleCopyService this_, long titleCopyId) {
        Title copy = this_.titleManager.get(Long.valueOf(titleCopyId));
        if (!copy.isCopy()) {
            String msg = "Title[" + titleCopyId + "] is not a copy and cannot be overwritten.";
            throw new TitleCopyException(msg);
        }
        Title original = this_.titleManager.get(copy.getOriginalId());
        TitleCopier copier = new TitleCopier(this_.assetCopyService);
        copier.overwriteTitle(original, copy);
        return copy;
    }

    private static final /* synthetic */ Object overwriteTitleCopy_aroundBody3$advice(TitleCopyService this_, long titleCopyId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleCopyService.overwriteTitleCopy_aroundBody2(this_, titleCopyId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Title object = TitleCopyService.overwriteTitleCopy_aroundBody2(this_, titleCopyId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Collection getTitleCopies_aroundBody4(TitleCopyService this_, long titleId) {
        ArrayList<Title> copyTitles = new ArrayList<Title>();
        Collection<Long> copyIDs = this_.getTitleCopyIds(titleId);
        if (copyIDs != null) {
            for (Long copyTitleID : copyIDs) {
                copyTitles.add(this_.titleManager.get(copyTitleID));
            }
        }
        return copyTitles;
    }

    private static final /* synthetic */ Object getTitleCopies_aroundBody5$advice(TitleCopyService this_, long titleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleCopyService.getTitleCopies_aroundBody4(this_, titleId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Collection object = TitleCopyService.getTitleCopies_aroundBody4(this_, titleId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Object getTitleCopyIds_aroundBody7$advice(TitleCopyService this_, long titleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return this_.titlePersistenceService.getCopyIds(Long.valueOf(titleId));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Collection object = this_.titlePersistenceService.getCopyIds(Long.valueOf(titleId));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Title getOriginalTitle_aroundBody8(TitleCopyService this_, long titleCopyId) {
        Long originalID = this_.getOriginalTitleId(titleCopyId);
        return originalID != null ? this_.titleManager.get(originalID) : null;
    }

    private static final /* synthetic */ Object getOriginalTitle_aroundBody9$advice(TitleCopyService this_, long titleCopyId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleCopyService.getOriginalTitle_aroundBody8(this_, titleCopyId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Title object = TitleCopyService.getOriginalTitle_aroundBody8(this_, titleCopyId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Object getOriginalTitleId_aroundBody11$advice(TitleCopyService this_, long titleCopyId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return this_.titlePersistenceService.getOriginalId(Long.valueOf(titleCopyId));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Long object = this_.titlePersistenceService.getOriginalId(Long.valueOf(titleCopyId));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

