/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.search;

import com.ericsson.cms.criteria.SearchColumn;
import com.tandbergtv.cms.title.search.IAssetInfoProvider;
import com.tandbergtv.cms.title.search.entities.AssetSearchInfo;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.SQLQuery;
import org.hibernate.SessionFactory;
import org.hibernate.type.LongType;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.springframework.transaction.annotation.Transactional;

public class AssetInfoProvider
implements IAssetInfoProvider {
    private static final String ASSET_TYPE = "assetType";
    private static final String PARENT = "parent";
    private static final String ASSET_ID = "assetId";
    private static final String ASSET_MAP_ID = "assetMapId";
    private static final String TITLE_ID = "titleId";
    private static final String PARTNER_ID = "partnerId";
    private static final Logger logger = Logger.getLogger(AssetInfoProvider.class);

    private SessionFactory getSessionFactory() {
        try {
            return HibernateContext.getContext().getSessionFactory();
        }
        catch (Exception e) {
            logger.error((Object)"Could not get SessionFactory", (Throwable)e);
            throw new IllegalStateException("Could not get SessionFactory");
        }
    }

    @Transactional
    public List<AssetSearchInfo> getAssetInfo(long titleId, List<SearchColumn> searchColumns) {
        String queryStr = this.buildQuery(titleId, searchColumns, SearchIdentifier.TITLE_ID);
        logger.debug((Object)queryStr);
        SQLQuery sqlQuery = this.buildSqlQuery(queryStr, searchColumns, SearchIdentifier.TITLE_ID);
        return this.getTitleSearchResults(sqlQuery, SearchIdentifier.TITLE_ID);
    }

    @Transactional
    public List<AssetSearchInfo> getTitleAssetInfo(Long assetListId, List<SearchColumn> searchColumns) {
        String queryStr = this.buildQuery(assetListId, searchColumns, SearchIdentifier.ASSET_LIST_ID);
        logger.debug((Object)queryStr);
        SQLQuery sqlQuery = this.buildSqlQuery(queryStr, searchColumns, SearchIdentifier.ASSET_LIST_ID);
        return this.getTitleSearchResults(sqlQuery, SearchIdentifier.ASSET_LIST_ID);
    }

    private SQLQuery buildSqlQuery(String queryStr, List<SearchColumn> searchColumns, SearchIdentifier searchIdentifier) {
        SQLQuery query = this.getSessionFactory().getCurrentSession().createSQLQuery(queryStr);
        query = query.addScalar(TITLE_ID, (Type)new LongType());
        query = query.addScalar(PARTNER_ID, (Type)new LongType());
        query = query.addScalar(ASSET_ID, (Type)new LongType());
        if (searchIdentifier.equals((Object)SearchIdentifier.ASSET_LIST_ID)) {
            query = query.addScalar(ASSET_MAP_ID, (Type)new LongType());
        }
        query = query.addScalar(PARENT, (Type)new LongType());
        query = query.addScalar(ASSET_TYPE, (Type)new StringType());
        for (int i = 0; i < searchColumns.size(); ++i) {
            SearchColumn sc = searchColumns.get(i);
            if (sc.getFieldName().equals("id") || sc.getFieldName().equals("type")) continue;
            query = query.addScalar("sc" + i + "path", (Type)new StringType());
            query = query.addScalar("sc" + i, (Type)new StringType());
        }
        return query;
    }

    private List<AssetSearchInfo> getTitleSearchResults(SQLQuery query, SearchIdentifier searchIdentifier) {
        List queryResults = query.list();
        ArrayList<AssetSearchInfo> results = new ArrayList<AssetSearchInfo>();
        for (Object[] o : queryResults) {
            int i = 0;
            Long titleId = (Long)o[i++];
            Long titlePartnerId = (Long)o[i++];
            Long assetId = (Long)o[i++];
            Long assetMapId = -1L;
            if (searchIdentifier.equals((Object)SearchIdentifier.ASSET_LIST_ID)) {
                assetMapId = (Long)o[i++];
            }
            Long parent = (Long)o[i++];
            String assetType = (String)o[i++];
            HashMap<String, String> metaDataFields = new HashMap<String, String>();
            while (i < o.length - 1) {
                String path = (String)o[i++];
                String value = (String)o[i++];
                metaDataFields.put(path, value);
            }
            if (parent == null) {
                parent = 0L;
            }
            results.add(new AssetSearchInfo(titleId.longValue(), titlePartnerId, assetId.longValue(), assetMapId.longValue(), assetType, parent.longValue(), metaDataFields));
        }
        return results;
    }

    private String buildQuery(long id, List<SearchColumn> searchColumns, SearchIdentifier idType) {
        StringBuffer columns = new StringBuffer();
        StringBuffer query = new StringBuffer();
        StringBuffer insert = new StringBuffer();
        insert.append("SELECT ");
        insert.append("titleId, ");
        insert.append("partnerId, ");
        insert.append("assetId, ");
        if (idType.equals((Object)SearchIdentifier.ASSET_LIST_ID)) {
            insert.append("assetMapId, ");
        }
        insert.append("parent, ");
        insert.append(ASSET_TYPE);
        query.append("SELECT T.ID_       AS titleId, t.partner_id     as partnerId, ");
        query.append("xmlquery('for $i in //*[@assetId] ");
        if (idType.equals((Object)SearchIdentifier.ASSET_LIST_ID)) {
            query.append(", $j in (#ora:xq_qry#)   (: Optimize this subexpression :) {fn:collection(\"oradb:/WFS/CMS_ASSETLIST_ASSET_MAP\")} \r\n");
        }
        query.append("where string(fn:node-name($i)) != \"File\"\r\n");
        if (idType.equals((Object)SearchIdentifier.ASSET_LIST_ID)) {
            query.append(" and $j/ROW/ASSET_ID=$i/@assetId\r\n");
            query.append(" and $j/ROW/ASSETLIST_ID=");
            query.append(id);
            query.append("\r\n");
        }
        query.append("return <Asset assetId=\"{$i/@assetId}\" ");
        if (idType.equals((Object)SearchIdentifier.ASSET_LIST_ID)) {
            query.append("assetMapId=\"{$j/ROW/ID}\" ");
        }
        query.append("parent=\"{$i/../@assetId}\" ");
        if (idType.equals((Object)SearchIdentifier.ASSET_LIST_ID)) {
            query.append(" order=\"{$j/ROW/ORDER_}\" ");
        }
        query.append(">");
        query.append("<assetType>{node-name($i)}</assetType>");
        for (int i = 0; i < searchColumns.size(); ++i) {
            String field = searchColumns.get(i).getFieldName();
            if (field.equals("type")) continue;
            String col = "sc" + i;
            query.append("<");
            query.append(col);
            query.append(" path=\"");
            query.append(field);
            query.append("\">{$i");
            query.append(field);
            query.append("}</");
            query.append(col);
            query.append(">");
            columns.append(", " + col + "path" + " varchar2(2000) path '" + col + "/@" + "path" + "'");
            insert.append(", " + col + "path");
            columns.append(", " + col + " varchar2(2000) path '" + col + "'");
            insert.append(", " + col);
        }
        query.append("</Asset>'\r\n");
        query.append("passing sys_nc_rowinfo$ RETURNING CONTENT) as assetInfo \r\n");
        query.append("FROM PMM_TITLE T \r\n");
        query.append("JOIN mdm_metadata mdm \r\n");
        query.append("ON ( t.mdmdocid   = extractvalue(sys_nc_rowinfo$, '/ECMFSpec/@documentId')) \r\n");
        query.append("join  pmm_titlestatus titlestatus  \r\n");
        query.append("on( titlestatus.id_ = t.titlestatusid) \r\n");
        query.append("where t.id_ ");
        if (idType.equals((Object)SearchIdentifier.TITLE_ID)) {
            query.append(" = ");
            query.append(id);
        } else {
            query.append("in(select title_id from cms_assetlist_asset_map where assetlist_id = ");
            query.append(id);
            query.append(")");
        }
        query.append(" and titlestatusid <> 5  and (t.originaltitle_id is null)");
        query.append(") rv, xmltable('for $i in /Asset return $i' passing rv.assetinfo columns ");
        query.append("assetId NUMBER path '@assetId', ");
        if (idType.equals((Object)SearchIdentifier.ASSET_LIST_ID)) {
            query.append("assetMapId NUMBER path '@assetMapId', ");
        }
        query.append("parent number path '@parent', ");
        query.append("assetType varchar2(500) path 'assetType' ");
        query.append(columns);
        if (idType.equals((Object)SearchIdentifier.ASSET_LIST_ID)) {
            query.append(", order_ number path '@order'");
            query.append(") xtab order by order_ ");
        } else {
            query.append(") xtab");
        }
        insert.append(" from (");
        query.insert(0, insert);
        return query.toString();
    }

    public String getServiceName() {
        return "Asset Info Provider";
    }

    public void start() {
    }

    public void stop() {
    }

    private static enum SearchIdentifier {
        TITLE_ID,
        ASSET_LIST_ID;

    }
}

