/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.search;

import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.SearchColumn;
import com.tandbergtv.cms.title.search.BulkSearchRecordHandler;
import com.tandbergtv.cms.title.search.entities.TitleSearchResult;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class ExportHelper
implements BulkSearchRecordHandler {
    private static final char DELIMITER = ',';
    private static final char QUICK_INFO_DELIMITER = ';';
    private static final char QUICK_INFO_FIELD_VALUE_DELIMITER = ':';
    public static final String QUICK_INFO_COL_NAME = "Quick Info";
    private Charset charSet;
    private OutputStream outStream;
    private int qInfoEndIndex;
    private int qInfoStartIndex;
    private int idPos;
    private List<ColumnInfo> searchColumns;

    public ExportHelper(OutputStream outStream, Charset charSet, List<ColumnInfo> searchColumns) {
        this.outStream = outStream;
        this.charSet = charSet;
        this.idPos = this.getIdPos(searchColumns);
        this.qInfoStartIndex = -1;
        this.qInfoEndIndex = -1;
        int qInfoTemp = -1;
        for (int i = 0; i < searchColumns.size(); ++i) {
            if (searchColumns.get(i).isQuickInfoField()) {
                qInfoTemp = i;
                if (this.qInfoStartIndex != -1) continue;
                this.qInfoStartIndex = i;
                continue;
            }
            if (qInfoTemp == -1) continue;
            this.qInfoEndIndex = qInfoTemp;
        }
        if (this.qInfoStartIndex != -1 && this.qInfoEndIndex == -1) {
            this.qInfoEndIndex = qInfoTemp;
        }
        this.searchColumns = searchColumns;
    }

    public void handleRecord(TitleSearchResult.SearchRow searchRow) throws IOException {
        int i;
        StringBuilder sb = new StringBuilder();
        StringBuilder qInfoValue = new StringBuilder();
        if (this.idPos == 0) {
            this.encodeValue(sb, String.valueOf(searchRow.getId()));
            sb.append(',');
        }
        if (this.qInfoStartIndex != -1) {
            for (i = this.qInfoStartIndex; i <= this.qInfoEndIndex; ++i) {
                this.addToQuickInfo(qInfoValue, searchRow.getFields().get(i), i, this.searchColumns);
            }
        }
        for (i = 1; i < searchRow.getFields().size(); ++i) {
            if (i == this.qInfoStartIndex) {
                this.encodeValue(sb, qInfoValue.toString());
                continue;
            }
            if (i > this.qInfoStartIndex && i <= this.qInfoEndIndex) continue;
            if (i > 1) {
                sb.append(',');
            }
            if (this.idPos == i) {
                this.encodeValue(sb, String.valueOf(String.valueOf(searchRow.getId())));
                sb.append(',');
            }
            this.encodeValue(sb, (String)searchRow.getFields().get(i));
        }
        sb.append("\r\n");
        this.outStream.write(sb.toString().getBytes(this.charSet));
    }

    private void addToQuickInfo(StringBuilder qInfoValue, Object value, int position, List<ColumnInfo> searchColumns) {
        if (qInfoValue.length() > 0) {
            qInfoValue.append(';');
        }
        String fieldName = searchColumns.get(position).getDisplayName();
        qInfoValue.append(fieldName + ':');
        if (value == null) {
            return;
        }
        String dt = searchColumns.get(position).getDataType();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        if (dt.equals("date")) {
            qInfoValue.append(sdf.format((Date)value));
        } else if (dt.equals("time") && value.toString().matches("\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}[.]{1}\\d{1} [+]{1}\\d{1}:\\d{2}")) {
            qInfoValue.append(value.toString().substring(11, 19));
        } else {
            qInfoValue.append(value);
        }
    }

    private int getIdPos(List<ColumnInfo> searchColumns) {
        for (int i = 0; i < searchColumns.size(); ++i) {
            SearchColumn sc = searchColumns.get(i);
            if (!sc.getFieldName().equals("id")) continue;
            return i;
        }
        return -1;
    }

    public void encodeValue(StringBuilder sb, String value) {
        boolean wrapWithQuotes = false;
        int startIndex = sb.length();
        for (int i = 0; i < value.length(); ++i) {
            char chr = value.charAt(i);
            if (!(wrapWithQuotes || chr != ',' && chr != '\"')) {
                wrapWithQuotes = true;
                sb.insert(startIndex, '\"');
            }
            if (chr == '\"') {
                sb.append('\"');
            }
            if (chr == '\r' || chr == '\n') {
                sb.append(' ');
                continue;
            }
            sb.append(chr);
        }
        if (wrapWithQuotes) {
            sb.append('\"');
        }
    }

    public void addHeader() throws IOException {
        StringBuilder sb = new StringBuilder();
        boolean includedQuickInfo = false;
        for (ColumnInfo ci : this.searchColumns) {
            String displayColName = ci.getDisplayName();
            if (ci.isQuickInfoField()) {
                if (includedQuickInfo) continue;
                if (sb.length() > 0) {
                    sb.append(',');
                }
                this.encodeValue(sb, QUICK_INFO_COL_NAME);
                includedQuickInfo = true;
                continue;
            }
            if (sb.length() > 0) {
                sb.append(',');
            }
            this.encodeValue(sb, displayColName);
        }
        sb.append("\r\n");
        this.outStream.write(sb.toString().getBytes(this.charSet));
    }

    public static class ColumnInfo
    extends SearchColumn {
        private String displayName;

        public ColumnInfo(String displayName, boolean quickInfoColumn, String fieldName, String sectionType, FieldType fieldType, String dataType, boolean multiValue) {
            super(sectionType, fieldName, fieldType, dataType, multiValue);
            this.setQuickInfoField(quickInfoColumn);
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

