/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.search;

import com.ericsson.cms.criteria.SearchColumn;
import com.ericsson.cms.criteria.info.SortingInfo;
import com.tandbergtv.cms.titlefilter.CriteriaMode;
import com.tandbergtv.metadatamanager.search.builder.QueryConstants;
import com.tandbergtv.metadatamanager.util.DBNameFinder;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.search.QueryHelperBase;
import java.util.List;
import org.apache.log4j.Logger;

public class TitleQuickSearchQueryHelper
extends QueryHelperBase {
    private static final Logger logger = Logger.getLogger(TitleQuickSearchQueryHelper.class);

    public String buildQuickSearch(int numPartner, boolean includePaging, boolean includeCnt, SortingInfo sortInfo, List<SearchColumn> searchColumns, CriteriaMode criteriaMode) {
        StringBuffer query = new StringBuffer();
        StringBuilder fieldsInner = new StringBuilder();
        StringBuilder fieldsOuter = new StringBuilder();
        StringBuilder joins = new StringBuilder();
        StringBuilder orderBy = new StringBuilder();
        this.populateResultFieldJoins(searchColumns, joins, fieldsInner, fieldsOuter, orderBy, sortInfo);
        if (includePaging) {
            query.append(QueryConstants.SELECT);
            query.append(DBNameFinder.getInstance().getColumnName(Title.class, "id"));
            if (fieldsOuter.length() > 0) {
                query.append(", ");
                query.append((CharSequence)fieldsOuter);
            }
            if (includeCnt) {
                query.append(", cnt");
            }
            query.append(" FROM (");
        }
        query.append(QueryConstants.SELECT);
        query.append("T.id_");
        if (fieldsInner.length() > 0) {
            query.append(", ");
            query.append((CharSequence)fieldsInner);
        }
        if (includeCnt) {
            query.append(", count(*) over ( ) as cnt");
        }
        if (includePaging) {
            query.append(this.getRowNumWOrderBy(orderBy.toString()));
        }
        this.buildQsFrom(query, joins, criteriaMode);
        this.buildQsWhere(query, numPartner, criteriaMode);
        if (includePaging) {
            query.append(")\r\n WHERE RNUM BETWEEN ? and ? \r\n");
        } else {
            query.append("\r\n");
            query.append((CharSequence)orderBy);
        }
        String result = query.toString();
        logger.debug((Object)result);
        return result;
    }

    private void buildQsFrom(StringBuffer query, StringBuilder scJoins, CriteriaMode criteriaMode) {
        query.append(" \r\nFROM PMM_TITLE T");
        this.joinOntoMdm(query);
        if (criteriaMode != null) {
            this.joinToContentClass(query);
        }
        query.append((CharSequence)scJoins);
        query.append("\r\n");
    }

    private void buildQsWhere(StringBuffer query, int numPartner, CriteriaMode criteriaMode) {
        query.append("where  contains(OBJECT_VALUE, ?) > 0 ");
        query.append("\r\nAND ");
        query.append("titlestatusid <> 5 ");
        this.addCriteriaMode(criteriaMode, query);
        query.append("\r\nAND ");
        query.append("T.ORIGINALTITLE_ID");
        query.append(QueryConstants.NULL);
        query.append("\r\n");
        if (numPartner > 0) {
            query.append("AND T.Partner_Id in (?");
            for (int i = 1; i < numPartner; ++i) {
                query.append(", ?");
            }
            query.append(") ");
        }
    }
}

