/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.conf;

import com.tandbergtv.watchpoint.pmm.title.conf.CustomField;
import com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CustomFields {
    private List<CustomFieldGroup> groups;
    private Map<String, String> fieldNameToGroupIdMap = new HashMap<String, String>();

    public CustomFields() {
        this(null);
    }

    public CustomFields(List<CustomFieldGroup> groups) {
        if (groups == null) {
            this.groups = Collections.unmodifiableList(new ArrayList());
        } else {
            this.groups = Collections.unmodifiableList(groups);
            for (CustomFieldGroup gr : groups) {
                if (gr.fields == null) continue;
                for (CustomField fld : gr.fields) {
                    this.fieldNameToGroupIdMap.put(fld.name, gr.groupId);
                }
            }
        }
    }

    public List<CustomFieldGroup> getGroups() {
        return this.groups;
    }

    public String getGroupIdByFieldName(String fieldName) {
        return this.fieldNameToGroupIdMap.get(fieldName);
    }
}

