/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass.hibernate;

import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassMetadata;
import com.tandbergtv.content.contentclass.entities.ContentClassPartner;
import com.tandbergtv.content.contentclass.hibernate.ContentClassEntity;
import com.tandbergtv.content.contentclass.hibernate.ContentClassPartnerEntity;
import com.tandbergtv.content.contentclass.jaxb.ContentClassJaxbService;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;

public class ContentClassHibernateFactory {
    private ContentClassHibernateFactory() {
    }

    public static ContentClass createContentClassWithoutMetadata(ContentClassEntity cch) {
        if (cch == null) {
            return null;
        }
        ContentClass cc = new ContentClass();
        cc.setId(cch.id);
        switch (cch.typeId) {
            case 0: {
                cc.setType(ContentClass.Type.Package);
                break;
            }
            case 1: {
                cc.setType(ContentClass.Type.Series);
                break;
            }
            case 2: {
                cc.setType(ContentClass.Type.Category);
                break;
            }
            default: {
                cc.setType(ContentClass.Type.Package);
            }
        }
        cc.setName(cch.name);
        cc.setDescription(cch.description);
        cc.setDefault(cch.isDefault);
        switch (cch.specialUsageId) {
            case 1: {
                cc.setSpecialUsage(ContentClass.SpecialUsage.PreRoll);
                break;
            }
            case 2: {
                cc.setSpecialUsage(ContentClass.SpecialUsage.PostRoll);
                break;
            }
            default: {
                cc.setSpecialUsage(ContentClass.SpecialUsage.None);
            }
        }
        return cc;
    }

    public static ContentClass createContentClass(ContentClassEntity cch) throws ContentClassPersistenceException {
        ContentClass cc = ContentClassHibernateFactory.createContentClassWithoutMetadata(cch);
        ContentClassJaxbService jaxb = new ContentClassJaxbService();
        cc.setMetadata(jaxb.unmarshalContentClassMetadata(cch.metadataXml));
        return cc;
    }

    public static ContentClassMetadata parseMetadata(String xml) throws ContentClassPersistenceException {
        ContentClassJaxbService jaxb = new ContentClassJaxbService();
        return jaxb.unmarshalContentClassMetadata(xml);
    }

    public static ContentClassEntity createContentClassHibernate(ContentClass cc) throws ContentClassPersistenceException {
        if (cc == null) {
            return null;
        }
        ContentClassEntity cch = new ContentClassEntity();
        cch.id = cc.getId();
        cch.typeId = cc.getType().ordinal();
        cch.name = cc.getName();
        cch.description = cc.getDescription();
        cch.isDefault = cc.isDefault();
        cch.specialUsageId = cc.getSpecialUsage().ordinal();
        ContentClassJaxbService jaxb = new ContentClassJaxbService();
        if (cc.getMetadata() != null) {
            cch.metadataXml = jaxb.marshalContentClassMetadata(cc.getMetadata());
        }
        return cch;
    }

    public static ContentClassPartner createContentClassPartner(ContentClassPartnerEntity entity) throws ContentClassPersistenceException {
        ContentClassPartner ccp = new ContentClassPartner();
        ccp.setContentClassId(entity.getContentClassId());
        ccp.setPartnerId(entity.getPartnerId());
        if (entity.getMetadataXml() != null) {
            ContentClassJaxbService jaxb = new ContentClassJaxbService();
            ccp.setMetadata(jaxb.unmarshalContentClassMetadata(entity.getMetadataXml()));
        }
        return ccp;
    }

    public static ContentClassPartnerEntity createContentClassPartnerEntity(ContentClassPartner ccp) throws ContentClassPersistenceException {
        ContentClassPartnerEntity entity = new ContentClassPartnerEntity(ccp.getContentClassId(), ccp.getPartnerId());
        ContentClassJaxbService jaxb = new ContentClassJaxbService();
        if (ccp.getMetadata() != null) {
            entity.setMetadataXml(jaxb.marshalContentClassMetadata(ccp.getMetadata()));
        }
        return entity;
    }
}

