/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass.hibernate;

import com.tandbergtv.content.contentclass.entities.ContentClassAsset;
import com.tandbergtv.content.contentclass.entities.ContentClassField;
import com.tandbergtv.content.contentclass.entities.ContentClassMetadata;
import com.tandbergtv.content.contentclass.entities.ContentClassOption;
import com.tandbergtv.content.contentclass.hibernate.ContentClassHibernateFactory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.jdbc.Work;

public class GetOptionsWork
implements Work {
    private Map<String, Map<String, String>> fieldsMap = new HashMap<String, Map<String, String>>();

    public Map<String, Map<String, String>> getFieldsWithOptions() {
        return this.fieldsMap;
    }

    public void execute(Connection con) throws SQLException {
        Statement st = null;
        ResultSet rs = null;
        try {
            st = con.createStatement();
            rs = st.executeQuery("select data from pmm_content_class");
            while (rs.next()) {
                String xml = rs.getString(1);
                try {
                    if (xml == null) continue;
                    ContentClassMetadata metadata = ContentClassHibernateFactory.parseMetadata(xml);
                    this.processContentClass(metadata);
                }
                catch (Exception ex) {}
            }
        }
        catch (SQLException ex) {
            throw ex;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (Exception ex) {}
        }
    }

    private void processContentClass(ContentClassMetadata metadata) {
        if (metadata == null) {
            return;
        }
        Collection assets = metadata.getAssetList();
        if (assets != null) {
            for (ContentClassAsset asset : assets) {
                Collection fields = asset.getFieldList();
                if (fields == null) continue;
                for (ContentClassField field : fields) {
                    List options = field.getOptions();
                    if (options == null || options.isEmpty()) continue;
                    String xpath = field.getPath();
                    Map<String, String> optionMap = this.fieldsMap.get(xpath);
                    if (optionMap == null) {
                        optionMap = new HashMap<String, String>();
                        this.fieldsMap.put(xpath, optionMap);
                    }
                    for (ContentClassOption option : options) {
                        String value = option.getValue();
                        if (optionMap.containsKey(value)) continue;
                        optionMap.put(value, option.getDisplayName());
                    }
                }
            }
        }
    }
}

