/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.metadata;

import com.ericsson.cms.criteria.ExpList;
import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.metadatamanager.customfield.CustomFieldDeleteCallbackException;
import com.tandbergtv.metadatamanager.customfield.ICustomFieldDeleteCallback;
import com.tandbergtv.metadatamanager.customfield.model.CustomField;
import com.tandbergtv.metadatamanager.customfield.model.CustomFieldGroup;
import com.tandbergtv.neptune.util.InjectionUtil;
import org.apache.log4j.Logger;

public class CustomFieldDeleteCallback
implements ICustomFieldDeleteCallback {
    private static Logger logger = Logger.getLogger(CustomFieldDeleteCallback.class);

    public void beforeCustomFieldDelete(CustomField customField) throws CustomFieldDeleteCallbackException {
        ITitleSearchService searchService = (ITitleSearchService)InjectionUtil.injectInstance((String)"cms/TitleSearchServiceProxy/local", ITitleSearchService.class);
        boolean exists = false;
        String assetPath = customField.getGroup().getAssetPath();
        String field = this.getFieldPath(customField);
        ExpList conditionList = new ExpList("OR");
        conditionList.addItem((ExpNode)new ExpValue(new Predicate(field, assetPath, FieldType.ASSET, LogicalOperator.ISNOTEMPTY, Boolean.valueOf(false))));
        if (assetPath.startsWith("PACKAGE")) {
            String seriesAssetPath = assetPath.replace("PACKAGE", "SERIES");
            conditionList.addItem((ExpNode)new ExpValue(new Predicate(field, seriesAssetPath, FieldType.ASSET, LogicalOperator.ISNOTEMPTY, Boolean.valueOf(false))));
        }
        if (assetPath.equals("PACKAGE/POSTER") || assetPath.equals("PACKAGE/BOXCOVER")) {
            String seasonAssetPath = assetPath.replace("PACKAGE", "SERIES/SEASON");
            conditionList.addItem((ExpNode)new ExpValue(new Predicate(field, seasonAssetPath, FieldType.ASSET, LogicalOperator.ISNOTEMPTY, Boolean.valueOf(false))));
        }
        try {
            exists = searchService.checkExistenceIncludeAllcopies((ExpNode)conditionList);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new CustomFieldDeleteCallbackException(e.getMessage());
        }
        if (exists) {
            throw new CustomFieldDeleteCallbackException("Custom Field '" + customField.getName() + "' for asset '" + assetPath + "' cannot be deleted. It is used in a title.");
        }
    }

    public void afterCustomFieldDelete(CustomField customField) throws CustomFieldDeleteCallbackException {
    }

    private String getFieldPath(CustomField customField) {
        String path = "/Fields/CustomFields/CustomField[@name=" + customField.getName() + "]/@value";
        return path;
    }

    public void afterCustomFieldGroupDelete(CustomFieldGroup customFieldGroup) throws CustomFieldDeleteCallbackException {
    }
}

