/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.partner;

import com.tandbergtv.watchpoint.pmm.core.PMMActivator;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerUserManager;
import com.tandbergtv.watchpoint.pmm.partner.PartnerManager;
import com.tandbergtv.watchpoint.pmm.partner.PartnerUserManager;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class PartnerActivator {
    private static final Logger logger = Logger.getLogger(PMMActivator.class);
    private static final String SERVICE_GROUP_NAME = "PartnerServices";

    public void start() {
        Context context = this.initializeContext();
        this.addService((Service)new PartnerUserManager(), context);
        this.addService((Service)new PartnerManager(), context);
        logger.info((Object)"Partner Services started");
    }

    public void stop() {
        Context context = this.getContext();
        this.removeService(IPartnerManagement.class, context);
        this.removeService(IPartnerUserManager.class, context);
        this.destroyContext(context);
        logger.debug((Object)"PMM services stopped");
    }

    private Context initializeContext() {
        Context context = null;
        try {
            context = this.getContext();
            context.createSubcontext(SERVICE_GROUP_NAME);
        }
        catch (Exception e) {
            throw new RuntimeException("Failure building JNDI subcontext[PartnerServices].", e);
        }
        return context;
    }

    private void destroyContext(Context context) {
        try {
            NamingEnumeration<Binding> enumeration = context.listBindings(SERVICE_GROUP_NAME);
            while (enumeration.hasMore()) {
                Binding binding = enumeration.next();
                context.unbind(binding.getNameInNamespace());
            }
            context.destroySubcontext(SERVICE_GROUP_NAME);
        }
        catch (Exception e) {
            logger.error((Object)"Failure destroying JNDI subcontext[PartnerServices].", (Throwable)e);
        }
    }

    private Context getContext() {
        InitialContext context = null;
        try {
            context = new InitialContext();
        }
        catch (NamingException e) {
            logger.error((Object)"Failure getting JNDI context.", (Throwable)e);
        }
        return context;
    }

    private void registerService(Service service, Context context) {
        String name = this.getServiceNameForJNDI(service);
        try {
            context.bind(name, (Object)service);
        }
        catch (Exception e) {
            throw new RuntimeException("Failure registering service[" + name + "] via JNDI.", e);
        }
        ServiceRegistry.getDefault().register(service.getServiceName(), service);
    }

    private void unregisterService(Service service, Context context) {
        ServiceRegistry.getDefault().unregister(service);
        String name = this.getServiceNameForJNDI(service);
        try {
            context.unbind(name);
        }
        catch (Exception e) {
            logger.error((Object)("Failure when unregistering service[" + name + "] via JNDI."), (Throwable)e);
        }
    }

    private void addService(Service service, Context context) {
        this.registerService(service, context);
        service.start();
    }

    private void removeService(Class<? extends Service> clazz, Context context) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        Service service = (Service)registry.lookup(clazz);
        if (service != null) {
            service.stop();
            this.unregisterService(service, context);
        }
    }

    private String getServiceNameForJNDI(Service service) {
        return "PartnerServices/" + service.getServiceName();
    }
}

