/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.schedule;

import com.ericsson.cms.scheduler.IScheduler;
import com.ericsson.cms.scheduler.entities.Job;
import com.ericsson.cms.scheduler.entities.ScheduleRule;
import com.ericsson.cms.scheduler.entities.ScheduleRuleParameter;
import com.ericsson.cms.scheduler.entities.ScheduleRuleType;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.assetlist.AssetListPersistenceService;
import com.tandbergtv.watchpoint.pmm.entities.DistributionSchedule;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.PartnerType;
import com.tandbergtv.watchpoint.pmm.entities.ScheduleStatus;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.watchpoint.pmm.schedule.DistScheduleSchedulerCallback;
import com.tandbergtv.watchpoint.pmm.schedule.IDistSchedulePersistenceService;
import com.tandbergtv.watchpoint.pmm.schedule.ValidationErrors;
import com.tandbergtv.watchpoint.pmm.util.validation.ValidationException;
import com.tandbergtv.watchpoint.pmm.util.validation.ValidationMessage;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.aspectj.runtime.internal.AroundClosure;

public class DistSchedulePersistenceService
extends AssetListPersistenceService<DistributionSchedule>
implements IDistSchedulePersistenceService {
    private static final String ENTITY_TYPE = "DistributionSchedule";
    private static final String JOB_NAME_PREFIX = "Job for Distribution Schedule: ";
    private static final String JOB_ASSOCIATION_PREFIX = "Distribution Schedule: ";
    private static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static DateFormat timeFormat = new SimpleDateFormat("h:mm a");

    public DistSchedulePersistenceService() {
        super("DistSchedule Persistence");
    }

    @Override
    @Transactional
    public DistributionSchedule save(DistributionSchedule ds) throws ValidationException {
        DistributionSchedule distributionSchedule = ds;
        return (DistributionSchedule)DistSchedulePersistenceService.save_aroundBody1$advice(this, distributionSchedule, TransactionEnforcer.aspectOf(), DistSchedulePersistenceService.class.getDeclaredMethod("save", DistributionSchedule.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public void changeStatus(long id, ScheduleStatus status) {
        long l = id;
        ScheduleStatus scheduleStatus = status;
        DistSchedulePersistenceService.changeStatus_aroundBody3$advice(this, l, scheduleStatus, TransactionEnforcer.aspectOf(), DistSchedulePersistenceService.class.getDeclaredMethod("changeStatus", Long.TYPE, ScheduleStatus.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public void delete(DistributionSchedule entity) {
        DistributionSchedule distributionSchedule = entity;
        DistSchedulePersistenceService.delete_aroundBody5$advice(this, distributionSchedule, TransactionEnforcer.aspectOf(), DistSchedulePersistenceService.class.getDeclaredMethod("delete", DistributionSchedule.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public void delete(Serializable id) {
        Serializable serializable = id;
        DistSchedulePersistenceService.delete_aroundBody7$advice(this, serializable, TransactionEnforcer.aspectOf(), DistSchedulePersistenceService.class.getDeclaredMethod("delete", Serializable.class).getAnnotation(Transactional.class), null);
    }

    private ScheduleRule getScheduleRule(Date date) {
        ScheduleRule rule = new ScheduleRule();
        rule.setType(ScheduleRuleType.ON_DATE);
        rule.setStartDate(date);
        rule.setEndDate(date);
        ArrayList<ScheduleRuleParameter> scheduleRuleParams = new ArrayList<ScheduleRuleParameter>();
        rule.setParams(scheduleRuleParams);
        ScheduleRuleParameter ruleParamDate = new ScheduleRuleParameter();
        ruleParamDate.setOrder(1);
        ruleParamDate.setValue(dateFormat.format(date));
        scheduleRuleParams.add(ruleParamDate);
        ScheduleRuleParameter ruleParamTime = new ScheduleRuleParameter();
        ruleParamTime.setOrder(2);
        ruleParamTime.setValue(timeFormat.format(date));
        scheduleRuleParams.add(ruleParamTime);
        return rule;
    }

    private boolean isDifferent(ScheduleRule rule, Date date) {
        return !rule.getParam(1).getValue().equals(dateFormat.format(date)) || !rule.getParam(2).getValue().equals(timeFormat.format(date));
    }

    private void deleteJobFor(long id) {
        List jobs = this.getScheduler().getJobsByAssociatedEntity(ENTITY_TYPE, id);
        if (jobs != null && !jobs.isEmpty()) {
            this.getScheduler().delete(((Job)jobs.get(0)).getId().longValue());
        }
    }

    private IScheduler getScheduler() {
        return (IScheduler)InjectionUtil.injectInstance((String)"cms/Scheduler/local", IScheduler.class);
    }

    private static final /* synthetic */ DistributionSchedule save_aroundBody0(DistSchedulePersistenceService this_, DistributionSchedule ds) {
        Partner p;
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        IPartnerManagement partnerManager = (IPartnerManagement)ServiceRegistry.getDefault().lookup(IPartnerManagement.class);
        if (ds.getContextID() == null) {
            messages.add(ValidationErrors.CONTEXTID_REQUIRED.getValidationMessage(new String[0]));
        } else {
            p = partnerManager.getPartnerByContextId(ds.getContextID().longValue());
            if (p == null || p.getType() != PartnerType.DISTRIBUTION) {
                messages.add(ValidationErrors.NODISTPARTNER.getValidationMessage(ds.getContextID().toString()));
            }
        }
        if (ds.getSourcePartnerID() != null) {
            p = null;
            try {
                p = partnerManager.getPartner(ds.getSourcePartnerID().longValue());
            }
            catch (Exception e) {
                // empty catch block
            }
            if (p == null || p.getType() != PartnerType.SOURCE) {
                messages.add(ValidationErrors.NOSRCPARTNER.getValidationMessage(ds.getSourcePartnerID().toString()));
            }
        }
        if (ds.getPitchDate() == null) {
            messages.add(ValidationErrors.PITCHDATE_REQUIRED.getValidationMessage(new String[0]));
        } else if (ds.getPitchDate().before(new Date())) {
            messages.add(ValidationErrors.PITCHDATE_PAST.getValidationMessage(new String[0]));
        }
        if (!messages.isEmpty()) {
            throw new ValidationException(messages);
        }
        boolean create = ds.getId() == null;
        DistributionSchedule savedDS = super.save(ds);
        List jobs = this_.getScheduler().getJobsByAssociatedEntity(ENTITY_TYPE, ds.getId().longValue());
        if (create || jobs == null || jobs.isEmpty()) {
            Job job = new Job();
            job.setRule(this_.getScheduleRule(savedDS.getDate()));
            job.setAssociatedEntityType(ENTITY_TYPE);
            HashSet<Long> entities = new HashSet<Long>();
            entities.add(savedDS.getId());
            job.setAssociatedEntities(entities);
            job.setName(JOB_NAME_PREFIX + savedDS.getId());
            job.setAssociationDescription(JOB_ASSOCIATION_PREFIX + savedDS.getId());
            job.setCallbackClass(DistScheduleSchedulerCallback.class);
            this_.getScheduler().schedule(job);
        } else {
            Job job = (Job)jobs.get(0);
            this_.getSession().evict((Object)job);
            if (this_.isDifferent(job.getRule(), savedDS.getDate())) {
                job.setRule(this_.getScheduleRule(savedDS.getDate()));
                this_.getScheduler().schedule(job);
            }
        }
        return savedDS;
    }

    private static final /* synthetic */ Object save_aroundBody1$advice(DistSchedulePersistenceService this_, DistributionSchedule ds, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return DistSchedulePersistenceService.save_aroundBody0(this_, ds);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            DistributionSchedule object = DistSchedulePersistenceService.save_aroundBody0(this_, ds);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void changeStatus_aroundBody2(DistSchedulePersistenceService this_, long id, ScheduleStatus status) {
        if (status == null) {
            throw new RuntimeException("Cannot set the status to null");
        }
        DistributionSchedule ds = (DistributionSchedule)this_.get(Long.valueOf(id));
        if (ds == null) {
            throw new RuntimeException("No distribution schedule exists for id: " + id);
        }
        ds.setStatus(status);
        super.save(ds);
    }

    private static final /* synthetic */ Object changeStatus_aroundBody3$advice(DistSchedulePersistenceService this_, long id, ScheduleStatus status, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            DistSchedulePersistenceService.changeStatus_aroundBody2(this_, id, status);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            DistSchedulePersistenceService.changeStatus_aroundBody2(this_, id, status);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void delete_aroundBody4(DistSchedulePersistenceService this_, DistributionSchedule entity) {
        this_.deleteJobFor(entity.getId());
        super.delete(entity);
    }

    private static final /* synthetic */ Object delete_aroundBody5$advice(DistSchedulePersistenceService this_, DistributionSchedule entity, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            DistSchedulePersistenceService.delete_aroundBody4(this_, entity);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            DistSchedulePersistenceService.delete_aroundBody4(this_, entity);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void delete_aroundBody6(DistSchedulePersistenceService this_, Serializable id) {
        this_.deleteJobFor((Long)id);
        super.delete(id);
    }

    private static final /* synthetic */ Object delete_aroundBody7$advice(DistSchedulePersistenceService this_, Serializable id, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            DistSchedulePersistenceService.delete_aroundBody6(this_, id);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            DistSchedulePersistenceService.delete_aroundBody6(this_, id);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

