/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.schedule;

import com.ericsson.cms.scheduler.IRecoveryService;
import com.ericsson.cms.scheduler.ISchedulerCallback;
import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.ISitePartnerManager;
import com.ericsson.cms.sites.core.entities.Site;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.entities.DistributionSchedule;
import com.tandbergtv.watchpoint.pmm.entities.ScheduleStatus;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.schedule.IDistSchedulePersistenceService;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;

public class DistScheduleSchedulerCallback
implements ISchedulerCallback {
    private static final Logger logger = Logger.getLogger(DistScheduleSchedulerCallback.class);
    private static final String PROCESSED_TITLE_IDS = "ProcessedTitleIds";

    public void performAction(long jobId, String associatedEntityType, Set<Long> associatedEntityIds, String filterName, Date filterValue, Date execDate, IRecoveryService rs) {
        logger.debug((Object)("performAction() called with jobId : " + jobId + ", associatedEntityType : " + associatedEntityType + ", associatedEntityIds : " + associatedEntityIds + ", filterName : " + filterName + ", filterValue : " + filterValue + ", execDate : " + execDate));
        Long scheduleId = associatedEntityIds.iterator().next();
        IDistSchedulePersistenceService service = (IDistSchedulePersistenceService)ServiceRegistry.getDefault().lookup(IDistSchedulePersistenceService.class);
        ISiteManager siteManager = this.getSiteManager();
        DistributionSchedule ds = (DistributionSchedule)service.get((Serializable)scheduleId);
        Site site = this.getSitePartnerManager().getSiteByContextId(ds.getContextID().longValue());
        if (ds.getStatus() != ScheduleStatus.APPROVED) {
            logger.error((Object)("Status of distribution schedule: " + scheduleId + " of site: [" + site + "]" + " is " + ds.getStatus() + ". Cannot pitch. Status must be " + ScheduleStatus.APPROVED));
            this.markDone(rs);
            return;
        }
        ArrayList<Integer> siteIds = new ArrayList<Integer>(1);
        siteIds.add(site.getId());
        Collection<Title> pendingTitles = ds.getTitles();
        if (rs.isRecovering()) {
            pendingTitles = this.getPendingTitles(ds.getTitles(), rs);
        }
        for (Title t : pendingTitles) {
            try {
                siteManager.target(t.getId().longValue(), siteIds);
                this.persistProcessedTitleId(t.getId(), rs);
            }
            catch (Exception e) {
                logger.error((Object)("Exception while targeting title: " + t.getId() + " to site: " + site.getId() + " while pitching schedule: " + scheduleId + " | Proceeding to the next title."), (Throwable)e);
            }
        }
        logger.info((Object)("Finished pitching schedule: " + scheduleId + " to site: " + site.getId()));
        this.markDone(rs);
    }

    private Collection<Title> getPendingTitles(Collection<Title> titles, IRecoveryService rs) {
        Set processedTitleIds = null;
        TransactionManager transactionManager = null;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            transactionManager.begin();
            processedTitleIds = (HashSet)rs.get(PROCESSED_TITLE_IDS);
            transactionManager.commit();
        }
        catch (Throwable t) {
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                logger.error((Object)"Could not rollback transaction: ", (Throwable)e1);
                return titles;
            }
        }
        if (processedTitleIds == null || processedTitleIds.isEmpty()) {
            return titles;
        }
        ArrayList<Title> pendingTitles = new ArrayList<Title>();
        for (Title t : titles) {
            if (processedTitleIds.contains(t.getId())) continue;
            pendingTitles.add(t);
        }
        return pendingTitles;
    }

    private void persistProcessedTitleId(Long titleId, IRecoveryService rs) {
        TransactionManager transactionManager = null;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            transactionManager.begin();
            HashSet<Long> processedTitleIds = (HashSet<Long>)rs.get(PROCESSED_TITLE_IDS);
            if (processedTitleIds == null) {
                processedTitleIds = new HashSet<Long>();
            }
            processedTitleIds.add(titleId);
            rs.save(PROCESSED_TITLE_IDS, (Serializable)processedTitleIds);
            transactionManager.commit();
        }
        catch (Throwable t) {
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                logger.error((Object)"Could not rollback transaction: ", (Throwable)e1);
            }
        }
    }

    private void markDone(IRecoveryService rs) {
        TransactionManager transactionManager = null;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            transactionManager.begin();
            rs.deleteAll();
            rs.markDone();
            transactionManager.commit();
        }
        catch (Throwable t) {
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                logger.error((Object)"Could not rollback transaction: ", (Throwable)e1);
            }
        }
    }

    private ISiteManager getSiteManager() {
        return (ISiteManager)InjectionUtil.injectInstance((String)"cms/SiteManager/local", ISiteManager.class);
    }

    private ISitePartnerManager getSitePartnerManager() {
        return (ISitePartnerManager)InjectionUtil.injectInstance((String)"cms/SitePartnerManager/local", ISitePartnerManager.class);
    }
}

