/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.watchpoint.pmm.entities.TitleAssetProperty;
import com.tandbergtv.watchpoint.pmm.entities.TitleAssetResource;
import com.tandbergtv.watchpoint.pmm.entities.TitleResource;
import com.tandbergtv.watchpoint.pmm.title.ITitleAssetResourceManager;
import com.tandbergtv.watchpoint.pmm.title.ITitleResourceManager;
import com.tandbergtv.watchpoint.pmm.title.TitleAssetPropertyManager;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.aspectj.runtime.internal.AroundClosure;

public class TitleAssetResourceManager
implements ITitleAssetResourceManager {
    private final String KEY_FRAMES = "KEY_FRAMES";
    private final String STILL_IMAGE = "STILL_IMAGE";
    private final String THUMBNAIL = "THUMBNAIL";

    private TitleAssetPropertyManager getService() {
        return (TitleAssetPropertyManager)ServiceRegistry.getDefault().lookup(TitleAssetPropertyManager.class);
    }

    private ITitleResourceManager getTitleResourceManager() {
        return (ITitleResourceManager)ServiceRegistry.getDefault().lookup(ITitleResourceManager.class);
    }

    private TitleAssetResource propertyToResource(TitleAssetProperty property) {
        if (property == null) {
            return null;
        }
        TitleAssetResource resource = new TitleAssetResource();
        resource.setResourcePath(property.getValue());
        resource.setAssetId(property.getAssetId().longValue());
        resource.setTitleId(property.getTitleId().longValue());
        if ("THUMBNAIL".equals(property.getName())) {
            resource.setResourceType(TitleAssetResource.ResourceType.THUMBNAIL);
        } else if ("STILL_IMAGE".equals(property.getName())) {
            resource.setResourceType(TitleAssetResource.ResourceType.STILL_IMAGE);
        } else if ("KEY_FRAMES".equals(property.getName())) {
            resource.setResourceType(TitleAssetResource.ResourceType.KEY_FRAMES);
        }
        resource.setCreateDate(property.getUpdateDate());
        return resource;
    }

    private List<TitleAssetResource> propertyListToResourceList(List<TitleAssetProperty> propertyList) {
        ArrayList<TitleAssetResource> resourceList = new ArrayList<TitleAssetResource>();
        for (TitleAssetProperty property : propertyList) {
            TitleAssetResource resource = this.propertyToResource(property);
            resourceList.add(resource);
        }
        return resourceList;
    }

    @Transactional
    public TitleAssetResource getKeyFrames(long titleId, long assetId) {
        long l = titleId;
        long l2 = assetId;
        return (TitleAssetResource)TitleAssetResourceManager.getKeyFrames_aroundBody1$advice(this, l, l2, TransactionEnforcer.aspectOf(), TitleAssetResourceManager.class.getDeclaredMethod("getKeyFrames", Long.TYPE, Long.TYPE).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public List<TitleAssetResource> getKeyFrames(long titleId) {
        long l = titleId;
        return (List)TitleAssetResourceManager.getKeyFrames_aroundBody3$advice(this, l, TransactionEnforcer.aspectOf(), TitleAssetResourceManager.class.getDeclaredMethod("getKeyFrames", Long.TYPE).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public List<TitleAssetResource> getStillImages(long titleId, long assetId) {
        long l = titleId;
        long l2 = assetId;
        return (List)TitleAssetResourceManager.getStillImages_aroundBody5$advice(this, l, l2, TransactionEnforcer.aspectOf(), TitleAssetResourceManager.class.getDeclaredMethod("getStillImages", Long.TYPE, Long.TYPE).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public List<TitleAssetResource> getStillImages(long titleId) {
        long l = titleId;
        return (List)TitleAssetResourceManager.getStillImages_aroundBody7$advice(this, l, TransactionEnforcer.aspectOf(), TitleAssetResourceManager.class.getDeclaredMethod("getStillImages", Long.TYPE).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public TitleAssetResource getThumbnail(long titleId, long assetId) {
        long l = titleId;
        long l2 = assetId;
        return (TitleAssetResource)TitleAssetResourceManager.getThumbnail_aroundBody9$advice(this, l, l2, TransactionEnforcer.aspectOf(), TitleAssetResourceManager.class.getDeclaredMethod("getThumbnail", Long.TYPE, Long.TYPE).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public List<TitleAssetResource> getThumbnails(long titleId) {
        long l = titleId;
        return (List)TitleAssetResourceManager.getThumbnails_aroundBody11$advice(this, l, TransactionEnforcer.aspectOf(), TitleAssetResourceManager.class.getDeclaredMethod("getThumbnails", Long.TYPE).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public void registerKeyFrames(long titleId, long assetId, String assetType, String keyFramesPath) {
        long l = titleId;
        long l2 = assetId;
        String string = assetType;
        String string2 = keyFramesPath;
        TitleAssetResourceManager.registerKeyFrames_aroundBody13$advice(this, l, l2, string, string2, TransactionEnforcer.aspectOf(), TitleAssetResourceManager.class.getDeclaredMethod("registerKeyFrames", Long.TYPE, Long.TYPE, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public void registerStillImage(long titleId, long assetId, String assetType, String imagePath) {
        long l = titleId;
        long l2 = assetId;
        String string = assetType;
        String string2 = imagePath;
        TitleAssetResourceManager.registerStillImage_aroundBody15$advice(this, l, l2, string, string2, TransactionEnforcer.aspectOf(), TitleAssetResourceManager.class.getDeclaredMethod("registerStillImage", Long.TYPE, Long.TYPE, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public void registerThumbnail(long titleId, long assetId, String assetType, String thumbnailPath) {
        long l = titleId;
        long l2 = assetId;
        String string = assetType;
        String string2 = thumbnailPath;
        TitleAssetResourceManager.registerThumbnail_aroundBody17$advice(this, l, l2, string, string2, TransactionEnforcer.aspectOf(), TitleAssetResourceManager.class.getDeclaredMethod("registerThumbnail", Long.TYPE, Long.TYPE, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public void unregisterKeyFrames(long titleId, long assetId) {
        long l = titleId;
        long l2 = assetId;
        TitleAssetResourceManager.unregisterKeyFrames_aroundBody19$advice(this, l, l2, TransactionEnforcer.aspectOf(), TitleAssetResourceManager.class.getDeclaredMethod("unregisterKeyFrames", Long.TYPE, Long.TYPE).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public void unregisterResourcesForTitle(long titleId) {
        long l = titleId;
        TitleAssetResourceManager.unregisterResourcesForTitle_aroundBody21$advice(this, l, TransactionEnforcer.aspectOf(), TitleAssetResourceManager.class.getDeclaredMethod("unregisterResourcesForTitle", Long.TYPE).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public void unregisterStillImages(long titleId, long assetId, String imagePath) {
        long l = titleId;
        long l2 = assetId;
        String string = imagePath;
        TitleAssetResourceManager.unregisterStillImages_aroundBody23$advice(this, l, l2, string, TransactionEnforcer.aspectOf(), TitleAssetResourceManager.class.getDeclaredMethod("unregisterStillImages", Long.TYPE, Long.TYPE, String.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public void unregisterStillImages(long titleId, long assetId) {
        long l = titleId;
        long l2 = assetId;
        TitleAssetResourceManager.unregisterStillImages_aroundBody25$advice(this, l, l2, TransactionEnforcer.aspectOf(), TitleAssetResourceManager.class.getDeclaredMethod("unregisterStillImages", Long.TYPE, Long.TYPE).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public void unregisterThumbnail(long titleId, long assetId) {
        long l = titleId;
        long l2 = assetId;
        TitleAssetResourceManager.unregisterThumbnail_aroundBody27$advice(this, l, l2, TransactionEnforcer.aspectOf(), TitleAssetResourceManager.class.getDeclaredMethod("unregisterThumbnail", Long.TYPE, Long.TYPE).getAnnotation(Transactional.class), null);
    }

    public String getServiceName() {
        return "TitleAssetResourceManager";
    }

    public void start() {
    }

    public void stop() {
    }

    private static final /* synthetic */ TitleAssetResource getKeyFrames_aroundBody0(TitleAssetResourceManager this_, long titleId, long assetId) {
        List<TitleAssetProperty> list = this_.getService().getByTitleAsset(titleId, assetId, "KEY_FRAMES");
        if (list == null || list.size() == 0) {
            return null;
        }
        TitleAssetProperty property = list.get(0);
        TitleAssetResource resource = this_.propertyToResource(property);
        return resource;
    }

    private static final /* synthetic */ Object getKeyFrames_aroundBody1$advice(TitleAssetResourceManager this_, long titleId, long assetId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleAssetResourceManager.getKeyFrames_aroundBody0(this_, titleId, assetId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleAssetResource object = TitleAssetResourceManager.getKeyFrames_aroundBody0(this_, titleId, assetId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getKeyFrames_aroundBody2(TitleAssetResourceManager this_, long titleId) {
        List<TitleAssetProperty> propertyList = this_.getService().getByTitleAsset(titleId, "KEY_FRAMES");
        List<TitleAssetResource> resourceList = this_.propertyListToResourceList(propertyList);
        return resourceList;
    }

    private static final /* synthetic */ Object getKeyFrames_aroundBody3$advice(TitleAssetResourceManager this_, long titleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleAssetResourceManager.getKeyFrames_aroundBody2(this_, titleId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = TitleAssetResourceManager.getKeyFrames_aroundBody2(this_, titleId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getStillImages_aroundBody4(TitleAssetResourceManager this_, long titleId, long assetId) {
        List<TitleAssetProperty> propertyList = this_.getService().getByTitleAsset(titleId, assetId, "STILL_IMAGE");
        List<TitleAssetResource> resourceList = this_.propertyListToResourceList(propertyList);
        return resourceList;
    }

    private static final /* synthetic */ Object getStillImages_aroundBody5$advice(TitleAssetResourceManager this_, long titleId, long assetId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleAssetResourceManager.getStillImages_aroundBody4(this_, titleId, assetId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = TitleAssetResourceManager.getStillImages_aroundBody4(this_, titleId, assetId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getStillImages_aroundBody6(TitleAssetResourceManager this_, long titleId) {
        List<TitleAssetProperty> propertyList = this_.getService().getByTitleAsset(titleId, "STILL_IMAGE");
        List<TitleAssetResource> resourceList = this_.propertyListToResourceList(propertyList);
        return resourceList;
    }

    private static final /* synthetic */ Object getStillImages_aroundBody7$advice(TitleAssetResourceManager this_, long titleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleAssetResourceManager.getStillImages_aroundBody6(this_, titleId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = TitleAssetResourceManager.getStillImages_aroundBody6(this_, titleId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ TitleAssetResource getThumbnail_aroundBody8(TitleAssetResourceManager this_, long titleId, long assetId) {
        List<TitleAssetProperty> list = this_.getService().getByTitleAsset(titleId, assetId, "THUMBNAIL");
        if (list == null || list.size() == 0) {
            return null;
        }
        TitleAssetProperty property = list.get(0);
        TitleAssetResource resource = this_.propertyToResource(property);
        return resource;
    }

    private static final /* synthetic */ Object getThumbnail_aroundBody9$advice(TitleAssetResourceManager this_, long titleId, long assetId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleAssetResourceManager.getThumbnail_aroundBody8(this_, titleId, assetId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleAssetResource object = TitleAssetResourceManager.getThumbnail_aroundBody8(this_, titleId, assetId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getThumbnails_aroundBody10(TitleAssetResourceManager this_, long titleId) {
        List<TitleAssetProperty> propertyList = this_.getService().getByTitleAsset(titleId, "THUMBNAIL");
        List<TitleAssetResource> resourceList = this_.propertyListToResourceList(propertyList);
        return resourceList;
    }

    private static final /* synthetic */ Object getThumbnails_aroundBody11$advice(TitleAssetResourceManager this_, long titleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleAssetResourceManager.getThumbnails_aroundBody10(this_, titleId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = TitleAssetResourceManager.getThumbnails_aroundBody10(this_, titleId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void registerKeyFrames_aroundBody12(TitleAssetResourceManager this_, long titleId, long assetId, String assetType, String keyFramesPath) {
        this_.getTitleResourceManager().save(new TitleResource(titleId, keyFramesPath));
        TitleAssetProperty property = null;
        List<TitleAssetProperty> properties = this_.getService().getByTitleAsset(titleId, assetId, "KEY_FRAMES");
        if (properties == null || properties.size() == 0) {
            property = new TitleAssetProperty();
            property.setAssetId(Long.valueOf(assetId));
            property.setName("KEY_FRAMES");
            property.setTitleId(Long.valueOf(titleId));
            if (assetType != null) {
                property.setValue(assetType);
            }
            property.setValue(keyFramesPath);
            property.setUpdateDate(new Date());
        } else {
            property = properties.get(0);
            property.setValue(keyFramesPath);
            property.setUpdateDate(new Date());
        }
        this_.getService().save(property);
    }

    private static final /* synthetic */ Object registerKeyFrames_aroundBody13$advice(TitleAssetResourceManager this_, long titleId, long assetId, String keyFramesPath, String unknown5, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleAssetResourceManager.registerKeyFrames_aroundBody12(this_, titleId, assetId, keyFramesPath, unknown5);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleAssetResourceManager.registerKeyFrames_aroundBody12(this_, titleId, assetId, keyFramesPath, unknown5);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void registerStillImage_aroundBody14(TitleAssetResourceManager this_, long titleId, long assetId, String assetType, String imagePath) {
        TitleAssetProperty property;
        this_.getTitleResourceManager().save(new TitleResource(titleId, imagePath));
        List<TitleAssetProperty> properties = this_.getService().getByTitleAsset(titleId, assetId, "STILL_IMAGE");
        boolean save = true;
        for (TitleAssetProperty property2 : properties) {
            if (imagePath == null || !imagePath.equals(property2.getValue())) continue;
            save = false;
        }
        if (save) {
            property = new TitleAssetProperty();
            property = new TitleAssetProperty();
            property.setAssetId(Long.valueOf(assetId));
            property.setName("STILL_IMAGE");
            property.setTitleId(Long.valueOf(titleId));
            property.setValue(imagePath);
            if (assetType != null) {
                property.setValue(assetType);
            }
        } else {
            throw new RuntimeException("Still Image with titleId: " + titleId + " , assetId: " + assetId + ", and value: " + imagePath + " already registered in the database");
        }
        property.setUpdateDate(new Date());
        this_.getService().save(property);
    }

    private static final /* synthetic */ Object registerStillImage_aroundBody15$advice(TitleAssetResourceManager this_, long titleId, long assetId, String imagePath, String unknown5, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleAssetResourceManager.registerStillImage_aroundBody14(this_, titleId, assetId, imagePath, unknown5);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleAssetResourceManager.registerStillImage_aroundBody14(this_, titleId, assetId, imagePath, unknown5);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void registerThumbnail_aroundBody16(TitleAssetResourceManager this_, long titleId, long assetId, String assetType, String thumbnailPath) {
        this_.getTitleResourceManager().save(new TitleResource(titleId, thumbnailPath));
        TitleAssetProperty property = null;
        List<TitleAssetProperty> properties = this_.getService().getByTitleAsset(titleId, assetId, "THUMBNAIL");
        if (properties == null || properties.size() == 0) {
            property = new TitleAssetProperty();
            property.setAssetId(Long.valueOf(assetId));
            property.setAssetType(assetType);
            property.setName("THUMBNAIL");
            property.setTitleId(Long.valueOf(titleId));
            property.setValue(thumbnailPath);
            property.setUpdateDate(new Date());
            this_.getService().save(property);
        } else {
            property = properties.get(0);
            property.setValue(thumbnailPath);
            property.setUpdateDate(new Date());
        }
        this_.getService().save(property);
    }

    private static final /* synthetic */ Object registerThumbnail_aroundBody17$advice(TitleAssetResourceManager this_, long titleId, long assetId, String thumbnailPath, String unknown5, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleAssetResourceManager.registerThumbnail_aroundBody16(this_, titleId, assetId, thumbnailPath, unknown5);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleAssetResourceManager.registerThumbnail_aroundBody16(this_, titleId, assetId, thumbnailPath, unknown5);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void unregisterKeyFrames_aroundBody18(TitleAssetResourceManager this_, long titleId, long assetId) {
        List<TitleAssetProperty> properties = this_.getService().getByTitleAsset(titleId, assetId);
        for (TitleAssetProperty property : properties) {
            if (!"KEY_FRAMES".equals(property.getName())) continue;
            this_.getService().delete(property.getId());
        }
    }

    private static final /* synthetic */ Object unregisterKeyFrames_aroundBody19$advice(TitleAssetResourceManager this_, long titleId, long assetId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleAssetResourceManager.unregisterKeyFrames_aroundBody18(this_, titleId, assetId);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleAssetResourceManager.unregisterKeyFrames_aroundBody18(this_, titleId, assetId);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void unregisterResourcesForTitle_aroundBody20(TitleAssetResourceManager this_, long titleId) {
        List<TitleAssetProperty> properties = this_.getService().getByTitle(titleId);
        for (TitleAssetProperty property : properties) {
            if ("KEY_FRAMES".equals(property.getName())) {
                this_.getService().delete(property.getId());
                continue;
            }
            if ("THUMBNAIL".equals(property.getName())) {
                this_.getService().delete(property.getId());
                continue;
            }
            if (!"STILL_IMAGE".equals(property.getName())) continue;
            this_.getService().delete(property.getId());
        }
    }

    private static final /* synthetic */ Object unregisterResourcesForTitle_aroundBody21$advice(TitleAssetResourceManager this_, long titleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleAssetResourceManager.unregisterResourcesForTitle_aroundBody20(this_, titleId);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleAssetResourceManager.unregisterResourcesForTitle_aroundBody20(this_, titleId);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void unregisterStillImages_aroundBody22(TitleAssetResourceManager this_, long titleId, long assetId, String imagePath) {
        List<TitleAssetProperty> properties = this_.getService().getByTitleAsset(titleId, assetId);
        for (TitleAssetProperty property : properties) {
            if (!"STILL_IMAGE".equals(property.getName()) || !property.getValue().equals(imagePath)) continue;
            this_.getService().delete(property.getId());
        }
    }

    private static final /* synthetic */ Object unregisterStillImages_aroundBody23$advice(TitleAssetResourceManager this_, long titleId, long assetId, String unknown4, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleAssetResourceManager.unregisterStillImages_aroundBody22(this_, titleId, assetId, unknown4);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleAssetResourceManager.unregisterStillImages_aroundBody22(this_, titleId, assetId, unknown4);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void unregisterStillImages_aroundBody24(TitleAssetResourceManager this_, long titleId, long assetId) {
        List<TitleAssetProperty> properties = this_.getService().getByTitleAsset(titleId, assetId);
        for (TitleAssetProperty property : properties) {
            if (!"STILL_IMAGE".equals(property.getName())) continue;
            this_.getService().delete(property.getId());
        }
    }

    private static final /* synthetic */ Object unregisterStillImages_aroundBody25$advice(TitleAssetResourceManager this_, long titleId, long assetId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleAssetResourceManager.unregisterStillImages_aroundBody24(this_, titleId, assetId);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleAssetResourceManager.unregisterStillImages_aroundBody24(this_, titleId, assetId);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void unregisterThumbnail_aroundBody26(TitleAssetResourceManager this_, long titleId, long assetId) {
        List<TitleAssetProperty> properties = this_.getService().getByTitleAsset(titleId, assetId);
        for (TitleAssetProperty property : properties) {
            if (!"THUMBNAIL".equals(property.getName())) continue;
            this_.getService().delete(property.getId());
        }
    }

    private static final /* synthetic */ Object unregisterThumbnail_aroundBody27$advice(TitleAssetResourceManager this_, long titleId, long assetId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleAssetResourceManager.unregisterThumbnail_aroundBody26(this_, titleId, assetId);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleAssetResourceManager.unregisterThumbnail_aroundBody26(this_, titleId, assetId);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

