/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.activity;

import com.tandbergtv.workflow.core.WFSVariableInstance;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import java.util.Collection;
import java.util.Set;

public class TitleKeysParameter
extends SearchParameterBase {
    private Set<String> variableNames;
    private Set<Long> titleIDs;
    private String alias;

    public TitleKeysParameter() {
        this(null, null);
    }

    public TitleKeysParameter(Set<String> variableNames, Set<Long> titleIDs) {
        super("titleID", SearchType.STRING, true);
        this.setVariableNames(variableNames);
        this.setTitleIDs(titleIDs);
    }

    public Set<String> getVariableNames() {
        return this.variableNames;
    }

    public void setVariableNames(Set<String> variableNames) {
        this.variableNames = variableNames;
    }

    public Set<Long> getTitleIDs() {
        return this.titleIDs;
    }

    public void setTitleIDs(Set<Long> titleIDs) {
        this.titleIDs = titleIDs;
    }

    public String getAlias() {
        return this.alias;
    }

    protected void setParameterAlias(String alias) {
        this.alias = alias;
    }

    public String getPartialFromClause(int count) {
        this.setParameterAlias("wfsvariableinstance" + count);
        String clause = WFSVariableInstance.class.getName() + " " + this.getAlias();
        return clause;
    }

    public String getPartialWhereClause() {
        if (this.getVariableNames() == null || this.getVariableNames().size() == 0) {
            throw new RuntimeException("No variable names provided for matching title key.");
        }
        StringBuilder clause = new StringBuilder();
        clause.append(this.getAlias()).append(".processInstance.id");
        clause.append(" = ").append("process").append(".id");
        clause.append(" and ");
        clause.append(this.getAlias()).append(".tokenVariableMap is not null");
        clause.append(" and ");
        clause.append(this.getAlias()).append(".name ");
        clause.append(this.buildValuesPredicate(this.getVariableNames()));
        clause.append(" and ");
        String[] dataTypeColumns = this.getSupportedDataTypeFields();
        String valuePredicate = this.buildValuesPredicate(this.getTitleIDs());
        clause.append("(");
        boolean appendOr = false;
        for (String dataTypeColumn : dataTypeColumns) {
            if (!appendOr) {
                appendOr = true;
            } else {
                clause.append(" or ");
            }
            clause.append(this.getAlias()).append(".").append(dataTypeColumn);
            clause.append(" ").append(valuePredicate);
        }
        clause.append(")");
        return clause.toString();
    }

    private String[] getSupportedDataTypeFields() {
        return new String[]{"stringVal", "longVal"};
    }

    private String buildValuesPredicate(Collection<?> values) {
        if (values == null || values.size() == 0) {
            return "is not null";
        }
        StringBuilder clause = new StringBuilder();
        clause.append("in (");
        boolean first = true;
        for (Object value : values) {
            if (first) {
                first = false;
            } else {
                clause.append(", ");
            }
            clause.append("'").append(value.toString()).append("'");
        }
        clause.append(")");
        return clause.toString();
    }

    public String getPredicate() {
        return null;
    }
}

