/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.autofill;

import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassAsset;
import com.tandbergtv.content.contentclass.entities.ContentClassField;
import com.tandbergtv.content.contentclass.entities.ContentClassMetadata;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.conf.IAutoFillVariableProvider;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class AutoFillService {
    private Logger logger = Logger.getLogger(AutoFillService.class);
    private UISpecification spec;
    private Title title;
    private ContentClassMetadata contentClassMetadata;

    public AutoFillService(UISpecification spec, ContentClass cc, Title title) {
        this.spec = spec;
        if (cc != null) {
            this.contentClassMetadata = cc.getMetadata();
        }
        this.title = title;
    }

    public void autoFill() {
        if (this.title == null) {
            return;
        }
        Asset rootAsset = this.title.getAsset();
        if (rootAsset == null) {
            return;
        }
        if (this.contentClassMetadata == null) {
            return;
        }
        this.walkAssetTree(rootAsset, null);
    }

    private void walkAssetTree(Asset asset, String parentPath) {
        String path = parentPath == null ? asset.getAssetType() : parentPath + "/" + asset.getAssetType();
        ContentClassAsset ccAsset = this.contentClassMetadata.getAsset(path);
        this.processAsset(asset, ccAsset);
        for (Relation r : asset.getRelations()) {
            this.walkAssetTree(r.getTargetAsset(), path);
        }
    }

    private void processAsset(Asset asset, ContentClassAsset ccAsset) {
        if (ccAsset == null) {
            return;
        }
        Collection ccFields = ccAsset.getFieldList();
        if (ccFields != null && !ccFields.isEmpty()) {
            ArrayList<ContentClassField> autofillableFields = new ArrayList<ContentClassField>();
            for (ContentClassField ccField : ccFields) {
                if (!ccField.isAutofillable() || ccField.getAutofillProvider() == null) continue;
                autofillableFields.add(ccField);
            }
            this.autoFill(asset, autofillableFields);
        }
    }

    private void autoFill(Asset asset, List<ContentClassField> ccFields) {
        if (ccFields == null || ccFields.isEmpty()) {
            return;
        }
        for (ContentClassField ccField : ccFields) {
            String className;
            String value;
            String xpath = ccField.getPath();
            Field field = asset.getFirstField(xpath);
            if (field != null && field.getValue() != null || (value = this.getAutoFillValue(this.spec, className = ccField.getAutofillProvider(), this.title, asset)) == null) continue;
            field = new Field(xpath, value);
            field.setAutoFill(true);
            field.setIndices(this.getIndicesFromXpath(xpath));
            asset.addField(field);
        }
    }

    private ArrayList<Integer> getIndicesFromXpath(String xpath) {
        String[] a = xpath.split("/");
        if (a.length == 0) {
            throw new IllegalArgumentException("Invalid xpath");
        }
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (String s : a) {
            if (s.equals("") || s.startsWith("@")) continue;
            indices.add(new Integer(1));
        }
        return indices;
    }

    private String getAutoFillValue(UISpecification spec, String className, Title title, Asset asset) {
        try {
            ClassLoader classloader = spec.getClassLoader();
            Class<?> providerClass = classloader.loadClass(className);
            Object obj = providerClass.newInstance();
            if (obj instanceof IAutoFillVariableProvider) {
                IAutoFillVariableProvider provider = (IAutoFillVariableProvider)obj;
                return provider.getValue(title, asset);
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)"Unable to generate value", (Throwable)ex);
        }
        return null;
    }
}

