/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.conf;

import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.java.plugin.PluginManager;

public class SpecificationBuilder {
    private static final Logger logger = Logger.getLogger(SpecificationBuilder.class);
    private Map<String, ISpecHandler> spechandlers;

    private SpecificationBuilder(PluginManager pluginManager, Map<String, ISpecHandler> spechandlers) {
        this.spechandlers = spechandlers;
    }

    public static SpecificationBuilder createInstance(PluginManager pluginManager, Map<String, ISpecHandler> spechandlers) {
        return new SpecificationBuilder(pluginManager, spechandlers);
    }

    public Collection<Specification> buildSpecifications() {
        ArrayList<Specification> specifications = new ArrayList<Specification>();
        Collection<ISpecHandler> handlers = this.spechandlers.values();
        for (ISpecHandler handler : handlers) {
            try {
                Specification specification = this.buildSpecification(handler);
                specifications.add(specification);
                logger.debug((Object)("Added support for " + specification.getName()));
            }
            catch (Exception e) {
                logger.error((Object)("Unable to build specification: " + handler.getSpecName()), (Throwable)e);
            }
        }
        this.removeDuplicates(specifications);
        return specifications;
    }

    private Specification buildSpecification(ISpecHandler handler) {
        return new Specification(handler);
    }

    private void removeDuplicates(Collection<Specification> allSpecifications) {
        HashMap<String, ArrayList<Specification>> specificationNameMap = new HashMap<String, ArrayList<Specification>>();
        for (Specification specification : allSpecifications) {
            String name = specification.getName();
            ArrayList<Specification> specifications = (ArrayList<Specification>)specificationNameMap.get(name);
            if (specifications == null) {
                specifications = new ArrayList<Specification>();
                specificationNameMap.put(name, specifications);
            }
            specifications.add(specification);
        }
        for (String name : specificationNameMap.keySet()) {
            List specifications = (List)specificationNameMap.get(name);
            if (specifications.size() <= 1) continue;
            allSpecifications.removeAll(specifications);
            logger.warn((Object)("Detected duplicate specifications(" + specifications.size() + ") with same name: " + name + ", ignoring all specifications with this name."));
        }
    }
}

