/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.conf;

import com.tandbergtv.metadatamanager.search.SearchSchemaHelper;
import com.tandbergtv.metadatamanager.search.XpathNodeCardinality;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import com.tandbergtv.watchpoint.pmm.title.conf.AutofillProvider;
import com.tandbergtv.watchpoint.pmm.title.conf.BooleanVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.ComplexVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.DateVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.FloatVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.IVariableOptionProvider;
import com.tandbergtv.watchpoint.pmm.title.conf.IntegerVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.SimpleVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.SpecificationValidationException;
import com.tandbergtv.watchpoint.pmm.title.conf.StringVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.TimeVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConf;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import com.tandbergtv.watchpoint.pmm.title.conf.Variable;
import com.tandbergtv.watchpoint.pmm.title.conf.VariableOption;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.AutofillProviderListType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.AutofillProviderType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.BooleanVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.ComplexVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.DateVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.FloatVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.IntegerVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.OptionsType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.SimpleVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.Specification;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.StringVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.TimeVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.TitleType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.VariableType;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class SpecificationReader {
    private SearchSchemaHelper ecmfHelper = new SearchSchemaHelper();
    private static final String NAMESPACE_PREFIX = "";
    private static final String PATH_SEPARATOR = "/";
    private static final String ATTRIBUTE = "@";
    private static final String ROOT_FIELD = "Fields";

    public UISpecification unmarshal(String filePath, ClassLoader classloader, ResourceBundle bundle) throws SpecificationValidationException {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)(SpecificationReader.class.getPackage().getName() + ".jaxb"));
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            Specification jaxbSpec = (Specification)unmarshaller.unmarshal(new File(filePath));
            return this.convertToSpecification(jaxbSpec, classloader, bundle);
        }
        catch (JAXBException e) {
            throw new SpecificationValidationException((Throwable)e);
        }
    }

    public UISpecification unmarshal(InputStream stream, ClassLoader classloader, ResourceBundle bundle) throws SpecificationValidationException {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)(SpecificationReader.class.getPackage().getName() + ".jaxb"));
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            Specification jaxbSpec = (Specification)unmarshaller.unmarshal(stream);
            return this.convertToSpecification(jaxbSpec, classloader, bundle);
        }
        catch (JAXBException e) {
            throw new SpecificationValidationException((Throwable)e);
        }
    }

    private UISpecification convertToSpecification(Specification jaxbSpec, ClassLoader classloader, ResourceBundle bundle) throws SpecificationValidationException {
        List<AutofillProviderType> autofillProviderList;
        UISpecification s = new UISpecification();
        s.setClassLoader(classloader);
        s.setBundle(bundle);
        TitleType title = jaxbSpec.getTitle();
        s.setRootTitleConf(this.convertToTitleConf(s, title, null));
        AutofillProviderListType autofillProviderListType = jaxbSpec.getAutofillProviders();
        if (autofillProviderListType != null && (autofillProviderList = autofillProviderListType.getProvider()) != null) {
            for (AutofillProviderType providerType : autofillProviderList) {
                AutofillProvider provider = new AutofillProvider(providerType.getName(), providerType.getJavaClass());
                s.addAutofillProvider(provider);
            }
        }
        return s;
    }

    private TitleConf convertToTitleConf(UISpecification specification, TitleType t, TitleConf parentTitle) throws SpecificationValidationException {
        List<VariableType> variables;
        TitleConf tc = new TitleConf(specification);
        tc.setName(this.trim(t.getName()));
        tc.setAlias(t.getAlias());
        String assetPath = parentTitle == null ? tc.getName() : parentTitle.getPath() + PATH_SEPARATOR + tc.getName();
        tc.setPath(assetPath);
        tc.setMaxOccurs(1);
        List list = this.ecmfHelper.getXpathCardinality(assetPath, NAMESPACE_PREFIX);
        if (list != null && !list.isEmpty()) {
            XpathNodeCardinality card = (XpathNodeCardinality)list.get(list.size() - 1);
            int cardinality = card.getCardinality();
            tc.setMaxOccurs(cardinality == 0 ? 1 : cardinality);
        }
        ArrayList<Variable> metadata = new ArrayList<Variable>();
        TitleType.Metadata m = t.getMetadata();
        if (m != null && (variables = m.getVariable()) != null) {
            for (VariableType var : variables) {
                ArrayList<VariableType> path;
                Variable variable = this.convertToVariable(specification, tc, var, path = new ArrayList<VariableType>());
                if (variable == null) continue;
                metadata.add(variable);
            }
        }
        tc.setMetadata(metadata);
        if (t.getChildTitles() != null && t.getChildTitles().getTitle() != null) {
            for (TitleType childTitle : t.getChildTitles().getTitle()) {
                TitleConf child = this.convertToTitleConf(specification, childTitle, tc);
                tc.addChild(child);
            }
        }
        return tc;
    }

    private Variable convertToVariable(UISpecification specification, TitleConf tc, VariableType vt, List<VariableType> path) throws SpecificationValidationException {
        Variable v = null;
        if (BooleanVariableType.class.equals(vt.getClass())) {
            BooleanVariableType typedVT = (BooleanVariableType)vt;
            v = this.convertToBooleanVariable(specification, tc, typedVT, path);
        } else if (IntegerVariableType.class.equals(vt.getClass())) {
            IntegerVariableType typedVT = (IntegerVariableType)vt;
            v = this.convertToIntegerVariable(specification, tc, typedVT, path);
        } else if (FloatVariableType.class.equals(vt.getClass())) {
            FloatVariableType typedVT = (FloatVariableType)vt;
            v = this.convertToFloatVariable(specification, tc, typedVT, path);
        } else if (DateVariableType.class.equals(vt.getClass())) {
            DateVariableType typedVT = (DateVariableType)vt;
            v = this.convertToDateVariable(specification, tc, typedVT, path);
        } else if (TimeVariableType.class.equals(vt.getClass())) {
            TimeVariableType typedVT = (TimeVariableType)vt;
            v = this.convertToTimeVariable(specification, tc, typedVT, path);
        } else if (StringVariableType.class.equals(vt.getClass())) {
            StringVariableType typedVT = (StringVariableType)vt;
            v = this.convertToStringVariable(specification, tc, typedVT, path);
        } else if (ComplexVariableType.class.equals(vt.getClass())) {
            ComplexVariableType typedVT = (ComplexVariableType)vt;
            v = this.convertToComplexVariable(specification, tc, typedVT, path);
        } else {
            String msg = "Failed to convert variable type of class: " + vt.getClass();
            throw new SpecificationValidationException(msg);
        }
        return v;
    }

    private void convertOptions(UISpecification specification, SimpleVariableType vt, SimpleVariable v) {
        OptionsType options = vt.getOptions();
        if (options != null) {
            v.setAnyValueAllowed(options.isAnyValueAllowed());
            v.setOptionProvider(options.getOptionProvider());
            int optionCount = options.getOption().size();
            if (optionCount > 0) {
                for (OptionsType.Option option : options.getOption()) {
                    String name = this.getDisplayName(option.getName(), specification.getBundle());
                    v.addOption(new VariableOption(name, option.getValue()));
                }
            }
        }
    }

    private Variable convertToBooleanVariable(UISpecification specification, TitleConf tc, BooleanVariableType vt, List<VariableType> path) throws SpecificationValidationException {
        BooleanVariable v = new BooleanVariable();
        this.buildSimpleVariable(specification, vt, (SimpleVariable<?>)v, path);
        this.convertOptions(specification, vt, (SimpleVariable)v);
        return this.convertChildVariables(specification, tc, vt, (SimpleVariable<?>)v, path);
    }

    private Variable convertToIntegerVariable(UISpecification specification, TitleConf tc, IntegerVariableType vt, List<VariableType> path) throws SpecificationValidationException {
        IntegerVariable v = new IntegerVariable();
        this.buildSimpleVariable(specification, vt, (SimpleVariable<?>)v, path);
        this.convertOptions(specification, vt, (SimpleVariable)v);
        return this.convertChildVariables(specification, tc, vt, (SimpleVariable<?>)v, path);
    }

    private Variable convertToFloatVariable(UISpecification specification, TitleConf tc, FloatVariableType vt, List<VariableType> path) throws SpecificationValidationException {
        FloatVariable v = new FloatVariable();
        this.buildSimpleVariable(specification, vt, (SimpleVariable<?>)v, path);
        this.convertOptions(specification, vt, (SimpleVariable)v);
        return this.convertChildVariables(specification, tc, vt, (SimpleVariable<?>)v, path);
    }

    private Variable convertToDateVariable(UISpecification specification, TitleConf tc, DateVariableType vt, List<VariableType> path) throws SpecificationValidationException {
        DateVariable v = new DateVariable();
        this.buildSimpleVariable(specification, vt, (SimpleVariable<?>)v, path);
        this.convertOptions(specification, vt, (SimpleVariable)v);
        return this.convertChildVariables(specification, tc, vt, (SimpleVariable<?>)v, path);
    }

    private Variable convertToTimeVariable(UISpecification specification, TitleConf tc, TimeVariableType vt, List<VariableType> path) throws SpecificationValidationException {
        TimeVariable v = new TimeVariable();
        this.buildSimpleVariable(specification, vt, (SimpleVariable<?>)v, path);
        this.convertOptions(specification, vt, (SimpleVariable)v);
        return this.convertChildVariables(specification, tc, vt, (SimpleVariable<?>)v, path);
    }

    private Variable convertToStringVariable(UISpecification specification, TitleConf tc, StringVariableType vt, List<VariableType> path) throws SpecificationValidationException {
        StringVariable v = new StringVariable();
        this.buildSimpleVariable(specification, vt, (SimpleVariable<?>)v, path);
        v.setLongFormat(vt.isLongFormat());
        this.convertOptions(specification, vt, (SimpleVariable)v);
        return this.convertChildVariables(specification, tc, vt, (SimpleVariable<?>)v, path);
    }

    private void buildSimpleVariable(UISpecification specification, SimpleVariableType vt, SimpleVariable<?> v, List<VariableType> path) throws SpecificationValidationException {
        this.buildVariable(specification, vt, (Variable)v, path);
        v.setAttribute(vt.isAttribute());
        v.setJobParameter(vt.isJobParameter());
        v.setJobRuleParameter(vt.isJobRuleParameter());
    }

    private ComplexVariable convertToComplexVariable(UISpecification specification, TitleConf tc, VariableType vt, List<VariableType> path) throws SpecificationValidationException {
        ComplexVariable v = new ComplexVariable();
        this.buildVariable(specification, vt, (Variable)v, path);
        v.setShowCollapsed(vt.isShowCollapsed());
        List<VariableType> childTypes = vt.getVariable();
        if (childTypes != null) {
            path.add(vt);
            for (VariableType childType : childTypes) {
                Variable child = this.convertToVariable(specification, tc, childType, path);
                v.addChild(child);
            }
            path.remove(vt);
        }
        return v;
    }

    private void buildVariable(UISpecification specification, VariableType vt, Variable v, List<VariableType> path) {
        v.setName(vt.getName());
        ResourceBundle bundle = specification.getBundle();
        if (bundle != null && bundle.containsKey(vt.getDisplayName())) {
            v.setDisplayName(bundle.getString(vt.getDisplayName()));
        } else {
            v.setDisplayName(vt.getDisplayName());
        }
        v.setXPath(this.generateXPath(vt, path));
        v.setMultiValue(vt.isMultiValue());
    }

    private void loadDynamicOptions(UISpecification specification, List<VariableOption> options, String providerClassName, Class dataType) throws SpecificationValidationException {
        Object providerInstance = null;
        try {
            ClassLoader classloader = specification.getClassLoader();
            Class<?> providerClass = classloader.loadClass(providerClassName);
            providerInstance = providerClass.newInstance();
        }
        catch (Exception e) {
            String msg = "Failed to create an instance of the variable option provider: " + providerClassName;
            throw new SpecificationValidationException(msg, (Throwable)e);
        }
        if (!(providerInstance instanceof IVariableOptionProvider)) {
            String msg = "The variable option provider: " + providerClassName + " does not implement required interface: " + IVariableOptionProvider.class.getName();
            throw new SpecificationValidationException(msg);
        }
        try {
            IVariableOptionProvider provider = providerInstance;
            for (VariableOption option : provider.getOptions()) {
                dataType.cast(option.getValue());
                options.add(option);
            }
        }
        catch (Exception e) {
            String msg = "Failed to get the load options from variable option provider: " + providerClassName + ", expecting option values of type: " + dataType.getName();
            throw new SpecificationValidationException(msg, (Throwable)e);
        }
    }

    private String trim(String s) {
        return s != null ? s.trim() : null;
    }

    private String getDisplayName(String name, ResourceBundle bundle) {
        if (bundle != null && bundle.containsKey(name)) {
            return bundle.getString(name);
        }
        return name;
    }

    private String generateXPath(VariableType vt, List<VariableType> path) {
        StringBuilder xpath = new StringBuilder();
        xpath.append(PATH_SEPARATOR).append(NAMESPACE_PREFIX).append(ROOT_FIELD);
        for (VariableType ancestor : path) {
            xpath.append(PATH_SEPARATOR).append(NAMESPACE_PREFIX).append(ancestor.getName());
        }
        xpath.append(PATH_SEPARATOR);
        boolean attribute = false;
        if (vt instanceof SimpleVariableType) {
            SimpleVariableType simpleVT = (SimpleVariableType)vt;
            attribute = simpleVT.isAttribute();
        }
        xpath.append(attribute ? ATTRIBUTE : NAMESPACE_PREFIX);
        xpath.append(vt.getName());
        return xpath.toString();
    }

    private Variable convertChildVariables(UISpecification specification, TitleConf tc, SimpleVariableType vt, SimpleVariable<?> v, List<VariableType> path) throws SpecificationValidationException {
        ComplexVariable outputVariable = v;
        boolean hasChildren = vt.getVariable() != null && vt.getVariable().size() > 0;
        boolean hasTTVChildren = DataTypeMappingReader.getInstance().hasChildren(v.getXPath());
        if (hasChildren || hasTTVChildren) {
            ComplexVariable wrapper = this.convertToComplexVariable(specification, tc, vt, path);
            wrapper.setXPath(NAMESPACE_PREFIX);
            wrapper.getChildren().add(0, v);
            v.setName(SimpleVariable.WRAPPED_FIELD_NAME);
            outputVariable = wrapper;
        }
        return outputVariable;
    }
}

