/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.ingest;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationMessage;
import com.tandbergtv.watchpoint.pmm.entities.ISavedTitle;
import com.tandbergtv.watchpoint.pmm.entities.ITitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.ingest.ContentMapping;
import com.tandbergtv.watchpoint.pmm.title.ingest.ITitleIngestService;
import com.tandbergtv.watchpoint.pmm.title.ingest.ITitleIngester;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleAsset;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleIngestException;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleIngestResult;
import com.tandbergtv.watchpoint.pmm.util.RulesEngineFacade;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.aspectj.runtime.internal.AroundClosure;

public class TitleIngester
implements ITitleIngester {
    private static final String CONTENT_EVENT_NAME = "INGESTED";
    private ITitleIngestService titleIngestServiceInstance = null;
    private ITitleManager titleManagerInstance = null;

    @Transactional
    public ISavedTitle ingestMetadata(String metadataFilePath, String providerId, String contentClass, ITitleActionSource source) throws TitleIngestException, TitleValidationException {
        String string = metadataFilePath;
        String string2 = providerId;
        String string3 = contentClass;
        ITitleActionSource iTitleActionSource = source;
        return (ISavedTitle)TitleIngester.ingestMetadata_aroundBody1$advice(this, string, string2, string3, iTitleActionSource, TransactionEnforcer.aspectOf(), TitleIngester.class.getDeclaredMethod("ingestMetadata", String.class, String.class, String.class, ITitleActionSource.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public ISavedTitle ingestPackage(String metadataFilePath, String packageFolderPath, List<String> assetsNotInPackage, String providerId, String contentClass, ITitleActionSource source) throws TitleIngestException, TitleValidationException {
        String string = metadataFilePath;
        String string2 = packageFolderPath;
        List<String> list = assetsNotInPackage;
        String string3 = providerId;
        String string4 = contentClass;
        ITitleActionSource iTitleActionSource = source;
        return (ISavedTitle)TitleIngester.ingestPackage_aroundBody3$advice(this, string, string2, list, string3, string4, iTitleActionSource, TransactionEnforcer.aspectOf(), TitleIngester.class.getDeclaredMethod("ingestPackage", String.class, String.class, List.class, String.class, String.class, ITitleActionSource.class).getAnnotation(Transactional.class), null);
    }

    public void sendIngestedEvent(Long titleId) {
        RulesEngineFacade.sendIngestedEvent(titleId);
    }

    private ITitleIngestService titleIngestService() {
        if (this.titleIngestServiceInstance == null) {
            this.titleIngestServiceInstance = (ITitleIngestService)ServiceRegistry.getDefault().lookup(ITitleIngestService.class);
        }
        return this.titleIngestServiceInstance;
    }

    @Transactional
    public List<TitleValidationMessage> validate(Title title) {
        Title title2 = title;
        return (List)TitleIngester.validate_aroundBody5$advice(this, title2, TransactionEnforcer.aspectOf(), TitleIngester.class.getDeclaredMethod("validate", Title.class).getAnnotation(Transactional.class), null);
    }

    private ITitleManager titleManager() {
        if (this.titleManagerInstance == null) {
            this.titleManagerInstance = (ITitleManager)ServiceRegistry.getDefault().lookup(ITitleManager.class);
        }
        return this.titleManagerInstance;
    }

    public String getServiceName() {
        return "TitleIngester";
    }

    public void start() {
    }

    public void stop() {
    }

    private static final /* synthetic */ ISavedTitle ingestMetadata_aroundBody0(TitleIngester this_, String metadataFilePath, String providerId, String contentClass, ITitleActionSource source) {
        ContentMapping contentMapping = this_.titleIngestService().getMappingForMetadata(metadataFilePath);
        if (contentMapping.hasDuplicateMatches()) {
            throw new TitleIngestException("Title has multiple matches in the system. Content Mapping: " + contentMapping);
        }
        TitleIngestResult ingestResult = null;
        if (contentMapping.hasNoMatch()) {
            ingestResult = this_.titleIngestService().createTitleForMetadata(metadataFilePath, providerId, contentClass, source);
        } else {
            Long titleId = ((TitleAsset)contentMapping.getTitleAssets().iterator().next()).getTitleId();
            ingestResult = this_.titleIngestService().updateTitleForMetadata(metadataFilePath, titleId, source);
        }
        Title title = ingestResult.getSavedTitle().getTitle();
        this_.titleManager().normalize(title, CONTENT_EVENT_NAME);
        return this_.titleManager().save(title, source);
    }

    private static final /* synthetic */ Object ingestMetadata_aroundBody1$advice(TitleIngester this_, String metadataFilePath, String providerId, String contentClass, ITitleActionSource source, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngester.ingestMetadata_aroundBody0(this_, metadataFilePath, providerId, contentClass, source);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ISavedTitle object = TitleIngester.ingestMetadata_aroundBody0(this_, metadataFilePath, providerId, contentClass, source);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ ISavedTitle ingestPackage_aroundBody2(TitleIngester this_, String metadataFilePath, String packageFolderPath, List assetsNotInPackage, String providerId, String contentClass, ITitleActionSource source) {
        ContentMapping contentMapping = this_.titleIngestService().getMappingForMetadata(metadataFilePath);
        if (contentMapping.hasDuplicateMatches()) {
            throw new TitleIngestException("Title has multiple matches in the system. Content Mapping: " + contentMapping);
        }
        TitleIngestResult ingestResult = null;
        if (contentMapping.hasNoMatch()) {
            ingestResult = this_.titleIngestService().createTitleForPackage(metadataFilePath, packageFolderPath, providerId, contentClass, source);
        } else {
            Long titleId = ((TitleAsset)contentMapping.getTitleAssets().iterator().next()).getTitleId();
            ingestResult = this_.titleIngestService().updateTitleForPackage(metadataFilePath, packageFolderPath, titleId, source);
        }
        Title title = ingestResult.getSavedTitle().getTitle();
        for (String assetPath : assetsNotInPackage) {
            this_.titleIngestService().updateTitleForContent(assetPath, title, source);
        }
        this_.titleManager().normalize(title, CONTENT_EVENT_NAME);
        return this_.titleManager().save(title, source);
    }

    private static final /* synthetic */ Object ingestPackage_aroundBody3$advice(TitleIngester this_, String metadataFilePath, String packageFolderPath, List assetsNotInPackage, String providerId, String contentClass, ITitleActionSource source, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngester.ingestPackage_aroundBody2(this_, metadataFilePath, packageFolderPath, assetsNotInPackage, providerId, contentClass, source);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ISavedTitle object = TitleIngester.ingestPackage_aroundBody2(this_, metadataFilePath, packageFolderPath, assetsNotInPackage, providerId, contentClass, source);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List validate_aroundBody4(TitleIngester this_, Title title) {
        try {
            return this_.titleManager().validate(title, false);
        }
        catch (TitleValidationException e) {
            return e.getMessages();
        }
    }

    private static final /* synthetic */ Object validate_aroundBody5$advice(TitleIngester this_, Title title, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngester.validate_aroundBody4(this_, title);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = TitleIngester.validate_aroundBody4(this_, title);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

