/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.search;

import com.ericsson.cms.criteria.LogicalOperator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class QueryBuilderHelper {
    public static String getCondition(String fieldName, LogicalOperator lop, List<String> values, String alias, String dataType, boolean ignoreCase) {
        String field = alias + "." + fieldName;
        if (dataType != null && dataType.equals("date") && values.size() == 1 && values.get(0).length() == 10) {
            return QueryBuilderHelper.handleSpecialDates(field, lop, values.get(0));
        }
        StringBuffer sb = new StringBuffer();
        sb.append(field);
        if (ignoreCase) {
            sb.insert(0, "UPPER(");
            sb.append(")");
        }
        if (lop.equals((Object)LogicalOperator.IN)) {
            QueryBuilderHelper.handleIn(sb, values, false, dataType);
        } else if (lop.equals((Object)LogicalOperator.NOTIN)) {
            QueryBuilderHelper.handleIn(sb, values, true, dataType);
        } else if (lop.equals((Object)LogicalOperator.ISEMPTY)) {
            sb.append(" IS NULL");
        } else if (lop.equals((Object)LogicalOperator.ISNOTEMPTY)) {
            sb.append(" IS NOT NULL");
        } else if (lop.equals((Object)LogicalOperator.STARTSWITH)) {
            sb.append(" like '");
            sb.append(ignoreCase ? values.get(0).toUpperCase() : values.get(0));
            sb.append("%'");
        } else if (lop.equals((Object)LogicalOperator.ENDSWITH)) {
            sb.append(" like '%");
            sb.append(ignoreCase ? values.get(0).toUpperCase() : values.get(0));
            sb.append("'");
        } else if (lop.equals((Object)LogicalOperator.DOESNOTSTARTWITH)) {
            sb.append(" not like '");
            sb.append(ignoreCase ? values.get(0).toUpperCase() : values.get(0));
            sb.append("%'");
        } else if (lop.equals((Object)LogicalOperator.DOESNOTENDWITH)) {
            sb.append(" not like '%");
            sb.append(ignoreCase ? values.get(0).toUpperCase() : values.get(0));
            sb.append("'");
        } else {
            if (values.size() != 1) {
                throw new IllegalArgumentException("only one operator for " + lop.name());
            }
            sb.append(QueryBuilderHelper.getNonInOperator(lop));
            sb.append(" ");
            sb.append(QueryBuilderHelper.encodeField(values.get(0), dataType, ignoreCase));
        }
        return sb.toString();
    }

    private static String handleSpecialDates(String field, LogicalOperator lop, String value) {
        Date startDate = QueryBuilderHelper.parseDate(value);
        String start = QueryBuilderHelper.convertDate(startDate);
        String end = QueryBuilderHelper.convertDate(QueryBuilderHelper.addDays(startDate, 1));
        switch (lop) {
            case EQUAL: {
                return "(" + field + " >= " + start + " and " + field + " < " + end + ")";
            }
            case NOTEQUAL: {
                return "(" + field + " < " + start + " and " + field + " >= " + end + ")";
            }
            case LESSTHAN: {
                return field + " < " + start;
            }
            case LESSTHANEQUAL: {
                return field + " < " + end;
            }
            case GREATERTHAN: {
                return field + " > " + end;
            }
            case GREATERTHANEQUAL: {
                return field + " >= " + start;
            }
        }
        throw new IllegalArgumentException("Unsupported title operator " + lop.name());
    }

    private static String encodeField(String value, String dataType, boolean ignoreCase) {
        if (dataType.equals("string") || dataType.equals("boolean")) {
            return "'" + (ignoreCase ? value.toUpperCase() : value) + "'";
        }
        if (dataType.equals("date")) {
            return "to_timestamp('" + value + "','YYYY-MM-DD\"T\"HH24:MI:SS.FF')";
        }
        return value;
    }

    private static void handleIn(StringBuffer sb, List<String> values, boolean not, String dataType) {
        sb.append(" ");
        if (not) {
            sb.append("NOT ");
        }
        sb.append("IN (");
        if (values.size() == 0) {
            throw new IllegalArgumentException("In & Not In operators require a minimum of one value");
        }
        for (int i = 0; i < values.size() - 1; ++i) {
            sb.append(values.get(i));
            sb.append(", ");
        }
        sb.append(values.get(values.size() - 1));
        sb.append(")");
    }

    private static String getNonInOperator(LogicalOperator lop) {
        switch (lop) {
            case EQUAL: {
                return "=";
            }
            case NOTEQUAL: {
                return "<>";
            }
            case LESSTHAN: {
                return "<";
            }
            case LESSTHANEQUAL: {
                return "<=";
            }
            case GREATERTHAN: {
                return ">";
            }
            case GREATERTHANEQUAL: {
                return ">=";
            }
        }
        throw new IllegalArgumentException("Unsupported title operator " + lop.name());
    }

    private static Date parseDate(String date) {
        String format = "yyyy-MM-dd";
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        try {
            return formatter.parse(date.substring(0, format.length()));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private static String convertDate(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String encodedDate = "to_timestamp('" + dateFormat.format(date) + "','YYYY-MM-DD')";
        return encodedDate;
    }

    private static Date addDays(Date date, int days) {
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(date);
        cal.add(6, days);
        return cal.getTime();
    }
}

