/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.search;

import com.ericsson.cms.criteria.ExpList;
import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.tandbergtv.cms.titlefilter.CriteriaMode;
import com.tandbergtv.metadatamanager.search.SearchSchemaHelper;
import com.tandbergtv.metadatamanager.util.CustomFieldXPathConverter;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import com.tandbergtv.watchpoint.pmm.title.search.QueryBuilderHelper;
import com.tandbergtv.watchpoint.pmm.title.search.QueryHelperBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SeasonQueryBuilder
extends QueryHelperBase {
    private static final String SERIES_SEASON = "SERIES/SEASON";

    public String getSeasonQuery(ExpNode seasonConditions, ExpNode generalConditions) {
        StringBuffer query = new StringBuffer();
        HashMap<String, String> seasonFields = new HashMap<String, String>();
        StringBuilder seasonCond = new StringBuilder();
        if (seasonConditions != null) {
            this.processSeasonCondition(seasonConditions, seasonFields, seasonCond, new Counter(0));
        }
        query.append("SELECT t.mdmDocId, xtab.seasonid \r\n");
        query.append("FROM pmm_title t, mdm_metadata mdm, pmm_content_class cc, \r\n");
        query.append("XMLTable('/ECMFSpec/Series/Season' PASSING mdm.OBJECT_VALUE COLUMNS seasonId NUMBER PATH '@assetId'");
        for (Map.Entry field : seasonFields.entrySet()) {
            query.append(", ");
            query.append((String)field.getValue());
            query.append(" ");
            query.append((String)field.getKey());
        }
        query.append(")xtab \r\n");
        this.buildWhere(query, generalConditions, seasonCond);
        return query.toString();
    }

    private void processSeasonCondition(ExpNode seasonCondition, Map<String, String> seasonFields, StringBuilder conditions, Counter fieldsCnt) {
        if (seasonCondition instanceof ExpValue) {
            Predicate predicate = ((ExpValue)seasonCondition).getPredicate();
            LogicalOperator operator = predicate.getNot() != false ? predicate.getOperator().invert() : predicate.getOperator();
            DataTypeMappingReader dtr = DataTypeMappingReader.getInstance();
            String dataType = dtr.determineDataType(predicate.getFieldLeft());
            String col = this.xmlTableCol(predicate, dataType);
            String field = seasonFields.get(col);
            if (field == null) {
                field = "field" + fieldsCnt.next();
                seasonFields.put(col, field);
            }
            if (operator.equals((Object)LogicalOperator.CONTAINS)) {
                String value = (String)((PredicateRightValue)predicate).getValue().get(0);
                conditions.append(this.getContains(">", field, value));
            } else if (operator.equals((Object)LogicalOperator.DOESNOTCONTAIN)) {
                String value = (String)((PredicateRightValue)predicate).getValue().get(0);
                conditions.append(this.getContains("=", field, value));
            } else {
                ArrayList<String> values = predicate instanceof PredicateRightValue ? ((PredicateRightValue)predicate).getValue() : new ArrayList<String>(0);
                conditions.append(QueryBuilderHelper.getCondition(field, operator, values, "xtab", dataType, predicate.getIgnoreCase()));
            }
        } else if (seasonCondition instanceof ExpList) {
            ExpList list = (ExpList)seasonCondition;
            List nodes = list.getNodes();
            if (nodes.isEmpty()) {
                return;
            }
            String listOperator = list.getSqlOperator();
            conditions.append("(");
            for (int i = 0; i < nodes.size(); ++i) {
                ExpNode node = (ExpNode)nodes.get(i);
                if (i > 0) {
                    conditions.append(listOperator);
                }
                this.processSeasonCondition(node, seasonFields, conditions, fieldsCnt);
            }
            conditions.append(")");
        }
    }

    private String getContains(String operator, String field, String value) {
        StringBuffer contains = new StringBuffer("XMLExists('$p/");
        contains.append(field.toUpperCase());
        contains.append("[ora:contains(text(), \"");
        contains.append(value);
        contains.append("\") ");
        contains.append(operator);
        contains.append(" 0]' PASSING sys_XMLGen(");
        contains.append(field);
        contains.append(") AS \"p\")");
        return contains.toString();
    }

    private String xmlTableCol(Predicate predicate, String dataType) {
        String field = predicate.getFieldLeft();
        if (field.startsWith("/Fields/CustomFields/CustomField[@name=")) {
            field = CustomFieldXPathConverter.getActualXpath((String)field);
        }
        SearchSchemaHelper ssh = new SearchSchemaHelper();
        String assetType = ssh.getCorrectedAssetPath(predicate.getFieldLeftSectionType(), false);
        StringBuffer xpath = new StringBuffer();
        if (!assetType.toUpperCase().startsWith(SERIES_SEASON)) {
            throw new RuntimeException("I can't work on " + assetType);
        }
        if (assetType.length() > SERIES_SEASON.length() + 1) {
            xpath.append(assetType.substring(SERIES_SEASON.length() + 1));
            xpath.append(field);
        } else {
            xpath.append(field.substring(1));
        }
        String fieldDataType = "varchar2(4000)";
        if (dataType.equals("integer") || dataType.equals("float")) {
            fieldDataType = "NUMBER";
        } else if (dataType.equals("date")) {
            fieldDataType = "timestamp(0)";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(fieldDataType);
        sb.append(" path '");
        sb.append(xpath);
        sb.append("'");
        return sb.toString();
    }

    private void buildWhere(StringBuffer query, ExpNode generalConditions, StringBuilder seasonCond) {
        query.append("WHERE t.mdmdocid = EXTRACTVALUE(SYS_NC_ROWINFO$, '/ECMFSpec/@documentId') and t.content_class_id = cc.ID");
        query.append("\r\nAND ");
        query.append("titlestatusid <> 5 ");
        this.addCriteriaMode(CriteriaMode.SERIES, query);
        if (generalConditions != null) {
            query.append(" AND ");
            this.buildConditionRec(query, generalConditions);
        }
        if (seasonCond.length() > 0) {
            query.append(" AND ");
            query.append((CharSequence)seasonCond);
        }
    }

    private class Counter {
        private int value;

        public Counter(int start) {
            this.value = start;
        }

        public int next() {
            return this.value++;
        }
    }
}

