/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.upgrade.utils;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class DBUtils {
    protected static final Logger logger = Logger.getLogger(DBUtils.class);
    protected static final String DEFAULT_USERNAME = "wfs";
    protected static final String DEFAULT_PASSWORD = "Wf$1234";
    protected static final String DEFAULT_SID = "ttv";
    protected static final String DEFAULT_HOSTNAME = "DBSERVER";
    protected static final String JDBC_DRIVER_CLASS = "oracle.jdbc.driver.OracleDriver";
    protected static Connection dbConn = null;

    public static Connection getDBConnection(String[] args) {
        if (dbConn == null) {
            logger.info((Object)"dbConn is 'null'. Getting a new database Connection...");
            dbConn = DBUtils.getConnection(args);
        }
        return dbConn;
    }

    protected static Connection getConnection(String[] args) {
        String hostName;
        String host = DEFAULT_HOSTNAME;
        String sid = DEFAULT_SID;
        String userName = DEFAULT_USERNAME;
        String password = DEFAULT_PASSWORD;
        String argsString = Arrays.toString(args);
        logger.info((Object)("Getting " + sid + " database connection...args: " + argsString));
        Connection conn = null;
        if (args != null && args.length > 0 && (hostName = args[0]) != null && hostName.trim().length() > 0) {
            hostName = hostName.trim();
            logger.info((Object)("Hostname: " + hostName + " was passed in program arguments, and will be used instead of " + host));
            host = hostName;
        }
        String jdbcURL = "jdbc:oracle:thin:@" + host + ":1521:" + sid;
        logger.info((Object)("Getting database connection for jdbcURL = " + jdbcURL));
        String connURL = null;
        try {
            conn = DriverManager.getConnection(jdbcURL, userName, password);
            connURL = conn.getMetaData().getURL();
        }
        catch (Exception e) {
            String errMsg = "Exception occurred getting connection for jdbcURL: " + jdbcURL + " : " + e.toString();
            logger.error((Object)errMsg, (Throwable)e);
            throw new RuntimeException(errMsg, e);
        }
        logger.info((Object)("Returning " + sid + " database connection...URL: " + connURL));
        return conn;
    }
}

