##############################################################################################################
##    Script Name    : createLinks.sh                                                                       ##
##    Author         : Sanjay Khattar                                                                       ##
##    Created on     : 05/24/2013                                                                           ##
##    Usage          : ./createLinks.sh                                                                     ##
##    Purpose        : Create file links required for CMS upgrade.                                          ##
##                                                                                                          ##
##############################################################################################################

#!/bin/sh

##
## This script creates file links required for CMS upgrade. 
## The environment variables and functions need to have been already initialized
##    by sourcing ./initEnvCommon.sh.
##

me="createLinks.sh"

logMsg "$me invoked with args: $*"

devRandom=/dev/random
devURandom=/dev/urandom

ACTIVITY="creating symbolic link $devRandom to $devURandom"

logBeginMsg "$ACTIVITY"

if [ ! -L "$devRandom" ]; then
    logMsg "$devRandom is not a link. Creating..."
    mv -vf $devRandom $devRandom.orig
    ln -sv $devURandom $devRandom
else
    logMsg "$devRandom is a link...."
    target=$(readlink -v $devRandom)
    logMsg "Target for $devRandom = $target"
    if [ "$target" = "$devURandom" ]; then
        echo "$devRandom is a link to $devURandom. Nothing to do..."
    fi
fi

logDoneMsg "$ACTIVITY"
