##############################################################################################################
##    Script Name    : getUpgradePath.sh                                                                    ##
##    Author         : Leon Lin		                                                                        ##
##    Created on     : 12/02/2013                                                                           ##
##    Usage          : ./getUpgradePath.sh                                                                  ##
##    Purpose        : Determine the upgrade path (from version and to version)                             ##
##                       for the current CMS Upgrade.                                                       ##
##                                                                                                          ##
##############################################################################################################

#!/bin/sh

##
## This script can be used to determine the upgrade path for the current CMS upgrade. 
## This script assumes that CMS database upgrade has already happened, 
##    and the system_settings table has the correct CMS version before upgrade. 
## Also the environment variables and functions need to have been already initialized
##    by sourcing ./initEnvCommon.sh.
##

me="getUpgradePath.sh"

logMsg "$me invoked with args: $*"

productPropertiesPath=/opt/tandbergtv/cms/product.properties
versionKey=product.version

ACTIVITY="getting upgrade path for the current CMS upgrade"

logBeginMsg "$ACTIVITY"
cmsVersionBeforeUpgrade=($(cat $productPropertiesPath | grep $versionKey | cut -d "=" -f 2))
logMsg "VERSION_BEFORE_FILE_PATH = $VERSION_BEFORE_FILE_PATH"


shortCMSVersionBeforeUpgrade=${cmsVersionBeforeUpgrade%.*}
upgrade_from_cms_version="${shortCMSVersionBeforeUpgrade}"
upgrade_to_cms_version=$CMS_VERSION_3_1_010


export cmsVersionBeforeUpgrade
export shortCMSVersionBeforeUpgrade
export upgrade_from_cms_version
export upgrade_to_cms_version


logMsg "cmsVersionBeforeUpgrade = $cmsVersionBeforeUpgrade"
logMsg "shortCMSVersionBeforeUpgrade = $shortCMSVersionBeforeUpgrade"
logMsg "upgrade_from_cms_version = $upgrade_from_cms_version"
logMsg "upgrade_to_cms_version = $upgrade_to_cms_version"


logDoneMsg "$ACTIVITY"
