##############################################################################################################
##    Script Name    : upgrade.sh	                                                                    ##
##    Author         : Leon Lin                                                                             ##
##    Created on     : 12/02/2013                                                                           ##
##    Usage          : ./upgrade.sh	                                                                    ##
##    Purpose        : Main upgrade scrpit to drive the process  			                    ##
##                                                                                                          ##
##############################################################################################################

#!/bin/sh


. ./activitySeparator

echo "$me invoked with args: $*"

MESSAGE_PREFIX="    $me: "
BEGIN_MESSAGE="begin "
START_MESSAGE=""
DONE_MESSAGE="done "

MAIN_ACTIVITY="cms upgrade main script"
MAIN_ACTIVITY_MSG="$MESSAGE_PREFIX$BEGIN_MESSAGE$MAIN_ACTIVITY...$(date)"

echo "$MAIN_ACTIVITY_MSG"

## First initialize the common environment variables and functions.

MAIN_SUB_ACTIVITY="initializing environment variables"
MAIN_SUB_ACTIVITY_MSG="$MESSAGE_PREFIX$MAIN_SUB_ACTIVITY...$(date)"

echo "$MAIN_SUB_ACTIVITY_MSG"

. ./initEnvCommon.sh

logDoneMsg "$MAIN_SUB_ACTIVITY"

activitySeparator

MAIN_SUB_ACTIVITY="getting upgrade path"
logBeginMsg "$MAIN_SUB_ACTIVITY"
. ./getUpgradePath.sh
logDoneMsg "$MAIN_SUB_ACTIVITY"

activitySeparator

MAIN_SUB_ACTIVITY="running common pre-upgrade tasks" 
logBeginMsg "$MAIN_SUB_ACTIVITY"
## First the tasks which are common to all upgrade paths. 
. ./commonPreUpgradeTasks.sh
logDoneMsg "$MAIN_SUB_ACTIVITY"

activitySeparator

MAIN_SUB_ACTIVITY="running upgrade scripts" 
logBeginMsg "$MAIN_SUB_ACTIVITY"
## First the tasks which are common to all upgrade paths. 
. ./upgradeCMSMain.sh
logDoneMsg "$MAIN_SUB_ACTIVITY"

activitySeparator

MAIN_SUB_ACTIVITY="running common post-upgrade tasks" 
logBeginMsg "$MAIN_SUB_ACTIVITY"
## Finally the post-upgrade tasks which are common to all upgrade paths. 
. ./commonPostUpgradeTasks.sh
logDoneMsg "$MAIN_SUB_ACTIVITY"

activitySeparator

logDoneMsg "$MAIN_ACTIVITY"

activitySeparator
