##############################################################################################################
##    Script Name    : upgradeCMSMain.sh	                                                            ##
##    Author         : Leon Lin                                                                             ##
##    Created on     : 12/02/2013                                                                           ##
##    Usage          : ./upgradeCMSMain.sh	                                                            ##
##    Purpose        : Get upgrade CMS version by version along the upgrade path                            ##
##                                                                                                          ##
##############################################################################################################

#!/bin/sh


upgradeScriptName=initUpdateConf.sh
postUpgradeScriptName=postUpgrade.sh
Version=${cmsVersionBeforeUpgrade%.*}

#sort the folder to make sure the upgrade path is in order
folders=$(ls ./upgrade_package | sort)


for foldername in ${folders[*]} 
do

	versions=($(echo ${foldername}|tr '-' ' '|tr -s ' '))

	if [[ "${versions[0]}" == ${shortVersion}* ]]; then
		echo "run installation script"
		export CURRENT_PACKAGE_FOLDER="./upgrade_package/${foldername}"
		upgradeScript=${CURRENT_PACKAGE_FOLDER}/${upgradeScriptName}
		postUpgradeScript=${CURRENT_PACKAGE_FOLDER}/${postUpgradeScriptName}
		./upgradeCMS.sh ${upgradeScript} ${postUpgradeScript}
		shortVersion=versions[1]
	else
		echo "version doesn't match, skip upgrade folder "${foldername}
	fi
	
done
