##############################################################################################################
##    Script Name    : upgradeReportConfig.sh                                                               ##
##    Author         : Sanjay Khattar                                                                       ##
##    Created on     : 07/10/2013                                                                           ##
##    Usage          : ./upgradeReportConfig.sh                                                             ##
##    Purpose        : Script for upgrading report-config.xml.                                              ##
##                                                                                                          ##
##############################################################################################################

#!/bin/sh

##
## Upgrade report-config.xml.
##

ACTIVITY="upgrading report-config.xml"

REPORT_CONFIG_XML_SOURCE_FILE_PATH_1_2=/opt/tandbergtv/cms/conf/workflow/report-config.xml
REPORT_CONFIG_XML_TARGET_FILE_PATH=/opt/tandbergtv/cms/conf/report/report-config.xml

REPORTS_PREFIX=/Reports
REPORTS_CATALOG_NAME_PREFIX=$REPORTS_PREFIX
REPORTS_REPORT_NAME_PREFIX=$REPORTS_PREFIX

REPORTS_TAG_1_2="<reports>"
REPORTS_TAG_3_1="<reports baseURL=\"/jreport/jinfonet/tryView.jsp?jrs.auth_uid=cms&amp;jrs.auth_pwd=cms&amp;\">"

CATALOG_NAME_FRAGMENT="<catalogName>"
REPORT_NAME_FRAGMENT="<reportName>"

logBeginMsg "$ACTIVITY"

homedir=$(pwd) 

if [ "$CMS_VERSION_1_2" == "$upgrade_from_cms_version" ]; then
    if [ -f "$REPORT_CONFIG_XML_SOURCE_FILE_PATH_1_2" ]; then
        SUB_ACTIVITY="moving $REPORT_CONFIG_XML_SOURCE_FILE_PATH_1_2 to $REPORT_CONFIG_XML_TARGET_FILE_PATH"

        logBeginMsg "$SUB_ACTIVITY"
    
        mv -bvf $REPORT_CONFIG_XML_SOURCE_FILE_PATH_1_2 $REPORT_CONFIG_XML_TARGET_FILE_PATH
    
        logDoneMsg "$SUB_ACTIVITY"
    fi
fi

if [ -f "$REPORT_CONFIG_XML_TARGET_FILE_PATH" ]; then
    SUB_ACTIVITY="upgrading $REPORT_CONFIG_XML_TARGET_FILE_PATH"

    logBeginMsg "$SUB_ACTIVITY"

    inputFile=$REPORT_CONFIG_XML_TARGET_FILE_PATH
    tmpOutputFile="$REPORT_CONFIG_XML_TARGET_FILE_PATH.upgraded.tmp"
    if [ -f "$tmpOutputFile" ]; then
        SUB_SUB_ACTIVITY="removing previous $tmpOutputFile"
        
        logMsg "$SUB_SUB_ACTIVITY"
        
        mv -bvf "$tmpOutputFile" "$tmpOutputFile.archive"

        logDoneMsg "$SUB_SUB_ACTIVITY"
    fi
    
    SUB_SUB_ACTIVITY="processing $inputFile"
        
    logBeginMsg "$SUB_SUB_ACTIVITY"
        
    while read line; do 
        upgradedLine=$line
        
        if echo "$line" | grep -q "$REPORTS_TAG_1_2" ; then
            logMsg "Got reports element tag: $line"
            SUB_SUB_ACTIVITY="replacing $REPORTS_TAG_1_2 with $REPORTS_TAG_3_1"
            
            logMsg "$SUB_SUB_ACTIVITY"
            
            upgradedLine="$REPORTS_TAG_3_1" 
        elif echo "$line" | grep -q "$CATALOG_NAME_FRAGMENT" ; then
            if ! echo "$line" | grep -q "$CATALOG_NAME_FRAGMENT$REPORTS_CATALOG_NAME_PREFIX" ; then
                SUB_SUB_ACTIVITY="prepending $REPORTS_CATALOG_NAME_PREFIX to catalog name in $line"
                
                logMsg "$SUB_SUB_ACTIVITY"
                
                catalogNameIndex=`expr index "$line" "$CATALOG_NAME_FRAGMENT"`
                catalogNameLength=`expr length "$CATALOG_NAME_FRAGMENT"`
                indexCatalogNameEnd=$((catalogNameIndex + catalogNameLength - 1))
                lineMinus="${line:$indexCatalogNameEnd}"
                upgradedLine="$CATALOG_NAME_FRAGMENT$REPORTS_CATALOG_NAME_PREFIX$lineMinus" 
            fi
        elif echo "$line" | grep -q "$REPORT_NAME_FRAGMENT" ; then
            if ! echo "$line" | grep -q "$REPORT_NAME_FRAGMENT$REPORTS_REPORT_NAME_PREFIX" ; then
                SUB_SUB_ACTIVITY="prepending $REPORTS_REPORT_NAME_PREFIX to report name in $line"
                
                logMsg "$SUB_SUB_ACTIVITY"
                
                reportNameIndex=`expr index "$line" "$REPORT_NAME_FRAGMENT"`
                reportNameLength=`expr length "$REPORT_NAME_FRAGMENT"`
                indexReportNameEnd=$((reportNameIndex + reportNameLength - 1))
                lineMinus="${line:$indexReportNameEnd}"
                upgradedLine="$REPORT_NAME_FRAGMENT$REPORTS_REPORT_NAME_PREFIX$lineMinus" 
            fi
        fi
        
        echo "$upgradedLine" >> "$tmpOutputFile"
    done < $inputFile

    logDoneMsg "$SUB_SUB_ACTIVITY"

    if [ -f "$tmpOutputFile" ]; then
        SUB_SUB_ACTIVITY="moving $tmpOutputFile to $REPORT_CONFIG_XML_TARGET_FILE_PATH"
        
        logBeginMsg "$SUB_SUB_ACTIVITY"
        
        xmllint --output "$REPORT_CONFIG_XML_TARGET_FILE_PATH" --format "$tmpOutputFile" 

        logDoneMsg "$SUB_SUB_ACTIVITY"
    fi

    logDoneMsg "$SUB_ACTIVITY"
    
else 
    logMsg "No such file: $REPORT_CONFIG_XML_TARGET_FILE_PATH"
    logMsg "No report config to upgrade..."    
fi


cd $homedir

logDoneMsg "$ACTIVITY"

