##############################################################################################################
##    Script Name    : initUpdateConf.sh                                                                    ##
##    Author         : Leon Lin	                                                                            ##
##    Created on     : 11/28/2013                                                                           ##
##    Usage          : ./initUpdateConf.sh                                                                  ##
##    Purpose        : Script for initializing configuration to upgrade CMS App Server to version 3.1.      ##
##                                                                                                          ##
##############################################################################################################

#!/bin/sh

##
## This script initializes variables for upgrade such as files to backup/rpm to install, etc  
## which are used by CMS backup restore (restore-CMS.sh) and CMS Upgrade (upgradeCMSMain.sh). 
##

#################################################################
# Backup Config Files
#################################################################
CONFIG_FILES=(
    "/etc/cron.d/sysstat"
    "/etc/cron.monthly/purgeOldXportLogs.cron"
    "/etc/init.d/alerts"
    "/etc/init.d/cms"
    "/etc/init.d/RCSSchedulerService"
    "/etc/init.d/rcssnmpsubagent"
    "/etc/modprobe.d/bonding.conf"
    "/opt/tandbergtv/cms/conf/categoryMgmt/category.properties"
    "/opt/tandbergtv/cms/conf/contentMgmt/fileupload.properties"
    "/opt/tandbergtv/cms/conf/contentMgmt/imageeditor.properties"
    "/opt/tandbergtv/cms/conf/contentMgmt/SearchFieldNames.properties"
    "/opt/tandbergtv/cms/conf/contentMgmt/searchFields.xml"
    "/opt/tandbergtv/cms/conf/contentMgmt/seriesidentifiers.properties"
    "/opt/tandbergtv/cms/conf/contentMgmt/SeriesSearchFieldNames.properties"
    "/opt/tandbergtv/cms/conf/contentMgmt/seriesSearchFields.xml"
    "/opt/tandbergtv/cms/conf/contentMgmt/ui.properties"
    "/opt/tandbergtv/cms/conf/contentMgmt/videoplayer.properties"
    "/opt/tandbergtv/cms/conf/monitoring/agent.properties"
    "/opt/tandbergtv/cms/conf/pmm/assettypes.txt"
    "/opt/tandbergtv/cms/conf/pmm/auth.xml"
    "/opt/tandbergtv/cms/conf/pmm/job.properties"
    "/opt/tandbergtv/cms/conf/pmm/pmm.properties"
    "/opt/tandbergtv/cms/conf/pmm/progress.xml"
    "/opt/tandbergtv/cms/conf/pmm/requiredFileFields.txt"
    "/opt/tandbergtv/cms/conf/pmm/search-page-config.xml"
    "/opt/tandbergtv/cms/conf/pmm/table-config.xml"
    "/opt/tandbergtv/cms/conf/pmm/ui.properties"
    "/opt/tandbergtv/cms/conf/rcs/ETV_EPG.xsd"
    "/opt/tandbergtv/cms/conf/rcs/properties/Config.properties"
    "/opt/tandbergtv/cms/conf/rcs/properties/SnmpSubAgent.properties"
    "/opt/tandbergtv/cms/conf/report/report-config.xml"
    "/opt/tandbergtv/cms/conf/scheduler/scheduler.properties"
    "/opt/tandbergtv/cms/conf/scheduler/ui.properties"
    "/opt/tandbergtv/cms/conf/services/ingest.properties"
    "/opt/tandbergtv/cms/conf/site/dist-templates.xml"
    "/opt/tandbergtv/cms/conf/site/MSOOverridables.dat"
    "/opt/tandbergtv/cms/conf/site/ui.properties"
    "/opt/tandbergtv/cms/conf/titleListMgmt/titleListMgmt.properties"
    "/opt/tandbergtv/cms/conf/tools/LinkName.properties"
    "/opt/tandbergtv/cms/conf/tools/links.xml"
    "/opt/tandbergtv/cms/conf/workflow/auth.xml"
    "/opt/tandbergtv/cms/conf/workflow/cluster.properties"
    "/opt/tandbergtv/cms/conf/workflow/report-config.xml"
    "/opt/tandbergtv/cms/conf/workflow/repositorybrowser-config.properties"
    "/opt/tandbergtv/cms/conf/workflow/search-page-config.xml"
    "/opt/tandbergtv/cms/conf/workflow/table-config.xml"
    "/opt/tandbergtv/cms/conf/workflow/ui.properties"
    "/opt/tandbergtv/cms/conf/workflow/url-config.xml"
    "/opt/tandbergtv/cms/conf/workflow/watchfolder.xml"
    "/opt/tandbergtv/cms/jboss/server/standard/deploy/adiserver.ear/adi.properties"
    "/opt/tandbergtv/cms/jboss/server/standard/deploy/adiserver.ear/fileURIConverter.properties"
    "/opt/tandbergtv/cms/jboss/server/standard/deploy/adiserver.ear/jacorb.properties"
    "/opt/tandbergtv/cms/jboss/server/standard/deploy/adiserver.ear/version.properties"
    "/opt/tandbergtv/cms/jboss/server/standard/deploy/mail-service.xml"
    "/opt/tandbergtv/cms/plugins/content/com.ericsson.metadata.series/resources/mapping.dat"
    "/opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/plugin.xml"
    "/opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/definition.xml"
    "/opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/ecmf.properties"
    "/opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/previewstylesheet.xsl"
    "/opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/series_definition.xml"
    "/opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/series_ecmf.properties"
    "/opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/tableconfiguration.xml"
    "/opt/tandbergtv/watchpoint/tomcat/webapps/filemanager/WEB-INF/classes/com/tandbergtv/workflow/webservice/filesubsystem/ftpconfiguration.txt"
    "/opt/tandbergtv/watchpoint/tomcat/webapps/filemanager/WEB-INF/classes/log4j.xml"
    "/opt/tandbergtv/watchpoint/tomcat/webapps/watchfolder/WEB-INF/classes/log4j.xml"
    "/opt/tandbergtv/watchpoint/tomcat/webapps/watchfolder/WEB-INF/classes/watchfolder.properties"
    "/opt/tandbergtv/watchpoint/tomcat/webapps/watchfolder/WEB-INF/classes/watchfolder.xml"
    "/usr/local/acsserver/scripts/AdiNameService"
    "/usr/local/n2bb/alerts/conf/AlertEmail.template"
    "/usr/local/n2bb/alerts/conf/jacorb.properties"
    "/usr/local/n2bb/conf/alerts_settings.conf"
    "/usr/local/platform/backup/bin/commonbackup_oracle_full_back.sh"
    "/usr/local/platform/backup/bin/commonbackup_oracle_inc_back.sh"
    "/usr/local/platform/backup/conf/cms/cms_directories.txt"
    "/usr/local/platform/backup/conf/cms/cms_files.txt"
    "/usr/local/platform/warmstandby/conf/warmstandby.cfg"
)

## Application Packages
                #cablelabs1_1 Excluded
APP_PACKAGES="  adi11-resourcetype
                aide
                alerts
                cablelabs-parser-resourcetype
                category-management-resourcetype
                cms-monitoring
                cms-userguide
                content-management-resourcetype
                content-trafficking-resourcetype
                contract-manager-resourcetype
                ffmpeg
                ffmpeg-resourcetype
                ffmpeg-webservice
                filemanager
                filesubsystem-resourcetype
                ftp
                glibc
                gtk2
                Helix
                human-resourcetype
                ImageMagick
                imagemagick-resourcetype
                imagemagick-webservice
                info-cms
                info-nobody
                info-platform
                info-sftpuser
                info-tstv
                jack-audio-connection-kit
                jboss
                jdk-cacerts-tstv-cfg
                libfaac0
                licensing-test
                mediawareeditcl
                mediaware-resourcetype
                metadata-enhancement-resourcetype
                path-converter-resourcetype
                RCS
                rpcbind
                rule-engine-resourcetype
                scac-tools
                site-manager-resourcetype
                sysprep
                tomcat
                utilities-resourcetype
                vcs-cfg
                vsftpd
                vsftpd-tstv-cfg
                warmstandby
                watchfolder
                watch-folder-resourcetype
                watchpoint-cms
                x264
                xportcombinerwebservice
                xportmanager
                xporttomcat
                xportverifier
                xport-verifier-resourcetype
                xportverifierwebservice"
                
## 3rd Party Packages 
ACC_PACKAGES="  VRTSamf
                VRTSatClient
                VRTSatServer
                VRTScps
                VRTSgab
                VRTSllt
                VRTSperl
                VRTSspt
                VRTSvcs
                VRTSvcsag
                VRTSvcsdr
                VRTSvcsea
                VRTSvcsm
                VRTSvlic
                VRTSvxfen"

## Base OS Packages installed as part of the Kickstart
BASE_PACKAGES=" @Core
                bc
                cmsstaging
                cms-systems-audit
                commonbackup
                dmidecode
                dos2unix
                eject
                file
                jdk
                man
                mutt
                net-snmp
                net-snmp-utils
                nfs-utils
                ntp
                sysstat
                system-config-network-tui
                tcpdump
                zip
                samba
                hpacucli
                bwm-ng"

#Service to stop
SERVICE=(   'alerts'
            'cms'
            'rmserver'
            'tomcat'
            'xportmanager'
            'xporttomcat'
            'RCSSchedulerService'
)

#Files that need to be removed
CLEANUP=(   '/jboss/server/standard/lib/commons-httpclient-3.0.1.jar'
            '/jboss/server/standard/lib/h2-1.2.124.jar'
            '/jboss/server/standard/lib/milyn-commons-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-edisax-parser-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-magger-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-scribe-core-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-scribe-hibernate-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-scribe-ibatis-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-scribe-jpa-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-smooks-calc-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-smooks-core-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-smooks-css-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-smooks-csv-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-smooks-edi-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-smooks-ejc-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-smooks-fixed-length-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-smooks-javabean-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-smooks-json-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-smooks-misc-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-smooks-persistence-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-smooks-routing-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-smooks-rules-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-smooks-scripting-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-smooks-templating-1.3.1.jar'
            '/jboss/server/standard/lib/milyn-smooks-validation-1.3.1.jar'
            '/jboss/server/standard/lib/opencsv-1.8.jar'
            '/jboss/server/standard/lib/persistence-api-1.0.jar'
            '/jboss/server/standard/lib/picketlink-bindings-1.0.3.final.jar'
            '/jboss/server/standard/lib/picketlink-bindings-jboss-1.0.3.final.jar'
            '/jboss/server/standard/lib/picketlink-fed-api-1.0.3.final.jar'
            '/jboss/server/standard/lib/picketlink-fed-core-1.0.3.final.jar'
            '/jboss/server/standard/lib/picketlink-fed-model-1.0.3.final.jar'
            '/jboss/server/standard/lib/picketlink-web-1.0.3.final.jar'
            '/jboss/server/standard/lib/picketlink-xmlsec-model-1.0.3.final.jar'
            '/jboss/server/standard/lib/stringtemplate-2.2.jar'
            '/jboss/server/standard/lib/xpp3_min-1.1.3.4.O.jar'
            '/jboss/server/standard/deploy/contract.war'
            '/jboss/server/standard/deploy/date.xsl'
            '/jboss/server/standard/deploy/ESBfile.esb'
            '/jboss/server/standard/deploy/ESBftp.esb'
            '/jboss/server/standard/deploy/ESBIngest.esb'
            '/jboss/server/standard/deploy/ESBxmltv.esb'
            '/jboss/server/standard/deploy/jbossesb.esb'
            '/jboss/server/standard/deploy/jbossesb-registry.sar'
            '/jboss/server/standard/deploy/jbossesb.sar'
            '/jboss/server/standard/deploy/jbpm.esb'
            '/jboss/server/standard/deploy/jbrules.esb'
            '/jboss/server/standard/deploy/properties-service.xml'
            '/jboss/server/standard/deploy/slsb.esb'
            '/jboss/server/standard/deploy/smooks.esb'
            '/jboss/server/standard/deploy/soap.esb'
            '/jboss/server/standard/deploy/soapui-client.sar'
            '/jboss/server/standard/deploy/spring.esb'
            '/jboss/server/standard/deployers/esb.deployer'
            '/workflow/lib/com.ericsson.cms.templates.jar'
            '/workflow/templates/Target Title.par'
)
