/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.common.AvailableConnectionsBase;
import oracle.ucp.common.UniversalConnectionPoolImpl;
import oracle.ucp.util.logging.UCPLoggerFactory;

public class AvailableConnectionsManyCollections
extends AvailableConnectionsBase {
    private static final Logger logger = UCPLoggerFactory.createLogger(AvailableConnectionsManyCollections.class.getCanonicalName());
    protected final Map<ConnectionRetrievalInfo, Collection<UniversalPooledConnection>> m_availableConnections = new HashMap<ConnectionRetrievalInfo, Collection<UniversalPooledConnection>>(256);
    protected int m_numAvailableConnections = 0;

    public AvailableConnectionsManyCollections(UniversalConnectionPoolImpl cp) throws UniversalConnectionPoolException {
        super(cp);
    }

    private Collection createAvailableConnectionsCollection(ConnectionRetrievalInfo connectionRequestInfo) {
        Collection connections = this.getConnectionPool().createCollection();
        this.m_availableConnections.put(connectionRequestInfo, connections);
        logger.finest("available connections collection created");
        return connections;
    }

    public synchronized Collection getAvailableConnections(ConnectionRetrievalInfo connectionRetrievalInfo) {
        Collection connections = this.m_availableConnections.get(connectionRetrievalInfo);
        if (connections == null) {
            connections = this.createAvailableConnectionsCollection(connectionRetrievalInfo);
        } else {
            logger.finest("available connections collection found");
        }
        return connections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAvailableConnection(UniversalPooledConnection connection) {
        ConnectionRetrievalInfo cri = connection.getConnectionRetrievalInfo();
        AvailableConnectionsManyCollections availableConnectionsManyCollections = this;
        synchronized (availableConnectionsManyCollections) {
            Collection connections = this.m_availableConnections.get(cri);
            if (connections == null) {
                connections = this.createAvailableConnectionsCollection(cri);
            }
            if (connections.add((UniversalPooledConnection)connection)) {
                ++this.m_numAvailableConnections;
                this.notifyAvailable(cri);
                logger.finest("available connection added");
            }
        }
    }

    public synchronized boolean removeAvailableConnection(UniversalPooledConnection connection) {
        Collection<UniversalPooledConnection> connections = this.m_availableConnections.get(connection.getConnectionRetrievalInfo());
        if (connections != null) {
            if (connections.remove(connection)) {
                --this.m_numAvailableConnections;
                logger.finest("available connection removed");
                return true;
            }
            logger.finest("available connection not removed");
        } else {
            logger.finest("available connections collection is empty");
        }
        return false;
    }

    public synchronized UniversalPooledConnection removeAvailableConnection(ConnectionRetrievalInfo cri) {
        Collection<UniversalPooledConnection> connections = this.m_availableConnections.get(cri);
        if (null == connections) {
            return null;
        }
        Iterator<UniversalPooledConnection> iter = connections.iterator();
        if (iter.hasNext()) {
            UniversalPooledConnection conn = iter.next();
            iter.remove();
            --this.m_numAvailableConnections;
            return conn;
        }
        return null;
    }

    public synchronized UniversalPooledConnection removeAvailableConnection() {
        UniversalPooledConnection conn = null;
        for (Collection<UniversalPooledConnection> conns : this.m_availableConnections.values()) {
            Iterator<UniversalPooledConnection> iter = conns.iterator();
            if (!iter.hasNext()) continue;
            conn = iter.next();
            iter.remove();
            --this.m_numAvailableConnections;
            break;
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllConnections() {
        int i;
        UniversalPooledConnection[] connsToClose;
        AvailableConnectionsManyCollections availableConnectionsManyCollections = this;
        synchronized (availableConnectionsManyCollections) {
            connsToClose = this.getAllAvailableConnections();
            for (i = 0; i < connsToClose.length; ++i) {
                this.removeAvailableConnection(connsToClose[i]);
            }
            this.m_numAvailableConnections = 0;
        }
        UniversalConnectionPoolImpl cp = this.getConnectionPool();
        for (i = 0; i < connsToClose.length; ++i) {
            cp.closePhysicalConnection(connsToClose[i].getPhysicalConnection());
        }
        logger.finest("all connections closed");
    }

    public synchronized int getNumAvailableConnections() {
        return this.m_numAvailableConnections;
    }

    public int getNumAvailableLabeledConnections() {
        return 0;
    }

    public synchronized UniversalPooledConnection[] getAllAvailableConnections() {
        UniversalPooledConnection[] connections = new UniversalPooledConnection[this.getNumAvailableConnections()];
        int i = 0;
        for (Collection<UniversalPooledConnection> conns : this.m_availableConnections.values()) {
            for (UniversalPooledConnection conn : conns) {
                connections[i++] = conn;
            }
        }
        logger.log(Level.FINEST, "available conections: {0}", connections.length);
        return connections;
    }
}

