/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ons.Notification;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.common.FailoverEventHandlerTaskBase;
import oracle.ucp.common.Failoverable;
import oracle.ucp.jdbc.oracle.ONSDatabaseFailoverEvent;
import oracle.ucp.jdbc.oracle.ONSOracleFailoverEventSubscriber;
import oracle.ucp.jdbc.oracle.OracleFailoverEventSubscriber;
import oracle.ucp.util.logging.UCPLoggerFactory;

class ONSDatabaseEventHandlerTask
extends FailoverEventHandlerTaskBase {
    private static final Logger logger = UCPLoggerFactory.createLogger(ONSDatabaseEventHandlerTask.class.getCanonicalName());
    private final OracleFailoverEventSubscriber m_onsSubscriber;
    private final boolean m_subscriberFailed;

    ONSDatabaseEventHandlerTask(Failoverable failoverableObject) throws UniversalConnectionPoolException {
        this(failoverableObject, null);
    }

    protected ONSDatabaseEventHandlerTask(Failoverable failoverableObject, OracleFailoverEventSubscriber subscriber) throws UniversalConnectionPoolException {
        super(failoverableObject);
        if (null == subscriber) {
            ONSOracleFailoverEventSubscriber s = new ONSOracleFailoverEventSubscriber();
            this.m_subscriberFailed = s.isFailed();
            this.m_onsSubscriber = s;
        } else {
            this.m_subscriberFailed = false;
            this.m_onsSubscriber = subscriber;
        }
    }

    public void run() {
        Notification event = null;
        boolean retrySubscription = false;
        if (!this.m_subscriberFailed) {
            while (!this.isTerminate()) {
                logger.finest("check for events");
                try {
                    event = this.m_onsSubscriber.receive();
                    if (event != null) {
                        ONSDatabaseFailoverEvent oracleFailoverEvent = new ONSDatabaseFailoverEvent(event.type(), event.body());
                        this.handleEvent(oracleFailoverEvent);
                        logger.log(Level.FINE, "event triggered: {0}", ((Object)oracleFailoverEvent).toString());
                    } else {
                        logger.finest("received null event");
                    }
                }
                catch (UniversalConnectionPoolException ucpEx) {
                    logger.log(Level.FINEST, "run", ucpEx);
                    retrySubscription = true;
                }
                if (!retrySubscription) continue;
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    logger.finest("sleep interrupted");
                }
                retrySubscription = false;
            }
        } else {
            logger.finest("ONS subscriber failed");
        }
    }

    public void setTerminate(boolean terminate) {
        logger.log(Level.FINEST, "terminate: {0}", terminate);
        super.setTerminate(terminate);
        if (terminate) {
            this.m_onsSubscriber.close();
        }
    }
}

