/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.sql.Connection;
import java.util.logging.Logger;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionPool;
import oracle.ucp.util.logging.UCPLoggerFactory;

public class OracleConnectionConnectionPool
extends OracleJDBCConnectionPool {
    private static final Logger logger = UCPLoggerFactory.createLogger(OracleConnectionConnectionPool.class.getCanonicalName());

    public OracleConnectionConnectionPool(JDBCConnectionFactoryAdapter connectionFactoryAdapter) throws UniversalConnectionPoolException {
        super(connectionFactoryAdapter);
    }

    public Connection getConnection(JDBCConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        Connection conn = (Connection)this.borrowConnection(connectionRetrievalInfo).getPhysicalConnection();
        logger.finest("connection borrowed succesfully");
        return conn;
    }

    public boolean returnConnection(Connection connection) throws UniversalConnectionPoolException {
        boolean res = this.returnUsedPhysicalConnection(connection);
        logger.finest("connection returned succesfully");
        return res;
    }

    public boolean closeConnection(Connection connection) throws UniversalConnectionPoolException {
        boolean res = this.closeUsedPhysicalConnection(connection);
        logger.finest("connection closed succesfully");
        return res;
    }
}

