/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ucp.util.logging.UCPLoggerFactory;

class OracleDatabaseInstanceInfo {
    private static final Logger logger = UCPLoggerFactory.createLogger(OracleDatabaseInstanceInfo.class.getCanonicalName());
    static final int STATUS_UP = 1;
    static final int STATUS_DOWN = 2;
    String databaseUniqName = null;
    String instanceName = null;
    String serviceName = null;
    String hostName = null;
    int percent = 0;
    int flag = 2;
    int attemptedConnRequestCount = 0;
    int numberOfConnectionsCount = 0;
    int status = 1;
    int numToTearDown = -1;
    String namedInstanceUrl = null;
    int numNamedInstanceConns = 0;
    int id = -1;
    String m_equalKey;
    final String m_hashKey;
    private final int m_hashCode;

    OracleDatabaseInstanceInfo(String dbUniqNameKey, String instNameKey) {
        this(dbUniqNameKey, instNameKey, null);
    }

    OracleDatabaseInstanceInfo(String dbUniqNameKey, String instNameKey, String hostNameKey) {
        logger.log(Level.FINEST, "DbUniqNameKey: {0}, InstNameKey: {1}, HostNameKey: {2}", new Object[]{dbUniqNameKey, instNameKey, hostNameKey});
        this.databaseUniqName = dbUniqNameKey;
        this.instanceName = instNameKey;
        this.hostName = hostNameKey;
        StringBuffer sbuf = new StringBuffer(128);
        sbuf.append(this.instanceName == null ? "" : this.instanceName).append("##").append(this.databaseUniqName == null ? "" : this.databaseUniqName);
        this.m_hashKey = sbuf.toString();
        this.m_hashCode = this.m_hashKey.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OracleDatabaseInstanceInfo)) {
            return false;
        }
        OracleDatabaseInstanceInfo other = (OracleDatabaseInstanceInfo)obj;
        String key = this.m_hashKey == null ? "" : this.m_hashKey;
        String okey = other.m_hashKey == null ? "" : other.m_hashKey;
        return key.equals(okey);
    }

    public int hashCode() {
        return this.m_hashCode;
    }

    public String toString() {
        return "Database unique name: " + this.databaseUniqName + ", Instance name: " + this.instanceName + ", Service name: " + this.serviceName + ", Host name: " + this.hostName + ", Instance id: " + this.id + ", percent: " + this.percent + ", Flag: " + this.flag + ", Attempted connection request count: " + this.attemptedConnRequestCount + ", Connection count: " + this.numberOfConnectionsCount + ", Status: " + (this.status == 1 ? "UP" : "DOWN");
    }
}

