/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.oracle.FailoverablePooledConnection;
import oracle.ucp.jdbc.oracle.OracleDatabaseInstanceInfo;
import oracle.ucp.jdbc.oracle.RACCallback;
import oracle.ucp.jdbc.oracle.RACInstanceImpl;
import oracle.ucp.jdbc.oracle.RACManagerImpl;
import oracle.ucp.util.Util;
import oracle.ucp.util.logging.UCPLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OracleDatabaseInstanceInfoList {
    private static final Logger logger = UCPLoggerFactory.createLogger(OracleDatabaseInstanceInfoList.class.getCanonicalName());
    private static final int MAX_RAC_INSTANCE_CARDINALITY = 128;
    private final Vector<OracleDatabaseInstanceInfo> m_racMetadata = new Vector(128, 0);
    private final Hashtable<OracleDatabaseInstanceInfo, Integer> m_instToIdMap = new Hashtable(128, 0.25f);
    private int m_dbInstancePercentTotal = 0;
    private final RACManagerImpl m_racMngr;
    private final Random m_rand = new Random(0L);
    private boolean m_useGoodGroup = false;
    private static final String CONNECT_DATA_KEYWORD = "CONNECT_DATA";

    OracleDatabaseInstanceInfoList() {
        this(null);
    }

    OracleDatabaseInstanceInfoList(RACManagerImpl racMngr) {
        this.m_racMngr = racMngr;
        for (int i = 0; i < 128; ++i) {
            this.m_racMetadata.addElement(null);
        }
    }

    protected void updateDatabaseInstanceInfo(OracleDatabaseInstanceInfo dbInfo, boolean isForFailover, boolean isAddingConnection) {
        int instId;
        Integer instNum = this.m_instToIdMap.get(dbInfo);
        int n = instId = instNum != null ? instNum : -1;
        if (isForFailover) {
            if (instId != -1) {
                if (isAddingConnection && instId != dbInfo.id) {
                    logger.log(Level.FINEST, "name->id mapping out-of-sync, instance={0}, id={1}, id-in-table={2}", new Object[]{dbInfo.instanceName, dbInfo.id, instId});
                    return;
                }
                OracleDatabaseInstanceInfo dbInstance = this.m_racMetadata.get(instId);
                if (isAddingConnection) {
                    ++dbInstance.numberOfConnectionsCount;
                    if (dbInstance.status == 2) {
                        dbInstance.status = 1;
                    }
                } else if (dbInstance.numberOfConnectionsCount > 0) {
                    --dbInstance.numberOfConnectionsCount;
                }
            } else {
                ++dbInfo.numberOfConnectionsCount;
                this.setNamedInstanceUrl(dbInfo, dbInfo.instanceName);
                dbInfo.status = 1;
                if (dbInfo.id >= 0) {
                    this.m_instToIdMap.put(dbInfo, dbInfo.id);
                    this.m_racMetadata.set(dbInfo.id, dbInfo);
                }
            }
        } else if (instId >= 0) {
            OracleDatabaseInstanceInfo dbInstance = this.m_racMetadata.get(instId);
            dbInstance.percent = dbInfo.percent;
            dbInstance.flag = dbInfo.flag;
        }
    }

    private void setNamedInstanceUrl(OracleDatabaseInstanceInfo dbInfo, String instanceName) {
        StringBuffer urlBuf = new StringBuffer(this.m_racMngr.getRACCallback().getUrl());
        int keywordIndex = urlBuf.indexOf(CONNECT_DATA_KEYWORD);
        if (keywordIndex == -1) {
            dbInfo.namedInstanceUrl = null;
            logger.finest("connect data keyword not found");
        } else {
            int equalSignIndex = urlBuf.indexOf("=", keywordIndex + CONNECT_DATA_KEYWORD.length());
            if (equalSignIndex == -1) {
                dbInfo.namedInstanceUrl = null;
                logger.finest("equal sign was not found");
            } else {
                urlBuf.insert(equalSignIndex + 1, "(INSTANCE_NAME=" + instanceName + ")");
                dbInfo.namedInstanceUrl = urlBuf.toString();
            }
        }
        logger.log(Level.FINEST, "instance={0}, namedInstanceUrl={1}", new Object[]{dbInfo.instanceName, urlBuf.toString()});
    }

    String getNamedInstanceUrl(String instanceName, String dbUniqName) {
        OracleDatabaseInstanceInfo dbInstance = this.getOracleDatabaseInstanceInfo(instanceName, dbUniqName);
        if (dbInstance != null) {
            return dbInstance.namedInstanceUrl;
        }
        return null;
    }

    boolean isNamedInstanceConnectingAllowed(String instanceName, String dbUniqName, boolean isInstanceAffinityEnabled) {
        RACCallback cbk = this.m_racMngr.getRACCallback();
        int upCount = this.getUpInstancesCount();
        OracleDatabaseInstanceInfo tmpInstance = new OracleDatabaseInstanceInfo(dbUniqName, instanceName);
        OracleDatabaseInstanceInfo dbInstance = this.m_racMetadata.get(this.m_instToIdMap.get(tmpInstance));
        if (dbInstance.status == 1 && dbInstance.flag <= 3) {
            int dbVersion = this.m_racMngr.getDatabaseVersion();
            int connNumThreshold = -1;
            if (dbVersion >= 11100 || !isInstanceAffinityEnabled) {
                int DEFAULT_MAX_POOL_SIZE = Integer.MAX_VALUE;
                connNumThreshold = cbk.getMaxPoolSize() < DEFAULT_MAX_POOL_SIZE ? Math.round(0.001f * (float)dbInstance.percent * (float)cbk.getRoomToGrowPool()) + dbInstance.numNamedInstanceConns : Math.round(0.1f * (float)dbInstance.numberOfConnectionsCount);
            } else {
                connNumThreshold = cbk.getRoomToGrowPool() + dbInstance.numNamedInstanceConns;
            }
            logger.log(Level.FINEST, "dbVersion={0}, threshold={1}, connNum={2}", new Object[]{dbVersion, connNumThreshold, dbInstance.numNamedInstanceConns});
            return connNumThreshold > dbInstance.numNamedInstanceConns;
        }
        return false;
    }

    protected int size() {
        return this.m_racMetadata.size();
    }

    protected FailoverablePooledConnection selectConnectionPerRLBMetrics(ConnectionRetrievalInfo cri, RACManagerImpl racMngr) throws UniversalConnectionPoolException {
        int violatingFactor;
        assert (racMngr != null);
        FailoverablePooledConnection pc = null;
        int numInstances = this.m_racMetadata.size();
        boolean[] tried = new boolean[numInstances];
        int violatingInstCount = this.getViolatingInstancesCount();
        int n = violatingFactor = violatingInstCount != 0 ? this.getUpInstancesCount() / violatingInstCount : Integer.MAX_VALUE;
        if (this.m_useGoodGroup && numInstances > 0) {
            int total = this.m_dbInstancePercentTotal;
            block0: for (int j = 0; j < numInstances; ++j) {
                int percentSum = 0;
                int i = 0;
                int randomPercent = total <= 1 ? 0 : this.m_rand.nextInt(total - 1);
                for (OracleDatabaseInstanceInfo dbInstance : this.m_racMetadata) {
                    if (dbInstance == null) {
                        tried[i] = true;
                        ++i;
                        continue;
                    }
                    if (!tried[i] && dbInstance.flag <= 3) {
                        if (dbInstance.flag == 3 && violatingFactor > 2) {
                            tried[i] = true;
                            ++i;
                            continue;
                        }
                        logger.log(Level.FINE, "randomPercent={0}, percentSum={1}", new Object[]{randomPercent, percentSum += dbInstance.percent});
                        if (randomPercent <= percentSum) {
                            if (j == 0) {
                                ++dbInstance.attemptedConnRequestCount;
                            }
                            RACInstanceImpl racInstance = new RACInstanceImpl(dbInstance);
                            pc = racMngr.getRACCallback().getAvailableConnectionToInstance(cri, racInstance);
                            if (pc != null) break block0;
                            total -= dbInstance.percent;
                            tried[i] = true;
                            continue block0;
                        }
                    }
                    ++i;
                }
            }
            if (pc != null) {
                racMngr.incrementSuccessfulRCLBBasedBorrowCount();
            } else {
                racMngr.incrementFailedRCLBBasedBorrowCount();
            }
        }
        return pc;
    }

    protected void processDatabaseInstanceList(BlockingQueue<OracleDatabaseInstanceInfo> instancesToRetireQueue, AtomicInteger countTotal) {
        int numInstances;
        assert (instancesToRetireQueue != null);
        assert (countTotal != null);
        int goodGroupSum = 0;
        this.m_useGoodGroup = false;
        for (OracleDatabaseInstanceInfo dbInstance : this.m_racMetadata) {
            if (dbInstance == null) continue;
            if (dbInstance.flag <= 3) {
                goodGroupSum += dbInstance.percent;
            }
            logger.log(Level.FINE, "instanceName: {0}, numberOfConnectionsCount: {1}, attemptedConnRequestCount: {2}", new Object[]{dbInstance.instanceName, dbInstance.numberOfConnectionsCount, dbInstance.attemptedConnRequestCount});
        }
        if (goodGroupSum > 0) {
            this.m_dbInstancePercentTotal = goodGroupSum;
            this.m_useGoodGroup = true;
        }
        if ((numInstances = this.m_racMetadata.size()) > 1) {
            for (OracleDatabaseInstanceInfo dbInstance : this.m_racMetadata) {
                if (dbInstance == null) continue;
                countTotal.addAndGet(dbInstance.attemptedConnRequestCount);
            }
            int ct = countTotal.get();
            if (ct > numInstances * 1000) {
                boolean resetDBInstanceValues = false;
                for (OracleDatabaseInstanceInfo dbInstance : this.m_racMetadata) {
                    if (dbInstance == null) continue;
                    float ACRRatio = (float)dbInstance.attemptedConnRequestCount / (float)ct;
                    float connRatio = (float)dbInstance.numberOfConnectionsCount / (float)this.m_racMngr.getRACCallback().getTotalConnectionsCount();
                    logger.log(Level.FINE, "m_countTotal: {0}, numInstances: {1}, instanceName: {2}, ACRRatio: {3}, connRatio: {4} ", new Object[]{ct, numInstances, dbInstance.instanceName, Float.valueOf(ACRRatio), Float.valueOf(connRatio)});
                    if (!(connRatio > ACRRatio * 2.0f)) continue;
                    logger.log(Level.FINE, "serviceName: {0},instanceName: {1},ACRRatio: {2},connRatio: {3}", new Object[]{dbInstance.serviceName, dbInstance.instanceName, Float.valueOf(ACRRatio), Float.valueOf(connRatio)});
                    if ((int)((double)dbInstance.numberOfConnectionsCount * 0.25) >= 1) {
                        instancesToRetireQueue.add(dbInstance);
                    }
                    resetDBInstanceValues = true;
                }
                if (resetDBInstanceValues) {
                    for (OracleDatabaseInstanceInfo dbInstance : this.m_racMetadata) {
                        if (dbInstance == null) continue;
                        dbInstance.attemptedConnRequestCount = 0;
                    }
                    resetDBInstanceValues = false;
                }
            }
        }
    }

    protected void removeAll() {
        this.m_racMetadata.clear();
        for (int i = 0; i < 128; ++i) {
            this.m_racMetadata.addElement(null);
        }
        this.m_instToIdMap.clear();
    }

    protected boolean useGoodGroup() {
        return this.m_useGoodGroup;
    }

    private FailoverablePooledConnection getConnectionToNamedInstance(OracleDatabaseInstanceInfo dbInstance, boolean forQueryInstanceId) {
        FailoverablePooledConnection fpc = null;
        String namedInstanceUrl = dbInstance.namedInstanceUrl;
        if (dbInstance.namedInstanceUrl != null) {
            try {
                RACInstanceImpl racInstance = new RACInstanceImpl(dbInstance);
                fpc = this.m_racMngr.getRACCallback().openNewConnection(namedInstanceUrl, racInstance);
            }
            catch (Exception exc) {
                fpc = null;
                logger.throwing(this.getClass().getName(), "call to openNewConnection failed: ", exc);
            }
            if (fpc != null) {
                fpc.setAsNamedInstanceConnection();
                if (!forQueryInstanceId) {
                    ++dbInstance.numNamedInstanceConns;
                }
            }
        } else {
            logger.log(Level.FINEST, "URL invalid for connecting to named instance");
        }
        return fpc;
    }

    protected void markUpInstanceForUpEvent(String upServiceName, String upInstanceName, String upHostName, String upDbName) {
        int upInstId;
        OracleDatabaseInstanceInfo upInstance = new OracleDatabaseInstanceInfo(upDbName, upInstanceName, upHostName);
        upInstance.serviceName = upServiceName;
        Integer instNum = this.m_instToIdMap.get(upInstance);
        int n = upInstId = instNum != null ? instNum : -1;
        if (upInstId != -1) {
            upInstance = this.m_racMetadata.get(upInstId);
            upInstance.status = 1;
        } else {
            this.setNamedInstanceUrl(upInstance, upInstance.instanceName);
            upInstance.status = 1;
            FailoverablePooledConnection namedInstanceConn = this.getConnectionToNamedInstance(upInstance, true);
            if (null != namedInstanceConn) {
                int newInstanceId = namedInstanceConn.getInstanceNumber();
                if (newInstanceId >= 0) {
                    this.m_instToIdMap.put(upInstance, newInstanceId);
                    this.m_racMetadata.set(newInstanceId, upInstance);
                }
                try {
                    namedInstanceConn.close(false);
                }
                catch (UniversalConnectionPoolException exc) {
                    logger.log(Level.FINEST, "closing connection failed", exc);
                }
            } else {
                logger.finest("namedInstanceConn is null");
            }
        }
    }

    protected void markDownInstanceForServiceDownEvent(String downInstanceName, String downDbName) {
        for (OracleDatabaseInstanceInfo dbInstance : this.m_racMetadata) {
            if (dbInstance == null) continue;
            if (downInstanceName == null) {
                dbInstance.status = 2;
                continue;
            }
            if (!Util.sameOrEqual(downDbName, dbInstance.databaseUniqName) || !Util.sameOrEqual(downInstanceName, dbInstance.instanceName)) continue;
            dbInstance.status = 2;
        }
    }

    protected void markDownInstanceForHostDownEvent(String downHostName) {
        for (OracleDatabaseInstanceInfo dbInstance : this.m_racMetadata) {
            if (dbInstance == null || !Util.sameOrEqual(dbInstance.hostName, dbInstance.hostName)) continue;
            dbInstance.status = 2;
        }
    }

    protected int getUpInstancesCount() {
        int upCount = 0;
        for (OracleDatabaseInstanceInfo dbInstance : this.m_racMetadata) {
            if (dbInstance == null || dbInstance.status != 1) continue;
            ++upCount;
        }
        return upCount;
    }

    int getViolatingInstancesCount() {
        int violatingCount = 0;
        for (OracleDatabaseInstanceInfo dbInstance : this.m_racMetadata) {
            if (dbInstance == null || dbInstance.status != 1 || dbInstance.flag != 3) continue;
            ++violatingCount;
        }
        return violatingCount;
    }

    OracleDatabaseInstanceInfo getOracleDatabaseInstanceInfo(String instanceName, String dbName) {
        OracleDatabaseInstanceInfo tmpInstance = new OracleDatabaseInstanceInfo(dbName, instanceName);
        return this.m_racMetadata.get(this.m_instToIdMap.get(tmpInstance));
    }

    OracleDatabaseInstanceInfo getOracleDatabaseInstanceInfo(int instanceId) {
        return this.m_racMetadata.get(instanceId);
    }

    INSTANCE_CATEGORY_FOR_DATA_AFFINITY getInstanceCategory(OracleDatabaseInstanceInfo dbInstance) {
        String instanceKey = this.m_racMngr.generateDatabaseInstanceKey(dbInstance.instanceName, dbInstance.databaseUniqName, dbInstance.serviceName);
        boolean affinityHint = this.m_racMngr.getConnectionAffinityValue(instanceKey);
        if (dbInstance.status == 1 && (dbInstance.flag == 1 || dbInstance.flag == 2) && affinityHint) {
            return INSTANCE_CATEGORY_FOR_DATA_AFFINITY.GOOD_INSTANCE;
        }
        if (!(dbInstance.status != 1 || dbInstance.flag != 3 && affinityHint)) {
            return INSTANCE_CATEGORY_FOR_DATA_AFFINITY.VIOLATING_INSTANCE;
        }
        return INSTANCE_CATEGORY_FOR_DATA_AFFINITY.BAD_INSTANCE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum INSTANCE_CATEGORY_FOR_DATA_AFFINITY {
        GOOD_INSTANCE,
        VIOLATING_INSTANCE,
        BAD_INSTANCE;

    }
}

