/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.oracle.OracleFailoverEvent;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.logging.UCPLoggerFactory;

public class OracleFailoverEventImpl
implements OracleFailoverEvent {
    private static final Logger logger = UCPLoggerFactory.createLogger(OracleFailoverEventImpl.class.getCanonicalName());
    private String m_serviceName = null;
    private String m_instanceName = null;
    private String m_dbUniqueName = null;
    private String m_hostName = null;
    private String m_status = null;
    private int m_cardinality = 0;
    private String m_reason = null;
    private String m_eventType;

    public OracleFailoverEventImpl(String eventType) throws UniversalConnectionPoolException {
        this.setEventType(eventType);
    }

    private void validateEventType(String eventType) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "eventType: {0}", eventType);
        if (eventType == null) {
            UniversalConnectionPoolException ucpe = UCPErrorHandler.newUniversalConnectionPoolException(304);
            logger.throwing(this.getClass().getName(), "validateEventType", ucpe);
            throw ucpe;
        }
        if (!eventType.equals("database/event/host") && !eventType.equals("database/event/service")) {
            UniversalConnectionPoolException ucpe = UCPErrorHandler.newUniversalConnectionPoolException(305);
            logger.throwing(this.getClass().getName(), "validateEventType", ucpe);
            throw ucpe;
        }
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    public void setServiceName(String serviceName) {
        logger.log(Level.FINEST, "serviceName: {0}", serviceName);
        this.m_serviceName = serviceName;
    }

    public String getInstanceName() {
        return this.m_instanceName;
    }

    public void setInstanceName(String instanceName) {
        logger.log(Level.FINEST, "instanceName: {0}", instanceName);
        this.m_instanceName = instanceName;
    }

    public String getDbUniqueName() {
        return this.m_dbUniqueName;
    }

    public void setDbUniqueName(String dbUniqueName) {
        logger.log(Level.FINEST, "dbUniqueName: {0}", dbUniqueName);
        this.m_dbUniqueName = dbUniqueName;
    }

    public String getHostName() {
        return this.m_hostName;
    }

    public void setHostName(String hostName) {
        logger.log(Level.FINEST, "hostName: {0}", hostName);
        this.m_hostName = hostName;
    }

    public String getStatus() {
        return this.m_status;
    }

    public void setStatus(String status) {
        logger.log(Level.FINEST, "status: {0}", status);
        this.m_status = status;
    }

    public int getCardinality() {
        return this.m_cardinality;
    }

    public void setCardinality(int cardinality) {
        logger.log(Level.FINEST, "cardinality: {0}", cardinality);
        this.m_cardinality = cardinality;
    }

    public String getReason() {
        return this.m_reason;
    }

    public void setReason(String reason) {
        logger.log(Level.FINEST, "reason: {0}", reason);
        this.m_reason = reason;
    }

    public String getEventType() {
        return this.m_eventType;
    }

    public void setEventType(String eventType) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "eventType: {0}", eventType);
        this.validateEventType(eventType);
        this.m_eventType = eventType;
    }

    public String toString() {
        return "Service name: " + this.m_serviceName + ", Instance name: " + this.m_instanceName + ", Unique name: " + this.m_dbUniqueName + ", Host name: " + this.m_hostName + ", Status: " + this.m_status + ", Cardinality: " + this.m_cardinality + ", Reason: " + this.m_reason + ", Event type: " + this.m_eventType;
    }
}

