/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.JDBCUniversalPooledConnection;
import oracle.ucp.jdbc.oracle.FailoverablePooledConnection;
import oracle.ucp.jdbc.oracle.FailoverablePooledConnectionHelper;
import oracle.ucp.jdbc.oracle.OracleFailoverablePooledConnection;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.logging.UCPLoggerFactory;

public class OracleUniversalPooledConnection
extends JDBCUniversalPooledConnection
implements OracleFailoverablePooledConnection,
FailoverablePooledConnection {
    private static final Logger logger = UCPLoggerFactory.createLogger(OracleUniversalPooledConnection.class.getCanonicalName());
    private String m_dataSourceInstanceName;
    private String m_dbUniqueName;
    private String m_hostName;
    private String m_serviceName;
    private int m_instanceId = -1;
    private JDBCConnectionPool m_cp = null;
    private boolean m_isNamedInstanceConn = false;
    private static final Map<Class, InvocationVector> oracleConnCache = Collections.synchronizedMap(new HashMap());

    public OracleUniversalPooledConnection(JDBCConnectionPool connectionPool, Object connection, ConnectionRetrievalInfo connectionRetrievalInfo, boolean connectionFailoverEnabled) throws UniversalConnectionPoolException {
        super(connectionPool, connection, connectionRetrievalInfo, connectionFailoverEnabled);
        logger.log(Level.FINEST, "connectionFailoverEnabled: {0}", connectionFailoverEnabled);
        this.m_cp = connectionPool;
        this.m_isNamedInstanceConn = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void validate() {
        logger.finest("validating connection");
        boolean valid = false;
        try {
            block10: {
                try {
                    Connection conn = this.getSQLConnection(this.getPhysicalConnection());
                    if (null == conn || !(valid = FailoverablePooledConnectionHelper.isUsableOnOracleConnection(conn))) break block10;
                    if (null == this.m_cp.getSQLForValidateConnection()) {
                        valid = FailoverablePooledConnectionHelper.pingDatabaseOnOracleConnection(conn);
                    } else {
                        logger.log(Level.FINEST, "Using SQL command to validate");
                        super.validate();
                    }
                }
                catch (Exception e) {
                    valid = false;
                    Object var4_5 = null;
                    if (valid) {
                        logger.finest("connection is good");
                        return;
                    }
                    this.setStatus(UniversalPooledConnectionStatus.STATUS_BAD, "connection is bad");
                    return;
                }
            }
            Object var4_4 = null;
            if (valid) {
                logger.finest("connection is good");
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (valid) {
                logger.finest("connection is good");
                throw throwable;
            }
            this.setStatus(UniversalPooledConnectionStatus.STATUS_BAD, "connection is bad");
            throw throwable;
        }
        this.setStatus(UniversalPooledConnectionStatus.STATUS_BAD, "connection is bad");
    }

    protected void initFailoverParameters() throws UniversalConnectionPoolException {
        Connection oracleConn = null;
        try {
            oracleConn = this.getSQLConnection(this.getPhysicalConnection());
        }
        catch (Exception e) {
            UCPErrorHandler.throwUniversalConnectionPoolException(301, e);
        }
        Properties prop = FailoverablePooledConnectionHelper.getSessionInfoOnOracleConnection(oracleConn);
        String val = prop.getProperty("INSTANCE_NAME");
        if (val != null) {
            this.setDataSourceInstanceName(val.trim().toLowerCase());
        }
        if ((val = prop.getProperty("SERVER_HOST")) != null) {
            this.setHostName(val.trim().toLowerCase());
        }
        if ((val = prop.getProperty("SERVICE_NAME")) != null) {
            this.setServiceName(val.trim().toLowerCase());
        }
        if ((val = prop.getProperty("DATABASE_NAME")) != null) {
            this.setDbUniqueName(val.trim().toLowerCase());
        }
        logger.log(Level.FINEST, "Oracle Universal Pooled Connection: {0}", this.toString());
    }

    public int getInstanceNumber() {
        if (this.m_instanceId >= 0) {
            return this.m_instanceId;
        }
        try {
            Connection oconn = this.getSQLConnection(this.getPhysicalConnection());
            if (oconn != null) {
                this.m_instanceId = FailoverablePooledConnectionHelper.getInstanceNumber(oconn);
                return this.m_instanceId;
            }
        }
        catch (Exception exc) {
            logger.log(Level.FINEST, "getSQLConnection: ", exc);
            Object oconn = null;
        }
        return -1;
    }

    public String getDataSourceInstanceName() {
        return this.m_dataSourceInstanceName;
    }

    public void setDataSourceInstanceName(String dataSourceInstanceName) {
        logger.log(Level.FINEST, "dataSourceInstanceName: {0}", dataSourceInstanceName);
        this.m_dataSourceInstanceName = dataSourceInstanceName;
    }

    public String getDbUniqueName() {
        return this.m_dbUniqueName;
    }

    public void setDbUniqueName(String dbUniqueName) {
        logger.log(Level.FINEST, "dbUniqueName: {0}", dbUniqueName);
        this.m_dbUniqueName = dbUniqueName;
    }

    public String getHostName() {
        return this.m_hostName;
    }

    public void setHostName(String hostName) {
        logger.log(Level.FINEST, "hostName: {0}", hostName);
        this.m_hostName = hostName;
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    public void setServiceName(String serviceName) {
        logger.log(Level.FINEST, "serviceName: {0}", serviceName);
        this.m_serviceName = serviceName;
    }

    void handleTimeout() throws UniversalConnectionPoolException {
        try {
            Connection oconn = this.getSQLConnection(this.getPhysicalConnection());
            FailoverablePooledConnectionHelper.cancelOnOracleConnection(oconn);
            if (!oconn.getAutoCommit() && this.getStatus() == UniversalPooledConnectionStatus.STATUS_NORMAL) {
                oconn.rollback();
            }
        }
        catch (Exception exc) {
            logger.log(Level.FINEST, "cleaning up connection", exc);
        }
    }

    public synchronized void setMaxStatements(int maxStatements) throws SQLException {
        logger.log(Level.FINEST, "maxStatements: {0}", maxStatements);
        Connection oconn = null;
        try {
            oconn = this.getSQLConnection(this.getPhysicalConnection());
        }
        catch (Exception exc) {
            logger.log(Level.FINEST, "getSQLConnection: ", exc);
            oconn = null;
        }
        if (this.getMaxStatements() != maxStatements) {
            if (maxStatements > 0) {
                FailoverablePooledConnectionHelper.enableStatementPooling(oconn, maxStatements);
            } else {
                FailoverablePooledConnectionHelper.disableStatementPooling(oconn);
            }
        }
        super.setMaxStatements(maxStatements);
    }

    protected void abortOracleConnection(Connection oconn) {
        logger.log(Level.FINEST, "aborting connection: {0}", oconn);
        if (oconn == null) {
            return;
        }
        try {
            this.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
            FailoverablePooledConnectionHelper.abortOracleConnection(oconn);
        }
        catch (Exception e) {
            logger.log(Level.FINEST, "caught {0}", new Object[]{e});
        }
    }

    protected InvocationVector getInvocationVector(Connection oracleConn) {
        Class<?> connClass = oracleConn.getClass();
        InvocationVector vector = oracleConnCache.get(connClass);
        if (null != vector) {
            return vector;
        }
        Class<?> c = null;
        try {
            c = Class.forName("oracle.jdbc.internal.OracleConnection", true, connClass.getClassLoader());
        }
        catch (Exception e) {
            logger.log(Level.FINEST, "caught {0}", new Object[]{e});
        }
        final Class<?> cls = c;
        vector = new InvocationVector(){
            private final Method abort = this.getMethod("abort");
            private final Method cancel = this.getMethod("cancel");
            private final Method isUsable = this.getMethod("isUsable");
            private final Method setStatementCacheSize = this.getMethod("setStatementCacheSize", Integer.TYPE);
            private final Method setImplicitCachingEnabled = this.getMethod("setImplicitCachingEnabled", Boolean.TYPE);
            private final Method setExplicitCachingEnabled = this.getMethod("setExplicitCachingEnabled", Boolean.TYPE);
            private final Method getServerSessionInfo = this.getMethod("getServerSessionInfo");
            private final Method pingDatabase = this.getMethod("pingDatabase");
            private final Method pingDatabaseInt = this.getMethod("pingDatabase", Integer.TYPE);
            private final Method getVersionNumber = this.getMethod("getVersionNumber");

            private Method getMethod(String method, Class type) {
                if (null != cls) {
                    try {
                        return cls.getMethod(method, type);
                    }
                    catch (NoSuchMethodException e) {
                        logger.log(Level.FINEST, "caught {0}", new Object[]{e});
                        return null;
                    }
                }
                return null;
            }

            private Method getMethod(String method) {
                if (null != cls) {
                    try {
                        return cls.getMethod(method, new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        logger.log(Level.FINEST, "caught {0}", new Object[]{e});
                        return null;
                    }
                }
                return null;
            }

            public Class getConnClass() {
                return cls;
            }

            public Method getMethodAbort() {
                return this.abort;
            }

            public Method getMethodCancel() {
                return this.cancel;
            }

            public Method getMethodIsUsable() {
                return this.isUsable;
            }

            public Method getMethodSetStatementCacheSize() {
                return this.setStatementCacheSize;
            }

            public Method getMethodSetImplicitCachingEnabled() {
                return this.setImplicitCachingEnabled;
            }

            public Method getMethodSetExplicitCachingEnabled() {
                return this.setExplicitCachingEnabled;
            }

            public Method getMethodGetServerSessionInfo() {
                return this.getServerSessionInfo;
            }

            public Method getMethodPingDatabase() {
                return this.pingDatabase;
            }

            public Method getMethodPingDatabaseInt() {
                return this.pingDatabaseInt;
            }

            public Method getMethodGetVersionNumber() {
                return this.getVersionNumber;
            }
        };
        oracleConnCache.put(connClass, vector);
        return vector;
    }

    protected void abortPhysicalConnection() throws UniversalConnectionPoolException {
        Connection oconn = null;
        try {
            oconn = this.getSQLConnection(this.getPhysicalConnection());
        }
        catch (Exception exc) {
            logger.log(Level.FINEST, "getSQLConnection before abort: ", exc);
            oconn = null;
        }
        FailoverablePooledConnectionHelper.abortOracleConnection(oconn);
    }

    public int getDatabaseVersion() throws UniversalConnectionPoolException {
        int dbVersion = 0;
        try {
            Connection oconn = this.getSQLConnection(this.getPhysicalConnection());
            return FailoverablePooledConnectionHelper.getDatabaseVersion(oconn);
        }
        catch (Exception exc) {
            dbVersion = 0;
            logger.log(Level.FINEST, "getting db version from connection", exc);
            return dbVersion;
        }
    }

    public boolean isNamedInstanceConnection() {
        return this.m_isNamedInstanceConn;
    }

    public void setAsNamedInstanceConnection() {
        this.m_isNamedInstanceConn = true;
    }

    public String toString() {
        return new StringBuilder(1024).append("Instance Name: ").append(this.m_dataSourceInstanceName).append(", ").append("DBUniq Name: ").append(this.m_dbUniqueName).append(", ").append("Host Name: ").append(this.m_hostName).append(", ").append("Service Name: ").append(this.m_serviceName).toString();
    }

    public String getInstance() {
        return this.getDataSourceInstanceName();
    }

    public String getService() {
        return this.getServiceName();
    }

    public String getHost() {
        return this.getHostName();
    }

    public String getDatabase() {
        return this.getDbUniqueName();
    }

    public void abort() throws UniversalConnectionPoolException {
        this.abortPhysicalConnection();
    }

    public void close(boolean isConnectionBorrowed) throws UniversalConnectionPoolException {
        if (!isConnectionBorrowed) {
            this.m_cp.removeAndCloseOneAvailableConnection(this);
        } else {
            this.m_cp.closeConnection(this);
        }
    }

    static interface InvocationVector {
        public Class getConnClass();

        public Method getMethodAbort();

        public Method getMethodCancel();

        public Method getMethodIsUsable();

        public Method getMethodSetStatementCacheSize();

        public Method getMethodSetImplicitCachingEnabled();

        public Method getMethodSetExplicitCachingEnabled();

        public Method getMethodGetServerSessionInfo();

        public Method getMethodPingDatabase();

        public Method getMethodPingDatabaseInt();

        public Method getMethodGetVersionNumber();
    }
}

