/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.JDBCUniversalPooledConnection;
import oracle.ucp.jdbc.proxy.ResultSetProxyFactory;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.logging.UCPLoggerFactory;

public class StatementProxyFactory
implements InvocationHandler {
    private static final Logger logger = UCPLoggerFactory.createLogger(StatementProxyFactory.class.getCanonicalName());
    protected final Statement m_proxiedStatement;
    protected final Connection m_proxyConnection;
    protected final JDBCUniversalPooledConnection m_jdbcPooledConnection;
    protected final JDBCConnectionPool m_jdbcConnectionPool;
    protected boolean m_closed = false;
    private static final Map<String, SwitchTable> m_invokeSwitchTable = new HashMap<String, SwitchTable>();
    private static final Map<Class, Class[]> m_mapInterfaces;

    public static Object createStatementProxy(Object proxiedStatement, Object proxyConnection, JDBCConnectionPool jdbcConnectionPool, JDBCUniversalPooledConnection jdbcPooledConnection) throws UniversalConnectionPoolException {
        Object stmtProxy = Proxy.newProxyInstance(proxyConnection.getClass().getClassLoader(), StatementProxyFactory.createInterfaces(proxiedStatement), (InvocationHandler)new StatementProxyFactory(proxiedStatement, proxyConnection, jdbcConnectionPool, jdbcPooledConnection));
        logger.log(Level.FINEST, "returns {1}", stmtProxy);
        return stmtProxy;
    }

    protected StatementProxyFactory(Object proxiedStatement, Object proxyConnection, JDBCConnectionPool jdbcConnectionPool, JDBCUniversalPooledConnection jdbcPooledConnection) throws UniversalConnectionPoolException {
        int errCode;
        if (jdbcPooledConnection == null) {
            errCode = 150;
        } else if (jdbcConnectionPool == null) {
            errCode = 54;
        } else if (!(proxyConnection instanceof Connection)) {
            errCode = 259;
        } else if (!(proxiedStatement instanceof Statement)) {
            errCode = 265;
        } else {
            this.setStatementPooling(proxiedStatement, jdbcPooledConnection.getMaxStatements() > 0);
            this.m_proxiedStatement = (Statement)proxiedStatement;
            this.m_proxyConnection = (Connection)proxyConnection;
            this.m_jdbcConnectionPool = jdbcConnectionPool;
            this.m_jdbcPooledConnection = jdbcPooledConnection;
            return;
        }
        UniversalConnectionPoolException e = UCPErrorHandler.newUniversalConnectionPoolException(errCode);
        logger.throwing(this.getClass().getName(), "StatementProxyFactory", e);
        throw e;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.m_jdbcPooledConnection.heartbeat();
        SwitchTable invokeSwitch = m_invokeSwitchTable.get(method.getName());
        if (null == invokeSwitch) {
            invokeSwitch = SwitchTable._ABSENT;
        }
        switch (invokeSwitch) {
            case OBJECT_EQUALS: {
                return new Boolean(proxy == args[0]);
            }
            case OBJECT_HASHCODE: {
                return new Integer(System.identityHashCode(proxy));
            }
            case OBJECT_TOSTRING: {
                return proxy.getClass().getName() + "@" + Integer.toHexString(proxy.hashCode());
            }
        }
        if (!this.m_closed && SwitchTable.GETCONNECTION == invokeSwitch) {
            return this.m_proxyConnection;
        }
        UniversalPooledConnectionStatus status = this.m_jdbcPooledConnection.getStatus();
        Object result = null;
        try {
            if (SwitchTable.CLOSE == invokeSwitch) {
                if (this.m_closed) {
                    return null;
                }
                this.m_closed = true;
            } else {
                if (this.m_closed) {
                    throw UCPErrorHandler.newSQLException(31);
                }
                if (status == UniversalPooledConnectionStatus.STATUS_CLOSED || status == UniversalPooledConnectionStatus.STATUS_BAD) {
                    throw UCPErrorHandler.newSQLException(31);
                }
            }
            result = method.invoke((Object)this.m_proxiedStatement, args);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = e.getCause();
            }
            logger.throwing(this.getClass().getName(), "invoke", e);
            throw e;
        }
        this.m_jdbcPooledConnection.heartbeat();
        if (SwitchTable._REST == invokeSwitch) {
            return ResultSetProxyFactory.createResultSetProxy(result, proxy, this.m_jdbcConnectionPool, this.m_jdbcPooledConnection);
        }
        return result;
    }

    protected static Class[] createInterfaces(Object object) {
        Class<?> objectClass = object.getClass();
        Class[] interfaces = m_mapInterfaces.get(objectClass);
        if (null != interfaces) {
            return interfaces;
        }
        HashSet interfacesSet = new HashSet();
        StatementProxyFactory.addInterfaces(interfacesSet, object.getClass());
        interfaces = interfacesSet.toArray(new Class[0]);
        m_mapInterfaces.put(objectClass, interfaces);
        return interfaces;
    }

    protected static void addInterfaces(HashSet interfaces, Class type) {
        if (type == null) {
            return;
        }
        Class<?>[] proxyInterfaces = type.getInterfaces();
        for (int i = 0; i < proxyInterfaces.length; ++i) {
            Class<?> proxyInterface = proxyInterfaces[i];
            interfaces.add(proxyInterface);
        }
        StatementProxyFactory.addInterfaces(interfaces, type.getSuperclass());
    }

    private void setStatementPooling(Object statementObj, boolean poolable) {
        logger.log(Level.FINEST, "statementObj={0}, poolable={1}", new Object[]{statementObj, poolable});
        if (statementObj != null) {
            try {
                statementObj.getClass().getMethod("setPoolable", Boolean.TYPE).invoke(statementObj, poolable);
                logger.finest("setPoolable() is successfully invoked");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        m_invokeSwitchTable.put("close", SwitchTable.CLOSE);
        m_invokeSwitchTable.put("getConnection", SwitchTable.GETCONNECTION);
        m_invokeSwitchTable.put("executeQuery", SwitchTable._REST);
        m_invokeSwitchTable.put("getResultSet", SwitchTable._REST);
        m_invokeSwitchTable.put("getGeneratedKeys", SwitchTable._REST);
        m_invokeSwitchTable.put("equals", SwitchTable.OBJECT_EQUALS);
        m_invokeSwitchTable.put("hashCode", SwitchTable.OBJECT_HASHCODE);
        m_invokeSwitchTable.put("toString", SwitchTable.OBJECT_TOSTRING);
        m_mapInterfaces = new HashMap<Class, Class[]>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SwitchTable {
        CLOSE,
        GETCONNECTION,
        _REST,
        _ABSENT,
        OBJECT_EQUALS,
        OBJECT_HASHCODE,
        OBJECT_TOSTRING;

    }
}

